/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.qtp.socket;

import com.devexperts.connector.proto.ApplicationConnection;
import com.devexperts.io.Chunk;
import com.devexperts.io.ChunkList;
import com.devexperts.qd.qtp.QTPWorkerThread;
import com.devexperts.qd.qtp.socket.SocketHandler;
import com.devexperts.util.SystemProperties;
import com.devexperts.util.TimePeriod;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.locks.LockSupport;

class SocketWriter
extends QTPWorkerThread {
    private static final long WARN_TIMEOUT_NANOS = TimePeriod.valueOf(SystemProperties.getProperty("com.devexperts.qd.qtp.socket.writerWarnTimeout", "15s")).getNanos();
    private static final long MAX_WAIT_TIME = TimePeriod.valueOf(SystemProperties.getProperty(SocketWriter.class, "maxWaitTime", "1m")).getTime();
    private static final AtomicIntegerFieldUpdater<SocketWriter> STATE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(SocketWriter.class, "state");
    private static final int STATE_IDLE = 0;
    private static final int STATE_AVAILABLE = 1;
    private static final int STATE_PARKED = 2;
    private final SocketHandler handler;
    private volatile int state = 0;

    SocketWriter(SocketHandler handler) {
        super(handler + "-Writer");
        this.handler = handler;
    }

    private boolean casState(int expect, int update) {
        return STATE_UPDATER.compareAndSet(this, expect, update);
    }

    @Override
    protected void doWork() throws InterruptedException, IOException {
        SocketHandler.ThreadData threadData = this.handler.initThreadData();
        if (threadData == null) {
            return;
        }
        OutputStream out = threadData.socket.getOutputStream();
        while (!this.isClosed()) {
            if (this.state != 1 && this.waitAvailableOrClosed(threadData.connection)) {
                return;
            }
            assert (this.state == 1);
            this.state = 0;
            long startTimeNanos = System.nanoTime();
            ChunkList chunks = threadData.connection.retrieveChunks(this);
            long deltaTimeNanos = System.nanoTime() - startTimeNanos;
            if (deltaTimeNanos > WARN_TIMEOUT_NANOS) {
                this.log.warn("retrieveChunks took " + deltaTimeNanos + " ns");
            }
            if (chunks == null) continue;
            for (Chunk chunk : chunks) {
                if (this.handler.verbose && this.log.debugEnabled()) {
                    this.log.debug(SocketHandler.verboseBytesToString("Sending", chunk.getBytes(), chunk.getOffset(), chunk.getLength()));
                }
                out.write(chunk.getBytes(), chunk.getOffset(), chunk.getLength());
                threadData.connectionStats.addWrittenBytes(chunk.getLength());
            }
            chunks.recycle(this);
        }
    }

    private boolean waitAvailableOrClosed(ApplicationConnection<?> connection) throws InterruptedException {
        do {
            long waitTime;
            long currentTime = System.currentTimeMillis();
            long examineTime = connection.examine(currentTime);
            if (this.isClosed()) {
                return true;
            }
            if (this.state == 1) {
                return false;
            }
            if (examineTime <= currentTime) {
                this.log.warn("INVARIANT VIOLATION DETECTED: examineTime <= currentTime but chunks are not available");
                examineTime = currentTime + 10L;
            }
            if ((waitTime = examineTime - currentTime) < 0L || waitTime > MAX_WAIT_TIME) {
                waitTime = MAX_WAIT_TIME;
            }
            if (!this.casState(0, 2)) {
                return false;
            }
            this.doPark(waitTime);
        } while (this.casState(2, 0));
        return false;
    }

    private void doPark(long waitTime) {
        boolean verboseDebug;
        boolean bl = verboseDebug = this.handler.verbose && this.log.debugEnabled();
        if (verboseDebug) {
            this.log.debug("Parking for " + waitTime + " ms until more data is ready to send");
        }
        LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(waitTime));
        if (verboseDebug) {
            this.log.debug("Unparked");
        }
    }

    @Override
    protected void handleShutdown() {
        this.handler.stopConnector();
    }

    @Override
    protected void handleClose(Throwable reason) {
        this.handler.exitSocket(reason);
    }

    void chunksAvailable() {
        int state = this.state;
        if (state == 0 ? this.casState(0, 1) : state == 1) {
            return;
        }
        this.state = 1;
        LockSupport.unpark(this);
    }
}

