/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.qtp.socket;

import com.devexperts.qd.qtp.AddressSyntaxException;
import com.devexperts.qd.qtp.socket.SocketAddress;
import com.devexperts.util.LogUtil;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;

public class SocketUtil {
    public static String getAcceptedSocketAddress(Socket socket) {
        return socket.getInetAddress().getHostAddress() + ":" + socket.getPort() + "->" + socket.getLocalAddress().getHostAddress() + ":" + socket.getLocalPort();
    }

    public static List<SocketAddress> parseAddressList(String hostNames, int defaultPort) {
        ArrayList<SocketAddress> result = new ArrayList<SocketAddress>();
        String[] stringArray = hostNames.split(",");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String addressString;
            String host = addressString = stringArray[i];
            int port = defaultPort;
            int colonPos = addressString.lastIndexOf(58);
            if (colonPos >= 0 && colonPos > addressString.lastIndexOf(93)) {
                try {
                    port = Integer.parseInt(addressString.substring(colonPos + 1));
                    host = addressString.substring(0, colonPos);
                }
                catch (NumberFormatException e) {
                    throw new AddressSyntaxException("Failed to parse port from address \"" + LogUtil.hideCredentials(addressString) + "\"", e);
                }
            }
            if (host.startsWith("[")) {
                if (!host.endsWith("]")) {
                    throw new AddressSyntaxException("An expected closing square bracket is not found in address \"" + LogUtil.hideCredentials(addressString) + "\"");
                }
                host = host.substring(1, host.length() - 1);
            } else if (host.contains(":")) {
                throw new AddressSyntaxException("IPv6 numeric address must be enclosed in square brackets in address \"" + LogUtil.hideCredentials(addressString) + "\"");
            }
            result.add(new SocketAddress(host, port));
        }
        return result;
    }

    private SocketUtil() {
    }
}

