/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.qtp.socket;

import com.devexperts.qd.qtp.socket.SocketInfo;
import com.devexperts.util.SystemProperties;
import com.devexperts.util.TimePeriod;
import java.net.Socket;
import java.net.SocketException;

abstract class SocketSource {
    private static final String SO_TIMEOUT_PROPERTY = "com.devexperts.qd.qtp.socket.soTimeout";
    private static final long SO_TIMEOUT = TimePeriod.valueOf(SystemProperties.getProperty("com.devexperts.qd.qtp.socket.soTimeout", "5m")).getTime();

    SocketSource() {
    }

    public void markForImmediateRestart() {
    }

    public abstract SocketInfo nextSocket() throws InterruptedException;

    protected static void configureSocket(Socket socket) throws SocketException {
        socket.setKeepAlive(true);
        socket.setTcpNoDelay(true);
        if (SO_TIMEOUT > 0L) {
            socket.setSoTimeout((int)SO_TIMEOUT);
        }
    }

    static {
        if (SO_TIMEOUT < 0L || SO_TIMEOUT > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Invalid com.devexperts.qd.qtp.socket.soTimeout");
        }
    }
}

