/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.qtp.socket;

import com.devexperts.connector.proto.AbstractTransportConnection;
import com.devexperts.connector.proto.ApplicationConnection;
import com.devexperts.connector.proto.ApplicationConnectionFactory;
import com.devexperts.io.ChunkPool;
import com.devexperts.logging.Logging;
import com.devexperts.qd.qtp.AbstractMessageConnector;
import com.devexperts.qd.qtp.MessageConnectorState;
import com.devexperts.qd.qtp.MessageConnectors;
import com.devexperts.qd.qtp.socket.ServerSocketSource;
import com.devexperts.qd.qtp.socket.SocketAddress;
import com.devexperts.qd.qtp.socket.SocketInfo;
import com.devexperts.qd.qtp.socket.SocketReader;
import com.devexperts.qd.qtp.socket.SocketSource;
import com.devexperts.qd.qtp.socket.SocketState;
import com.devexperts.qd.qtp.socket.SocketWriter;
import com.devexperts.qd.stats.QDStats;
import com.devexperts.transport.stats.ConnectionStats;
import com.devexperts.util.JMXNameBuilder;
import com.devexperts.util.LogUtil;
import com.devexperts.util.SystemProperties;
import java.io.IOException;
import java.net.Socket;

class SocketHandler
extends AbstractTransportConnection
implements AbstractMessageConnector.Joinable {
    private static final String VERBOSE = SystemProperties.getProperty("com.devexperts.qd.qtp.socket.verbose", null);
    private final Logging log;
    final AbstractMessageConnector connector;
    private final SocketSource socketSource;
    final ChunkPool chunkPool;
    final boolean verbose;
    private SocketReader reader;
    private SocketWriter writer;
    private volatile ThreadData threadData;
    private volatile CloseListener closeListener;
    private volatile SocketState state = SocketState.NEW;
    private static final char[] HEX = "0123456789ABCDEF".toCharArray();

    SocketHandler(AbstractMessageConnector connector, SocketSource socketSource) {
        this.connector = connector;
        this.log = connector.getLogging();
        this.socketSource = socketSource;
        this.chunkPool = connector.getFactory().getChunkPool();
        this.verbose = VERBOSE != null && connector.getName().contains(VERBOSE);
    }

    public String getHost() {
        ThreadData threadData = this.threadData;
        return threadData != null ? threadData.address.host : "";
    }

    public int getPort() {
        ThreadData threadData = this.threadData;
        return threadData != null ? threadData.address.port : 0;
    }

    public MessageConnectorState getHandlerState() {
        return this.state.state;
    }

    public boolean isConnected() {
        return this.state == SocketState.CONNECTED;
    }

    ConnectionStats getActiveConnectionStats() {
        ThreadData threadData = this.threadData;
        return threadData == null ? null : threadData.connectionStats;
    }

    public void setCloseListener(CloseListener listener) {
        this.closeListener = listener;
    }

    public synchronized void start() {
        if (this.state != SocketState.NEW) {
            return;
        }
        this.state = SocketState.STARTED;
        this.reader = new SocketReader(this);
        this.writer = new SocketWriter(this);
        int threadPriority = this.connector.getThreadPriority();
        this.reader.setPriority(threadPriority);
        this.writer.setPriority(threadPriority);
        this.reader.start();
        this.writer.start();
        this.notifyAll();
    }

    public void close() {
        this.closeSocketImpl(null);
    }

    @Override
    public void join() throws InterruptedException {
        this.reader.join();
        this.writer.join();
    }

    public void exitSocket(Throwable reason) {
        this.closeSocketImpl(reason);
    }

    public void stopConnector() {
        this.connector.stop();
    }

    private void closeSocketImpl(Throwable reason) {
        CloseListener listener;
        if (!this.makeClosed()) {
            return;
        }
        ThreadData threadData = this.threadData;
        if (threadData != null) {
            this.threadData = null;
            this.cleanupThreadData(threadData, reason);
        }
        if ((listener = this.closeListener) != null) {
            listener.handlerClosed(this);
        }
        this.connector.notifyMessageConnectorListeners();
    }

    public String toString() {
        return this.socketSource.toString();
    }

    private void cleanupThreadData(ThreadData threadData, Throwable reason) {
        this.cleanupConnection(threadData.connection);
        this.cleanupStats(threadData.stats);
        this.connector.addClosedConnectionStats(threadData.connectionStats);
        this.cleanupSocket(threadData.socket, threadData.address, reason);
    }

    private void cleanupConnection(ApplicationConnection<?> connection) {
        try {
            connection.close();
        }
        catch (Throwable t) {
            this.log.error("Failed to close connection", t);
        }
    }

    private void cleanupStats(QDStats stats) {
        try {
            stats.close();
        }
        catch (Throwable t) {
            this.log.error("Failed to close stats", t);
        }
    }

    private void cleanupSocket(Socket socket, SocketAddress address, Throwable reason) {
        try {
            socket.close();
            if (reason == null || reason instanceof IOException && this.socketSource instanceof ServerSocketSource) {
                this.log.info("Disconnected from " + LogUtil.hideCredentials(address) + (reason == null ? "" : " because of " + (reason.getMessage() == null ? reason.toString() : reason.getMessage())));
            } else {
                this.log.error("Disconnected from " + LogUtil.hideCredentials(address), reason);
            }
        }
        catch (Throwable t) {
            this.log.error("Error occurred while disconnecting from " + LogUtil.hideCredentials(address), t);
        }
    }

    ThreadData initThreadData() throws InterruptedException {
        QDStats stats;
        if (!this.makeConnecting()) {
            return this.waitConnected();
        }
        this.connector.notifyMessageConnectorListeners();
        SocketInfo socketInfo = this.socketSource.nextSocket();
        if (socketInfo == null) {
            return null;
        }
        Socket socket = socketInfo.socket;
        this.variables().set(MessageConnectors.SOCKET_KEY, socket);
        this.variables().set(REMOTE_HOST_ADDRESS_KEY, socketInfo.socketAddress.host);
        ConnectionStats connectionStats = new ConnectionStats();
        try {
            stats = this.connector.getStats().getOrCreate(QDStats.SType.CONNECTIONS).create(QDStats.SType.CONNECTION, "host=" + JMXNameBuilder.quoteKeyPropertyValue(socketInfo.socketAddress.host) + ",port=" + socketInfo.socketAddress.port + ",localPort=" + socket.getLocalPort());
            if (stats == null) {
                throw new NullPointerException("Stats were not created");
            }
        }
        catch (Throwable t) {
            this.log.error("Failed to configure socket " + LogUtil.hideCredentials(socketInfo.socketAddress), t);
            this.connector.addClosedConnectionStats(connectionStats);
            this.cleanupSocket(socket, socketInfo.socketAddress, null);
            return null;
        }
        this.variables().set(MessageConnectors.STATS_KEY, stats);
        ApplicationConnection<?> connection = null;
        Throwable failureReason = null;
        try {
            ApplicationConnectionFactory acf = this.connector.getFactory();
            connection = acf.createConnection(this);
        }
        catch (Throwable t) {
            failureReason = t;
        }
        if (connection == null) {
            this.log.error("Failed to create connection on socket " + LogUtil.hideCredentials(socketInfo.socketAddress), failureReason);
            this.cleanupStats(stats);
            this.connector.addClosedConnectionStats(connectionStats);
            this.cleanupSocket(socket, socketInfo.socketAddress, null);
            return null;
        }
        connection.start();
        ThreadData threadData = new ThreadData(socketInfo, connection, stats, connectionStats);
        boolean connected = this.makeConnected(threadData);
        if (!connected) {
            this.cleanupThreadData(threadData, failureReason);
            return null;
        }
        this.connector.notifyMessageConnectorListeners();
        return threadData;
    }

    private synchronized boolean makeConnecting() {
        if (this.state == SocketState.STARTED) {
            this.state = SocketState.CONNECTING;
            this.notifyAll();
            return true;
        }
        return false;
    }

    private synchronized boolean makeConnected(ThreadData threadData) {
        if (this.state == SocketState.CONNECTING) {
            this.state = SocketState.CONNECTED;
            this.threadData = threadData;
            this.notifyAll();
            return true;
        }
        return false;
    }

    private synchronized ThreadData waitConnected() throws InterruptedException {
        while (this.state == SocketState.CONNECTING) {
            this.wait();
        }
        if (this.state == SocketState.CONNECTED) {
            return this.threadData;
        }
        if (this.state == SocketState.STOPPED) {
            return null;
        }
        throw new IllegalStateException();
    }

    private synchronized boolean makeClosed() {
        if (this.state == SocketState.STOPPED) {
            return false;
        }
        if (this.state != SocketState.NEW) {
            this.reader.close();
            this.writer.close();
        }
        this.state = SocketState.STOPPED;
        this.notifyAll();
        return true;
    }

    static String verboseBytesToString(String prefix, byte[] bytes, int offset, int length) {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append(" ").append(length).append(" bytes [");
        for (i = 0; i < length && i < 16; ++i) {
            int b = bytes[offset + i] & 0xFF;
            sb.append(i == 0 ? "" : " ");
            sb.append(HEX[b >> 4]);
            sb.append(HEX[b & 0xF]);
        }
        if (i < length) {
            sb.append("...");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void markForImmediateRestart() {
        this.socketSource.markForImmediateRestart();
    }

    @Override
    public void connectionClosed() {
        this.close();
    }

    @Override
    public void chunksAvailable() {
        this.writer.chunksAvailable();
    }

    @Override
    public void readyToProcessChunks() {
        this.reader.readyToProcess();
    }

    static class ThreadData {
        final Socket socket;
        final SocketAddress address;
        final ApplicationConnection<?> connection;
        final QDStats stats;
        final ConnectionStats connectionStats;

        ThreadData(SocketInfo socketInfo, ApplicationConnection<?> connection, QDStats stats, ConnectionStats connectionStats) {
            this.socket = socketInfo.socket;
            this.address = socketInfo.socketAddress;
            this.connection = connection;
            this.stats = stats;
            this.connectionStats = connectionStats;
        }
    }

    public static interface CloseListener {
        public void handlerClosed(SocketHandler var1);
    }
}

