/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.qtp.socket;

import com.devexperts.logging.Logging;
import com.devexperts.qd.qtp.QTPWorkerThread;
import com.devexperts.qd.qtp.ReconnectHelper;
import com.devexperts.qd.qtp.socket.ServerSocketConnector;
import com.devexperts.qd.qtp.socket.ServerSocketSource;
import com.devexperts.qd.qtp.socket.ServerSocketTestHelper;
import com.devexperts.qd.qtp.socket.SocketHandler;
import com.devexperts.qd.qtp.socket.SocketUtil;
import com.devexperts.util.LogUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import javax.net.ServerSocketFactory;

class SocketAcceptor
extends QTPWorkerThread {
    private static final Logging log = Logging.getLogging(ServerSocketConnector.class);
    private final ServerSocketConnector connector;
    private final int port;
    private final InetAddress bindAddress;
    private final String address;
    private final ReconnectHelper reconnectHelper;
    private volatile ServerSocket serverSocket;

    SocketAcceptor(ServerSocketConnector connector) {
        super(connector.getName() + "-" + (connector.getTls() ? "tls+" : "") + ":" + connector.getLocalPort() + (connector.bindAddr == null || connector.bindAddr.isAnyLocalAddress() ? "" : "[bindaddr=" + connector.bindAddr.getHostAddress() + "]") + "-Acceptor");
        this.connector = connector;
        this.port = connector.getLocalPort();
        this.bindAddress = connector.bindAddr;
        this.address = connector.getAddress();
        this.reconnectHelper = new ReconnectHelper(connector.getReconnectDelay());
    }

    public boolean isConnected() {
        return this.serverSocket != null;
    }

    @Override
    protected void doWork() throws InterruptedException, IOException {
        while (!this.isClosed()) {
            ServerSocket serverSocket = this.serverSocket;
            if (serverSocket == null) {
                if (this.isClosed()) {
                    return;
                }
                this.reconnectHelper.sleepBeforeConnection();
                log.info("Trying to listen at " + LogUtil.hideCredentials(this.address));
                try {
                    serverSocket = this.serverSocket = ServerSocketFactory.getDefault().createServerSocket(this.port, 0, this.bindAddress);
                    ServerSocketTestHelper.completePortPromise(this.connector.getName(), serverSocket.getLocalPort());
                }
                catch (Throwable t) {
                    log.error("Failed to listen at " + LogUtil.hideCredentials(this.address), t);
                    ServerSocketTestHelper.failPortPromise(this.connector.getName(), t);
                    continue;
                }
                log.info("Listening at " + LogUtil.hideCredentials(this.address) + (this.port == 0 ? " on port " + serverSocket.getLocalPort() : ""));
                this.connector.notifyMessageConnectorListeners();
                if (this.isClosed()) {
                    return;
                }
            }
            Socket socket = serverSocket.accept();
            if (!this.connector.isNewConnectionAllowed()) {
                log.warn("Rejected client socket connection because of maxConnections limit: " + LogUtil.hideCredentials(SocketUtil.getAcceptedSocketAddress(socket)));
                socket.close();
                continue;
            }
            log.info("Accepted client socket connection: " + LogUtil.hideCredentials(SocketUtil.getAcceptedSocketAddress(socket)));
            SocketHandler handler = new SocketHandler(this.connector, new ServerSocketSource(socket));
            this.connector.addHandler(handler);
            handler.setCloseListener(this.connector.closeListener);
            handler.start();
            if (!this.isClosed()) continue;
            handler.close();
        }
    }

    @Override
    protected void handleShutdown() {
        this.connector.stop();
    }

    @Override
    protected void handleClose(Throwable reason) {
        this.closeSocketImpl(reason);
    }

    private synchronized ServerSocket takeSocket() {
        ServerSocket result = this.serverSocket;
        this.serverSocket = null;
        return result;
    }

    protected void closeSocketImpl(Throwable reason) {
        this.closeServerSocket(this.takeSocket(), reason);
    }

    private void closeServerSocket(ServerSocket serverSocket, Throwable reason) {
        if (serverSocket != null) {
            try {
                serverSocket.close();
                if (reason == null) {
                    log.info("Stopped listening at " + LogUtil.hideCredentials(this.address));
                } else {
                    log.error("Stopped listening at " + LogUtil.hideCredentials(this.address), reason);
                }
            }
            catch (Throwable t) {
                log.error("Failed to close server socket " + LogUtil.hideCredentials(this.address), t);
            }
        }
    }
}

