/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.qtp.socket;

import com.devexperts.logging.Logging;
import com.devexperts.qd.qtp.socket.ServerSocketConnector;
import com.devexperts.qd.qtp.socket.SocketAddress;
import com.devexperts.qd.qtp.socket.SocketInfo;
import com.devexperts.qd.qtp.socket.SocketSource;
import com.devexperts.qd.qtp.socket.SocketUtil;
import com.devexperts.util.LogUtil;
import java.net.Socket;

class ServerSocketSource
extends SocketSource {
    private static final Logging log = Logging.getLogging(ServerSocketConnector.class);
    private final Socket socket;

    public ServerSocketSource(Socket socket) {
        this.socket = socket;
    }

    @Override
    public SocketInfo nextSocket() {
        try {
            ServerSocketSource.configureSocket(this.socket);
            return new SocketInfo(this.socket, new SocketAddress(this.socket.getInetAddress().getHostAddress(), this.socket.getPort()));
        }
        catch (Throwable t) {
            try {
                log.error("Failed to configure socket " + LogUtil.hideCredentials(SocketUtil.getAcceptedSocketAddress(this.socket)), t);
                this.socket.close();
            }
            catch (Throwable tt) {
                log.error("Failed to close socket " + LogUtil.hideCredentials(SocketUtil.getAcceptedSocketAddress(this.socket)), t);
            }
            return null;
        }
    }

    public String toString() {
        return SocketUtil.getAcceptedSocketAddress(this.socket);
    }
}

