/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.qtp.socket;

import com.devexperts.connector.codec.CodecConnectionFactory;
import com.devexperts.connector.codec.CodecFactory;
import com.devexperts.connector.proto.ApplicationConnectionFactory;
import com.devexperts.connector.proto.ConfigurationKey;
import com.devexperts.qd.QDFactory;
import com.devexperts.qd.QDLog;
import com.devexperts.qd.qtp.AbstractMessageConnector;
import com.devexperts.qd.qtp.MessageAdapter;
import com.devexperts.qd.qtp.MessageConnector;
import com.devexperts.qd.qtp.MessageConnectorState;
import com.devexperts.qd.qtp.MessageConnectors;
import com.devexperts.qd.qtp.help.MessageConnectorProperty;
import com.devexperts.qd.qtp.help.MessageConnectorSummary;
import com.devexperts.qd.qtp.socket.ServerSocketConnectorMBean;
import com.devexperts.qd.qtp.socket.SocketAcceptor;
import com.devexperts.qd.qtp.socket.SocketHandler;
import com.devexperts.qd.stats.QDStats;
import com.devexperts.qd.util.QDConfig;
import com.devexperts.services.Services;
import com.devexperts.transport.stats.ConnectionStats;
import com.devexperts.transport.stats.EndpointStats;
import com.devexperts.util.LogUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Set;

@MessageConnectorSummary(info="Creates server TCP/IP socket connection.", addressFormat=":<port>")
public class ServerSocketConnector
extends AbstractMessageConnector
implements ServerSocketConnectorMBean {
    private static final String BIND_ANY_ADDRESS = "*";
    protected int port;
    protected String bindAddrString = "*";
    protected InetAddress bindAddr;
    protected boolean useTls;
    protected int maxConnections;
    protected final Set<SocketHandler> handlers = new HashSet<SocketHandler>();
    protected final SocketHandler.CloseListener closeListener = this::handlerClosed;
    protected volatile SocketAcceptor acceptor;

    @Deprecated
    public ServerSocketConnector(MessageAdapter.Factory factory, int port) {
        this(MessageConnectors.applicationConnectionFactory(factory), port);
    }

    public ServerSocketConnector(ApplicationConnectionFactory factory, int port) {
        super(factory);
        QDConfig.setDefaultProperties(this, ServerSocketConnectorMBean.class, MessageConnector.class.getName());
        QDConfig.setDefaultProperties(this, ServerSocketConnectorMBean.class, ServerSocketConnector.class.getName());
        this.port = port;
    }

    @Override
    public String getAddress() {
        return this.bindAddrString + ":" + this.port;
    }

    @Override
    public synchronized void setLocalPort(int port) {
        if (this.port != port) {
            this.log.info("Setting localPort=" + port);
            this.port = port;
            this.reconfigure();
        }
    }

    @Override
    public int getLocalPort() {
        return this.port;
    }

    @Override
    public String getBindAddr() {
        return this.bindAddrString;
    }

    @Override
    @MessageConnectorProperty(value="Network interface address to bind socket to")
    public synchronized void setBindAddr(String bindAddrString) throws UnknownHostException {
        if (bindAddrString == null) {
            bindAddrString = BIND_ANY_ADDRESS;
        }
        if (!bindAddrString.equals(this.bindAddrString)) {
            this.log.info("Setting bindAddr=" + bindAddrString);
            this.bindAddr = bindAddrString.isEmpty() ? null : InetAddress.getByName(bindAddrString);
            this.bindAddrString = bindAddrString;
            this.reconfigure();
        }
    }

    @Override
    public int getMaxConnections() {
        return this.maxConnections;
    }

    @Override
    @MessageConnectorProperty(value="Max number of connections allowed for connector")
    public synchronized void setMaxConnections(int maxConnections) {
        if (maxConnections != this.maxConnections) {
            this.log.info("Setting maxConnections=" + maxConnections);
            this.maxConnections = maxConnections;
            this.reconfigure();
        }
    }

    public boolean getTls() {
        return this.useTls;
    }

    @MessageConnectorProperty(value="Use SSLConnectionFactory", deprecated="Use tls or ssl codec in address string. For example tls+<address>")
    public synchronized void setTls(boolean useTls) {
        if (this.useTls != useTls) {
            if (useTls) {
                CodecFactory sslCodecFactory = Services.createService(CodecFactory.class, null, "com.devexperts.connector.codec.ssl.SSLCodecFactory");
                if (sslCodecFactory == null) {
                    this.log.error("SSLCodecFactory is not found. Using the SSL protocol is not supported");
                    return;
                }
                ApplicationConnectionFactory factory = sslCodecFactory.createCodec("ssl", this.getFactory());
                factory.setConfiguration(ConfigurationKey.create("isServer", String.class), "true");
                this.setFactory(factory);
            } else {
                CodecConnectionFactory sslFactory = (CodecConnectionFactory)this.getFactory();
                if (!sslFactory.getClass().getSimpleName().contains("SSLCodecFactory")) {
                    this.log.error("SSLCodecFactory not found. SSL protocol is not used");
                    return;
                }
                this.setFactory(sslFactory.getDelegate());
            }
            this.log.info("Setting useTls=" + useTls);
            this.useTls = useTls;
            this.reconfigure();
        }
        QDLog.log.warn("WARNING: DEPRECATED use \"setTls()\" method from program or \"tls\" property from address string. Use tls or ssl codec in address string. For example tls+<address>");
    }

    @Override
    public void setStats(QDStats stats) {
        super.setStats(stats);
        stats.addMBean("ServerSocketConnector", this);
    }

    @Override
    public boolean isActive() {
        return this.acceptor != null;
    }

    @Override
    public MessageConnectorState getState() {
        SocketAcceptor acceptor = this.acceptor;
        if (acceptor == null) {
            return MessageConnectorState.DISCONNECTED;
        }
        return acceptor.isConnected() ? MessageConnectorState.CONNECTED : MessageConnectorState.CONNECTING;
    }

    @Override
    public synchronized int getConnectionCount() {
        return this.handlers.size();
    }

    @Override
    public synchronized EndpointStats retrieveCompleteEndpointStats() {
        EndpointStats stats = super.retrieveCompleteEndpointStats();
        for (SocketHandler handler : this.handlers) {
            ConnectionStats connectionStats = handler.getActiveConnectionStats();
            if (connectionStats == null) continue;
            stats.addActiveConnectionCount(1L);
            stats.addConnectionStats(connectionStats);
        }
        return stats;
    }

    @Override
    public synchronized void start() {
        if (this.acceptor != null) {
            return;
        }
        this.log.info("Starting ServerSocketConnector to " + LogUtil.hideCredentials(this.getAddress()));
        if (this.getStats() == null) {
            QDFactory.getDefaultFactory();
            this.setStats(QDFactory.createStats(QDStats.SType.SERVER_SOCKET_CONNECTOR, null));
        }
        this.acceptor = new SocketAcceptor(this);
        this.acceptor.start();
    }

    @Override
    protected synchronized AbstractMessageConnector.Joinable stopImpl() {
        SocketAcceptor acceptor = this.acceptor;
        if (acceptor == null) {
            return null;
        }
        this.log.info("Stopping ServerSocketConnector");
        acceptor.close();
        acceptor.closeSocketImpl(null);
        this.acceptor = null;
        SocketHandler[] a = this.handlers.toArray(new SocketHandler[this.handlers.size()]);
        int i = a.length;
        while (--i >= 0) {
            a[i].close();
        }
        return new Stopped(acceptor, a);
    }

    protected synchronized void addHandler(SocketHandler handler) {
        if (this.acceptor == null) {
            handler.close();
        } else {
            this.handlers.add(handler);
        }
    }

    protected synchronized void handlerClosed(SocketHandler handler) {
        this.handlers.remove(handler);
    }

    protected synchronized boolean isNewConnectionAllowed() {
        return this.maxConnections == 0 || this.getConnectionCount() < this.maxConnections;
    }

    private static class Stopped
    implements AbstractMessageConnector.Joinable {
        private final SocketAcceptor acceptor;
        private final SocketHandler[] a;

        Stopped(SocketAcceptor acceptor, SocketHandler[] a) {
            this.acceptor = acceptor;
            this.a = a;
        }

        @Override
        public void join() throws InterruptedException {
            this.acceptor.join();
            for (SocketHandler handler : this.a) {
                handler.join();
            }
        }
    }
}

