/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.qtp.socket;

import com.devexperts.util.IndexedSet;
import com.devexperts.util.InvalidFormatException;
import java.util.Objects;

public class ConnectOrder {
    private static final IndexedSet<String, ConnectOrder> VALUES = IndexedSet.create(ConnectOrder::getName);
    public static final ConnectOrder SHUFFLE = ConnectOrder.register("shuffle", true, false);
    public static final ConnectOrder RANDOM = ConnectOrder.register("random", true, true);
    public static final ConnectOrder ORDERED = ConnectOrder.register("ordered", false, false);
    public static final ConnectOrder PRIORITY = ConnectOrder.register("priority", false, true);
    private final String name;
    private final boolean randomized;
    private final boolean resetOnConnect;

    private ConnectOrder(String name, boolean randomized, boolean resetOnConnect) {
        this.name = Objects.requireNonNull(name);
        this.randomized = randomized;
        this.resetOnConnect = resetOnConnect;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectOrder that = (ConnectOrder)o;
        return this.name.equals(that.name);
    }

    private static ConnectOrder register(String name, boolean randomized, boolean resetOnConnect) {
        ConnectOrder order = new ConnectOrder(name, randomized, resetOnConnect);
        if (VALUES.put(order) != null) {
            throw new IllegalArgumentException("Duplicate ConnectOrder name '" + name + "'");
        }
        return order;
    }

    public static ConnectOrder valueOf(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        ConnectOrder connectOrder = VALUES.getByKey(name);
        if (connectOrder == null) {
            throw new InvalidFormatException("Unknown ConnectOrder '" + name + "'");
        }
        return connectOrder;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    boolean isRandomized() {
        return this.randomized;
    }

    boolean isResetOnConnect() {
        return this.resetOnConnect;
    }
}

