/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.qtp.socket;

import com.devexperts.logging.Logging;
import com.devexperts.qd.qtp.ReconnectHelper;
import com.devexperts.qd.qtp.socket.ClientSocketConnector;
import com.devexperts.qd.qtp.socket.ConnectOrder;
import com.devexperts.qd.qtp.socket.SocketAddress;
import com.devexperts.qd.qtp.socket.SocketInfo;
import com.devexperts.qd.qtp.socket.SocketSource;
import com.devexperts.qd.qtp.socket.SocketUtil;
import com.devexperts.util.LogUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

class ClientSocketSource
extends SocketSource {
    private static final Logging log = Logging.getLogging(ClientSocketConnector.class);
    private static final ConnectOrder DEFAULT_CONNECT_ORDER = ConnectOrder.SHUFFLE;
    private final ClientSocketConnector connector;
    private final ReconnectHelper resolveHelper;
    private final String hostNames;
    private final int port;
    private final ConnectOrder connectOrder;
    private final List<SocketAddress> parsedAddresses;
    private final Map<SocketAddress, ReconnectHelper> reconnectHelpers = new HashMap<SocketAddress, ReconnectHelper>();
    private final List<SocketAddress> resolvedAddresses = new ArrayList<SocketAddress>();
    private int currentAddress;

    ClientSocketSource(ClientSocketConnector connector) {
        this.connector = connector;
        this.resolveHelper = new ReconnectHelper(connector.getReconnectDelay());
        this.hostNames = connector.getHost();
        this.port = connector.getPort();
        ConnectOrder connectOrder = connector.getConnectOrder();
        if (connectOrder == null) {
            connectOrder = DEFAULT_CONNECT_ORDER;
        }
        this.connectOrder = connectOrder;
        this.parsedAddresses = SocketUtil.parseAddressList(this.hostNames, this.port);
    }

    @Override
    public void markForImmediateRestart() {
        this.resolveHelper.reset();
        this.reconnectHelpers.clear();
    }

    @Override
    public SocketInfo nextSocket() throws InterruptedException {
        SocketAddress address = this.nextAddress();
        if (address == null) {
            return null;
        }
        ReconnectHelper reconnectHelper = this.reconnectHelpers.get(address);
        if (reconnectHelper == null) {
            reconnectHelper = new ReconnectHelper(this.connector.getReconnectDelay());
            this.reconnectHelpers.put(address, reconnectHelper);
        }
        reconnectHelper.sleepBeforeConnection();
        log.info("Connecting to " + LogUtil.hideCredentials(address));
        Socket socket = null;
        try {
            String proxyHost = this.connector.getProxyHost();
            if (proxyHost.length() <= 0) {
                socket = new Socket(address.host, address.port);
                ClientSocketSource.configureSocket(socket);
            } else {
                String line;
                int proxyPort = this.connector.getProxyPort();
                log.info("Using HTTPS proxy: " + LogUtil.hideCredentials(proxyHost) + ":" + proxyPort);
                socket = new Socket(proxyHost, proxyPort);
                ClientSocketSource.configureSocket(socket);
                String connectRequest = "CONNECT " + address.host + ":" + address.port + " HTTP/1.0\r\n\r\n";
                socket.getOutputStream().write(connectRequest.getBytes());
                InputStream input = socket.getInputStream();
                String response = ClientSocketSource.readLine(input);
                if (response == null) {
                    throw new SocketException("HTTPS proxy closed connection");
                }
                String[] parts = response.split("[ \t]+");
                if (parts.length < 2 || !parts[0].equals("HTTP/1.0") && !parts[0].equals("HTTP/1.1") || !parts[1].equals("200")) {
                    throw new IOException("Unexpected response from HTTPS proxy: '" + response + "'");
                }
                while ((line = ClientSocketSource.readLine(input)) != null && line.length() > 0) {
                }
            }
        }
        catch (Throwable t) {
            log.error("Failed to connect to " + LogUtil.hideCredentials(address), t);
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Throwable tt) {
                    log.error("Failed to close socket " + LogUtil.hideCredentials(address), tt);
                }
            }
            return null;
        }
        if (this.connectOrder.isResetOnConnect()) {
            this.resolveHelper.reset();
            this.resolvedAddresses.clear();
            this.currentAddress = 0;
        }
        log.info("Connected to " + LogUtil.hideCredentials(address));
        return new SocketInfo(socket, address);
    }

    private static String readLine(InputStream in) throws IOException {
        int c = in.read();
        if (c < 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        while (c >= 0 && c != 10) {
            if (c != 13) {
                sb.append((char)c);
            }
            c = in.read();
        }
        return sb.toString();
    }

    private SocketAddress nextAddress() throws InterruptedException {
        ++this.currentAddress;
        if (this.currentAddress >= this.resolvedAddresses.size()) {
            this.resolveHelper.sleepBeforeConnection();
            this.resolveAddresses();
            this.currentAddress = 0;
        }
        if (this.resolvedAddresses.isEmpty()) {
            return null;
        }
        return this.resolvedAddresses.get(this.currentAddress);
    }

    public String toString() {
        return LogUtil.hideCredentials(this.hostNames) + (this.port == 0 ? "" : ":" + this.port);
    }

    private void resolveAddresses() {
        LinkedHashSet<SocketAddress> addresses = new LinkedHashSet<SocketAddress>();
        for (SocketAddress parsedAddress : this.parsedAddresses) {
            log.info("Resolving IPs for " + LogUtil.hideCredentials(parsedAddress.host));
            try {
                List<SocketAddress> hostAddresses = Arrays.stream(InetAddress.getAllByName(parsedAddress.host)).map(address -> new SocketAddress(address.getHostAddress(), parsedAddress.port)).collect(Collectors.toList());
                this.shuffleAddresses(hostAddresses);
                addresses.addAll(hostAddresses);
            }
            catch (UnknownHostException e) {
                log.warn("Failed to resolve IPs for " + LogUtil.hideCredentials(parsedAddress.host));
                addresses.add(new SocketAddress(parsedAddress.host, parsedAddress.port));
            }
        }
        this.resolvedAddresses.clear();
        this.resolvedAddresses.addAll(addresses);
        if (!addresses.isEmpty()) {
            this.reconnectHelpers.keySet().retainAll(addresses);
        }
        if (this.connectOrder.isRandomized()) {
            this.shuffleAddresses(this.resolvedAddresses);
        }
    }

    private void shuffleAddresses(List<SocketAddress> addresses) {
        if (addresses.size() > 1) {
            Collections.shuffle(addresses);
            int n = 0;
            for (int i = 0; i < addresses.size(); ++i) {
                if (!LocalAddressesCache.LOCAL_ADDRESSES.contains(addresses.get((int)i).host)) continue;
                if (i > n) {
                    addresses.add(n, addresses.remove(i));
                }
                ++n;
            }
        }
    }

    private static class LocalAddressesCache {
        static final Set<String> LOCAL_ADDRESSES = new HashSet<String>();

        private LocalAddressesCache() {
        }

        static {
            try {
                Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
                if (networkInterfaces != null) {
                    for (NetworkInterface ni : Collections.list(networkInterfaces)) {
                        for (InetAddress ia : Collections.list(ni.getInetAddresses())) {
                            LOCAL_ADDRESSES.add(ia.getHostAddress());
                        }
                    }
                }
            }
            catch (SocketException e) {
                log.warn("Cannot acquire a list of local address, will work without local address priority", e);
            }
        }
    }
}

