/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.qtp.socket;

import com.devexperts.connector.codec.CodecConnectionFactory;
import com.devexperts.connector.codec.CodecFactory;
import com.devexperts.connector.proto.ApplicationConnectionFactory;
import com.devexperts.qd.QDFactory;
import com.devexperts.qd.QDLog;
import com.devexperts.qd.qtp.AbstractMessageConnector;
import com.devexperts.qd.qtp.MessageAdapter;
import com.devexperts.qd.qtp.MessageConnector;
import com.devexperts.qd.qtp.MessageConnectorState;
import com.devexperts.qd.qtp.MessageConnectors;
import com.devexperts.qd.qtp.help.MessageConnectorProperty;
import com.devexperts.qd.qtp.help.MessageConnectorSummary;
import com.devexperts.qd.qtp.socket.ClientSocketConnectorMBean;
import com.devexperts.qd.qtp.socket.ClientSocketSource;
import com.devexperts.qd.qtp.socket.ConnectOrder;
import com.devexperts.qd.qtp.socket.SocketHandler;
import com.devexperts.qd.stats.QDStats;
import com.devexperts.qd.util.QDConfig;
import com.devexperts.services.Services;
import com.devexperts.transport.stats.ConnectionStats;
import com.devexperts.transport.stats.EndpointStats;
import com.devexperts.util.LogUtil;
import com.devexperts.util.SystemProperties;
import java.util.Objects;
import javax.net.ssl.TrustManager;

@MessageConnectorSummary(info="Connects to some host using TCP/IP client socket.", addressFormat="<host>:<port>")
public class ClientSocketConnector
extends AbstractMessageConnector
implements SocketHandler.CloseListener,
ClientSocketConnectorMBean {
    protected String host;
    protected int port;
    protected String proxyHost = SystemProperties.getProperty("https.proxyHost", "");
    protected int proxyPort = SystemProperties.getIntProperty("https.proxyPort", 80);
    protected boolean useTls;
    protected TrustManager trustManager;
    protected volatile SocketHandler handler;
    protected ClientSocketSource socketSource;
    protected ConnectOrder connectOrder;

    @Deprecated
    public ClientSocketConnector(MessageAdapter.Factory factory, String host, int port) {
        this(MessageConnectors.applicationConnectionFactory(factory), host, port);
    }

    public ClientSocketConnector(ApplicationConnectionFactory factory, String host, int port) {
        super(factory);
        if (host == null) {
            throw new NullPointerException();
        }
        QDConfig.setDefaultProperties(this, ClientSocketConnectorMBean.class, MessageConnector.class.getName());
        QDConfig.setDefaultProperties(this, ClientSocketConnectorMBean.class, ClientSocketConnector.class.getName());
        this.host = host;
        this.port = port;
    }

    @Override
    public String getAddress() {
        return this.host + ":" + this.port;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public synchronized void setHost(String host) {
        if (!host.equals(this.host)) {
            this.log.info("Setting host=" + LogUtil.hideCredentials(host));
            this.host = host;
            this.reconfigure();
        }
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public synchronized void setPort(int port) {
        if (port != this.port) {
            this.log.info("Setting port=" + port);
            this.port = port;
            this.reconfigure();
        }
    }

    @Override
    public String getProxyHost() {
        return this.proxyHost;
    }

    @Override
    @MessageConnectorProperty(value="HTTP proxy host name")
    public synchronized void setProxyHost(String proxyHost) {
        if (!proxyHost.equals(this.proxyHost)) {
            this.log.info("Setting proxyHost=" + LogUtil.hideCredentials(proxyHost));
            this.proxyHost = proxyHost;
            this.reconfigure();
        }
    }

    @Override
    public int getProxyPort() {
        return this.proxyPort;
    }

    @Override
    @MessageConnectorProperty(value="HTTP proxy port")
    public synchronized void setProxyPort(int proxyPort) {
        if (proxyPort != this.proxyPort) {
            this.log.info("Setting proxyPort=" + proxyPort);
            this.proxyPort = proxyPort;
            this.reconfigure();
        }
    }

    @Override
    public ConnectOrder getConnectOrder() {
        return this.connectOrder;
    }

    @Override
    @MessageConnectorProperty(value="Order of considering specified server addresses during connect/reconnect: \"shuffle\" (default), \"random\", \"ordered\", \"priority\"")
    public synchronized void setConnectOrder(ConnectOrder connectOrder) {
        if (!Objects.equals(connectOrder, this.connectOrder)) {
            this.log.info("Setting connectOrder=" + connectOrder);
            this.connectOrder = connectOrder;
            this.reconfigure();
        }
    }

    @Deprecated
    public boolean getTls() {
        return this.useTls;
    }

    @MessageConnectorProperty(value="Use SSLConnectionFactory", deprecated="Use tls or ssl codec in address string. For example tls+<address>")
    @Deprecated
    public synchronized void setTls(boolean useTls) {
        if (this.useTls != useTls) {
            if (useTls) {
                CodecFactory sslCodecFactory = Services.createService(CodecFactory.class, null, "com.devexperts.connector.codec.ssl.SSLCodecFactory");
                if (sslCodecFactory == null) {
                    this.log.error("SSLCodecFactory is not found. Using the SSL protocol is not supported");
                    return;
                }
                this.setFactory(sslCodecFactory.createCodec("ssl", this.getFactory()));
            } else {
                CodecConnectionFactory sslFactory = (CodecConnectionFactory)this.getFactory();
                if (!sslFactory.getClass().getSimpleName().contains("SSLCodecFactory")) {
                    this.log.error("SSLCodecFactory not found. SSL protocol is not used");
                    return;
                }
                this.setFactory(sslFactory.getDelegate());
            }
            this.useTls = useTls;
            this.log.info("Setting useTls=" + useTls);
            this.reconfigure();
        }
        QDLog.log.warn("WARNING: DEPRECATED use \"setTls()\" method from program or \"tls\" property from address string. Use tls or ssl codec in address string. For example tls+<address>");
    }

    @Deprecated
    public TrustManager getTrustManager() {
        return this.trustManager;
    }

    @Deprecated
    public void setTrustManager(TrustManager trustManager) {
        QDLog.log.warn("WARNING: DEPRECATED use \"setTrustManager()\" method on ClientSocketConnector. Use this method on SSL codec or in address string. For example tls+<address>");
        ApplicationConnectionFactory factory = this.getFactory();
        if (factory instanceof CodecConnectionFactory) {
            factory = factory.clone();
            ((CodecConnectionFactory)factory).setTrustManager(trustManager);
            this.setFactory(factory);
            this.reconfigure();
        }
    }

    @Override
    public void setStats(QDStats stats) {
        super.setStats(stats);
        stats.addMBean("ClientSocketConnector", this);
    }

    @Override
    public boolean isActive() {
        return this.handler != null;
    }

    @Override
    public MessageConnectorState getState() {
        SocketHandler handler = this.handler;
        return handler != null ? handler.getHandlerState() : MessageConnectorState.DISCONNECTED;
    }

    @Override
    public int getConnectionCount() {
        SocketHandler handler = this.handler;
        return handler != null && handler.isConnected() ? 1 : 0;
    }

    @Override
    public EndpointStats retrieveCompleteEndpointStats() {
        ConnectionStats connectionStats;
        EndpointStats stats = super.retrieveCompleteEndpointStats();
        SocketHandler handler = this.handler;
        if (handler != null && (connectionStats = handler.getActiveConnectionStats()) != null) {
            stats.addActiveConnectionCount(1L);
            stats.addConnectionStats(connectionStats);
        }
        return stats;
    }

    @Override
    public synchronized void start() {
        if (this.handler != null) {
            return;
        }
        this.log.info("Starting ClientSocketConnector to " + LogUtil.hideCredentials(this.getAddress()));
        if (this.getStats() == null) {
            QDFactory.getDefaultFactory();
            this.setStats(QDFactory.createStats(QDStats.SType.CLIENT_SOCKET_CONNECTOR, null));
        }
        if (this.socketSource == null) {
            this.socketSource = new ClientSocketSource(this);
        }
        this.handler = new SocketHandler(this, this.socketSource);
        this.handler.setCloseListener(this);
        this.handler.start();
    }

    @Override
    protected synchronized AbstractMessageConnector.Joinable stopImpl() {
        return this.stopImpl(true);
    }

    private AbstractMessageConnector.Joinable stopImpl(boolean fullStop) {
        if (fullStop) {
            this.socketSource = null;
        }
        SocketHandler handler = this.handler;
        this.handler = null;
        if (handler != null) {
            this.log.info("Stopping ClientSocketConnector");
            handler.close();
        }
        return handler;
    }

    @Override
    protected synchronized void restartImpl(boolean fullStop) {
        this.stopImpl(fullStop);
        this.start();
    }

    @Override
    public synchronized void handlerClosed(SocketHandler handler) {
        if (handler != this.handler) {
            return;
        }
        this.handler = null;
        this.start();
    }

    @Override
    public String getCurrentHost() {
        SocketHandler handler = this.handler;
        return handler != null ? handler.getHost() : "";
    }

    @Override
    public int getCurrentPort() {
        SocketHandler handler = this.handler;
        return handler != null ? handler.getPort() : 0;
    }
}

