/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.qtp.http;

import com.devexperts.connector.proto.AbstractTransportConnection;
import com.devexperts.connector.proto.ApplicationConnection;
import com.devexperts.connector.proto.TransportConnection;
import com.devexperts.io.Chunk;
import com.devexperts.io.ChunkList;
import com.devexperts.qd.qtp.AbstractConnectionHandler;
import com.devexperts.qd.qtp.MessageConnectors;
import com.devexperts.qd.qtp.ReconnectHelper;
import com.devexperts.qd.qtp.http.HttpConnector;
import com.devexperts.qd.stats.QDStats;
import com.devexperts.util.Base64;
import com.devexperts.util.LogUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.StandardCharsets;

class HttpConnectorHandler
extends AbstractConnectionHandler<HttpConnector> {
    private final String user;
    private final String password;
    private final int fetchCount;
    private final long fetchDelay;
    private final long updateDelay;
    private final String proxyHost;
    private final int proxyPort;
    private final ReconnectHelper reconnectHelper;
    private final Object messagesLock = new Object();
    private boolean messagesAvailable = true;
    private ApplicationConnection<?> applicationConnection;
    private QDStats stats;
    private boolean hasMore;
    private int fetchesLeft;
    private String cookie;
    private final TransportConnection transportConnection = new AbstractTransportConnection(){

        @Override
        public void markForImmediateRestart() {
            HttpConnectorHandler.this.reconnectHelper.reset();
        }

        @Override
        public void connectionClosed() {
            HttpConnectorHandler.this.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void chunksAvailable() {
            Object object = HttpConnectorHandler.this.messagesLock;
            synchronized (object) {
                HttpConnectorHandler.this.messagesAvailable = true;
                HttpConnectorHandler.this.messagesLock.notifyAll();
            }
        }

        @Override
        public void readyToProcessChunks() {
        }
    };

    HttpConnectorHandler(HttpConnector connector, ReconnectHelper reconnectHelper) {
        super(connector);
        this.reconnectHelper = reconnectHelper;
        this.setPriority(connector.getThreadPriority());
        this.user = connector.getUser();
        this.password = connector.getPassword();
        this.fetchCount = connector.getFetchCount();
        this.fetchDelay = connector.getFetchDelay();
        this.updateDelay = connector.getUpdateDelay();
        this.proxyHost = connector.getProxyHost();
        this.proxyPort = connector.getProxyPort();
    }

    @Override
    protected void closeImpl(Throwable reason) {
        QDStats stats;
        ApplicationConnection<?> connection = this.applicationConnection;
        if (connection != null) {
            connection.close();
        }
        if ((stats = this.stats) != null) {
            stats.close();
        }
        this.log.error("Disconnected from " + LogUtil.hideCredentials(this.address), reason);
    }

    private boolean doPost(URL url, ApplicationConnection<?> connection, boolean isNewConnection, QDStats stats) throws IOException {
        HttpURLConnection con;
        this.hasMore = false;
        HttpURLConnection httpURLConnection = con = this.proxyHost != null && this.proxyHost.length() > 0 ? (HttpURLConnection)url.openConnection(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.proxyHost, this.proxyPort))) : (HttpURLConnection)url.openConnection();
        if (isNewConnection) {
            con.setRequestProperty("X-NewConnection", "true");
        } else if (this.cookie != null) {
            con.setRequestProperty("Cookie", this.cookie);
        }
        if (this.user != null && this.password != null && this.user.length() > 0) {
            con.setRequestProperty("Authorization", "Basic " + Base64.DEFAULT.encode((this.user + ":" + this.password).getBytes(StandardCharsets.UTF_8)));
        }
        con.setUseCaches(false);
        con.setRequestMethod("POST");
        con.setDoOutput(true);
        this.writeMessages(con, connection);
        con.connect();
        int responseCode = con.getResponseCode();
        if (isNewConnection && responseCode == 405) {
            return false;
        }
        if (responseCode != 200) {
            String msg;
            String longMsg = msg = responseCode + " " + con.getResponseMessage();
            if (responseCode >= 400) {
                StringBuilder serverError = new StringBuilder();
                try (BufferedReader br = new BufferedReader(new InputStreamReader(con.getErrorStream()));){
                    String readLine;
                    while ((readLine = br.readLine()) != null) {
                        if (readLine.trim().length() == 0) continue;
                        serverError.append(readLine).append('\n');
                    }
                    longMsg = longMsg + "\nserver response follows: \n>====================\n" + serverError + "<======================";
                }
            }
            con.disconnect();
            this.log.error(longMsg);
            throw new IOException(msg);
        }
        if (this.cookie == null) {
            this.cookie = con.getHeaderField("Set-Cookie");
        }
        if (isNewConnection && con.getHeaderField("Content-length") == null) {
            this.log.info("WARNING: Content-length is not set and connection keep-alive will not work.");
        }
        this.hasMore |= "true".equalsIgnoreCase(con.getHeaderField("X-MoreMessages"));
        this.readMessages(con, connection);
        return true;
    }

    private void writeMessages(HttpURLConnection con, ApplicationConnection<?> applicationConnection) throws IOException {
        con.setRequestProperty("Content-type", "application/x-octet-stream");
        OutputStream out = con.getOutputStream();
        ChunkList chunks = applicationConnection.retrieveChunks(this);
        if (chunks != null) {
            for (Chunk chunk : chunks) {
                out.write(chunk.getBytes(), chunk.getOffset(), chunk.getLength());
                this.connectionStats.addWrittenBytes(chunk.getLength());
            }
            chunks.recycle(this);
        }
        this.fetchesLeft = this.fetchCount;
        out.close();
    }

    private void readMessages(HttpURLConnection con, ApplicationConnection<?> applicationConnection) throws IOException {
        InputStream in = con.getInputStream();
        boolean eof = false;
        while (!eof) {
            Chunk chunk;
            int bytesRead;
            ChunkList chunks = ((HttpConnector)this.connector).chunkPool.getChunkList(this);
            do {
                if ((bytesRead = in.read((chunk = ((HttpConnector)this.connector).chunkPool.getChunk(this)).getBytes(), chunk.getOffset(), chunk.getLength())) < 0) {
                    in.close();
                    eof = true;
                    break;
                }
                this.connectionStats.addReadBytes(bytesRead);
                chunk.setLength(bytesRead, this);
                chunks.add(chunk, this);
            } while (bytesRead >= chunk.getLength() && in.available() != 0);
            applicationConnection.processChunks(chunks, this);
        }
    }

    private ApplicationConnection<?> connect(URL url) {
        ApplicationConnection<?> connection = null;
        QDStats stats = null;
        try {
            this.transportConnection.variables().set(TransportConnection.REMOTE_HOST_ADDRESS_KEY, url.getHost());
            stats = ((HttpConnector)this.connector).getStats().getOrCreate(QDStats.SType.CONNECTIONS).create(QDStats.SType.CONNECTION);
            if (stats == null) {
                throw new NullPointerException("Stats were not created");
            }
            this.transportConnection.variables().set(MessageConnectors.STATS_KEY, stats);
            connection = ((HttpConnector)this.connector).getFactory().createConnection(this.transportConnection);
            connection.start();
            if (!this.doPost(url, connection, true, stats)) {
                this.log.info("POST method is not supported by the server. Will start reading file with GET method.");
                ((HttpConnector)this.connector).setFile(true);
                return null;
            }
            if (this.makeConnected()) {
                this.applicationConnection = connection;
                this.stats = stats;
                return connection;
            }
        }
        catch (Throwable t) {
            this.closeImpl(t);
        }
        if (connection != null) {
            connection.close();
        }
        if (stats != null) {
            stats.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doWork() throws InterruptedException, IOException {
        URL url = new URL(this.address);
        this.reconnectHelper.sleepBeforeConnection();
        this.log.info("Connecting to " + LogUtil.hideCredentials(this.address));
        ApplicationConnection<?> connection = this.connect(url);
        if (connection == null) {
            return;
        }
        this.log.info("Connected to " + LogUtil.hideCredentials(this.address));
        while (!this.isClosed()) {
            Object object = this.messagesLock;
            synchronized (object) {
                if (!this.messagesAvailable && !this.hasMore) {
                    if (this.fetchesLeft > 0) {
                        this.messagesLock.wait(Math.min(this.updateDelay, this.fetchDelay));
                        --this.fetchesLeft;
                    } else {
                        this.messagesLock.wait(this.updateDelay);
                    }
                }
                this.messagesAvailable = false;
            }
            this.doPost(url, connection, false, this.stats);
            connection.examine(System.currentTimeMillis());
        }
    }
}

