/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.qtp.http;

import com.devexperts.connector.proto.ApplicationConnectionFactory;
import com.devexperts.io.ChunkPool;
import com.devexperts.qd.QDFactory;
import com.devexperts.qd.qtp.AbstractConnectionHandler;
import com.devexperts.qd.qtp.AbstractMessageConnector;
import com.devexperts.qd.qtp.MessageConnector;
import com.devexperts.qd.qtp.MessageConnectorState;
import com.devexperts.qd.qtp.ReconnectHelper;
import com.devexperts.qd.qtp.help.MessageConnectorProperty;
import com.devexperts.qd.qtp.help.MessageConnectorSummary;
import com.devexperts.qd.qtp.http.HttpConnectorHandler;
import com.devexperts.qd.qtp.http.HttpConnectorMBean;
import com.devexperts.qd.stats.QDStats;
import com.devexperts.qd.util.QDConfig;
import com.devexperts.services.Services;
import com.devexperts.transport.stats.EndpointStats;
import com.devexperts.util.LogUtil;
import com.devexperts.util.SystemProperties;

@MessageConnectorSummary(info="Connects to some url by http or https protocol.", addressFormat="<url>")
public class HttpConnector
extends AbstractMessageConnector
implements HttpConnectorMBean {
    public static final String CONNECTION_ID_PARAMETER = "connection-id";
    public static final String DEFAULT_CONNECTION_ID = "qdc";
    public static final int DEFAULT_FETCH_COUNT = 5;
    public static final long DEFAULT_FETCH_DELAY = 1000L;
    public static final long DEFAULT_UPDATE_DELAY = 5000L;
    static final String NEW_CONNECTION_HTTP_PROPERTY = "X-NewConnection";
    static final String MORE_MESSAGES_HTTP_PROPERTY = "X-MoreMessages";
    final ChunkPool chunkPool;
    private String address;
    private int fetchCount = 5;
    private long fetchDelay = 1000L;
    private long updateDelay = 5000L;
    private String proxyHost = SystemProperties.getProperty("http.proxyHost", "");
    private int proxyPort = SystemProperties.getIntProperty("http.proxyPort", -1);
    private ReconnectHelper reconnectHelper;
    private boolean file;
    protected volatile AbstractConnectionHandler<?> handler;

    public HttpConnector(ApplicationConnectionFactory factory, String address) {
        super(factory);
        if (address == null) {
            throw new NullPointerException();
        }
        QDConfig.setDefaultProperties(this, HttpConnectorMBean.class, MessageConnector.class.getName());
        QDConfig.setDefaultProperties(this, HttpConnectorMBean.class, HttpConnector.class.getName());
        this.address = address;
        this.chunkPool = factory.getChunkPool();
    }

    @Override
    public synchronized String getAddress() {
        return this.address;
    }

    @Override
    public synchronized void setAddress(String address) {
        if (!address.equals(this.address)) {
            this.log.info("Setting address=" + LogUtil.hideCredentials(address));
            this.address = address;
            this.reconfigure();
        }
    }

    @Override
    public synchronized int getFetchCount() {
        return this.fetchCount;
    }

    @Override
    @MessageConnectorProperty(value="Number of times to use fetchDelay after sending piece of data")
    public synchronized void setFetchCount(int fetchCount) {
        if (fetchCount != this.fetchCount) {
            this.log.info("Setting fetchCount=" + fetchCount);
            this.fetchCount = fetchCount;
            this.reconfigure();
        }
    }

    @Override
    public synchronized long getFetchDelay() {
        return this.fetchDelay;
    }

    @Override
    @MessageConnectorProperty(value="Frequency (in ms) of updating data when data was sent recently")
    public synchronized void setFetchDelay(long fetchDelay) {
        if (fetchDelay != this.fetchDelay) {
            this.log.info("Setting fetchDelay=" + fetchDelay);
            this.fetchDelay = fetchDelay;
            this.reconfigure();
        }
    }

    @Override
    public synchronized long getUpdateDelay() {
        return this.updateDelay;
    }

    @Override
    @MessageConnectorProperty(value="Frequency (in ms) of checking if new data is available")
    public synchronized void setUpdateDelay(long updateDelay) {
        if (updateDelay != this.updateDelay) {
            this.log.info("Setting updateDelay=" + updateDelay);
            this.updateDelay = updateDelay;
            this.reconfigure();
        }
    }

    @Override
    public synchronized String getProxyHost() {
        return this.proxyHost;
    }

    @Override
    @MessageConnectorProperty(value="HTTP proxy host name")
    public synchronized void setProxyHost(String proxyHost) {
        if (!proxyHost.equals(this.proxyHost)) {
            this.log.info("Setting proxyHost=" + proxyHost);
            this.proxyHost = proxyHost;
            this.reconfigure();
        }
    }

    @Override
    public synchronized int getProxyPort() {
        return this.proxyPort;
    }

    @Override
    @MessageConnectorProperty(value="HTTP proxy port")
    public synchronized void setProxyPort(int proxyPort) {
        if (proxyPort != this.proxyPort) {
            this.log.info("Setting proxyPort=" + proxyPort);
            this.proxyPort = proxyPort;
            this.reconfigure();
        }
    }

    @Override
    public synchronized boolean isFile() {
        return this.file;
    }

    @Override
    @MessageConnectorProperty(value="Assume plain file on this URL instead of QDS servlet")
    public synchronized void setFile(boolean file) {
        if (this.file != file) {
            this.log.info("Setting file=" + LogUtil.hideCredentials(file));
            this.file = file;
            this.reconfigure();
        }
    }

    @Override
    public synchronized void start() {
        if (this.handler != null) {
            return;
        }
        this.log.info("Starting HttpConnector to " + LogUtil.hideCredentials(this.getAddress()));
        if (this.getStats() == null) {
            QDFactory.getDefaultFactory();
            this.setStats(QDFactory.createStats(QDStats.SType.HTTP_CONNECTOR, null));
        }
        if (this.file) {
            AbstractConnectionHandler.Factory factory = Services.createService(AbstractConnectionHandler.Factory.class, null, null);
            AbstractConnectionHandler<AbstractMessageConnector> abstractConnectionHandler = this.handler = factory != null ? factory.createHandler("file", this) : null;
            if (this.handler == null) {
                throw new IllegalArgumentException("Cannot find file connection handler");
            }
        } else {
            if (this.reconnectHelper == null) {
                this.reconnectHelper = new ReconnectHelper(this.getReconnectDelay());
            } else {
                this.reconnectHelper.setReconnectDelay(this.getReconnectDelay());
            }
            this.handler = new HttpConnectorHandler(this, this.reconnectHelper);
        }
        this.handler.start();
    }

    @Override
    protected synchronized AbstractMessageConnector.Joinable stopImpl() {
        AbstractConnectionHandler<?> handler = this.handler;
        this.handler = null;
        if (handler != null) {
            this.log.info("Stopping HttpConnector");
            handler.close();
        }
        return handler;
    }

    @Override
    protected synchronized void handlerClosed(AbstractConnectionHandler handler) {
        if (handler != this.handler) {
            return;
        }
        this.handler = null;
        if (!this.file) {
            this.start();
        }
    }

    @Override
    public synchronized void setStats(QDStats stats) {
        super.setStats(stats);
        stats.addMBean("HttpConnector", this);
    }

    @Override
    public boolean isActive() {
        return this.handler != null;
    }

    @Override
    public MessageConnectorState getState() {
        AbstractConnectionHandler<?> handler = this.handler;
        return handler != null ? handler.getHandlerState() : MessageConnectorState.DISCONNECTED;
    }

    @Override
    public int getConnectionCount() {
        return this.getState() == MessageConnectorState.CONNECTED ? 1 : 0;
    }

    @Override
    public EndpointStats retrieveCompleteEndpointStats() {
        EndpointStats stats = super.retrieveCompleteEndpointStats();
        AbstractConnectionHandler<?> handler = this.handler;
        if (handler != null && handler.getHandlerState() == MessageConnectorState.CONNECTED) {
            stats.addActiveConnectionCount(1L);
            stats.addConnectionStats(handler.getConnectionStats());
        }
        return stats;
    }
}

