/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.qtp.auth;

import com.devexperts.auth.AuthToken;
import com.devexperts.qd.qtp.MessageAdapterConnectionFactory;
import com.devexperts.qd.qtp.auth.QDLoginHandler;
import com.devexperts.qd.qtp.auth.QDLoginHandlerFactory;
import com.devexperts.services.ServiceProvider;
import com.devexperts.util.InvalidFormatException;
import com.dxfeed.promise.Promise;
import com.dxfeed.promise.PromiseHandler;
import java.io.Console;
import java.util.Scanner;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.GuardedBy;

@ServiceProvider
public class ConsoleLoginHandlerFactory
implements QDLoginHandlerFactory {
    public static final String NAME = "console";
    private static final Lock CONSOLE_LOCK = new ReentrantLock();

    @Override
    public QDLoginHandler createLoginHandler(String login, MessageAdapterConnectionFactory factory) throws InvalidFormatException {
        if (login.equalsIgnoreCase(NAME)) {
            return new ConsoleLoginHandler(factory.getUser(), factory.getPassword());
        }
        return null;
    }

    private static class ConsoleLoginHandler
    implements QDLoginHandler {
        private static final String USER = "User: ";
        private static final String PASSWORD = "Password: ";
        private volatile AuthToken token;
        private String factoryUser;
        private String factoryPassword;
        @GuardedBy(value="this")
        private Promise<AuthToken> promise;

        private ConsoleLoginHandler(String factoryUser, String factoryPassword) {
            this.factoryUser = factoryUser;
            this.factoryPassword = factoryPassword;
            if (!factoryUser.isEmpty() && !factoryPassword.isEmpty()) {
                this.token = AuthToken.createBasicToken(factoryUser, factoryPassword);
            }
        }

        @Override
        public synchronized Promise<AuthToken> login(String reason) {
            if (this.promise != null) {
                return this.promise;
            }
            if (reason.startsWith("LOGIN ") && this.token != null) {
                Promise<AuthToken> promise = new Promise<AuthToken>();
                promise.complete(this.token);
                return promise;
            }
            final ConsoleThread t = new ConsoleThread(reason);
            this.promise = new Promise<AuthToken>(){

                @Override
                protected void handleDone(PromiseHandler<? super AuthToken> handler) {
                    t.interrupt();
                    this.promiseDone();
                    super.handleDone(handler);
                }
            };
            t.start();
            return this.promise;
        }

        private synchronized void promiseDone() {
            this.promise = null;
        }

        private synchronized void done(AuthToken token) {
            this.token = token;
            if (this.promise != null) {
                this.promise.complete(token);
            }
        }

        @Override
        public AuthToken getAuthToken() {
            return this.token;
        }

        class ConsoleThread
        extends Thread {
            private final String reason;

            ConsoleThread(String reason) {
                super("ConsoleLoginHandler-" + reason);
                this.reason = reason;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    CONSOLE_LOCK.lockInterruptibly();
                }
                catch (InterruptedException e) {
                    return;
                }
                try {
                    String user = ConsoleLoginHandler.this.factoryUser;
                    String password = ConsoleLoginHandler.this.factoryPassword;
                    Console console = System.console();
                    if (console == null) {
                        Scanner scanner = new Scanner(System.in);
                        System.out.println(this.reason);
                        if (user.isEmpty()) {
                            System.out.print(ConsoleLoginHandler.USER);
                            user = scanner.nextLine();
                        }
                        if (password.isEmpty()) {
                            System.out.print(ConsoleLoginHandler.PASSWORD);
                            password = scanner.nextLine();
                        }
                    } else {
                        console.format("%s%n", this.reason);
                        if (user.isEmpty()) {
                            user = console.readLine(ConsoleLoginHandler.USER, new Object[0]);
                        }
                        if (password.isEmpty()) {
                            password = String.valueOf(console.readPassword(ConsoleLoginHandler.PASSWORD, new Object[0]));
                        }
                    }
                    ConsoleLoginHandler.this.done(AuthToken.createBasicToken(user, password));
                }
                finally {
                    CONSOLE_LOCK.unlock();
                }
            }
        }
    }
}

