/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.qtp.auth;

import com.devexperts.auth.AuthSession;
import com.devexperts.auth.AuthToken;
import com.devexperts.qd.qtp.ChannelDescription;
import com.devexperts.qd.qtp.MessageAdapterConnectionFactory;
import com.devexperts.qd.qtp.auth.BasicChannelShaperFactory;
import com.devexperts.qd.qtp.auth.QDAuthRealm;
import com.devexperts.qd.qtp.auth.QDAuthRealmFactory;
import com.devexperts.qd.util.QDConfig;
import com.devexperts.util.InvalidFormatException;
import com.devexperts.util.TypedMap;
import com.dxfeed.promise.Promise;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class BasicAuthRealmFactory
implements QDAuthRealmFactory {
    public static final BasicAuthRealmFactory INSTANCE = new BasicAuthRealmFactory();
    public static final String CONFIG_SUFFIX = ".config";

    @Override
    public QDAuthRealm createAuthRealm(String auth, MessageAdapterConnectionFactory factory) {
        return new BasicAuthRealm(auth);
    }

    public static List<ChannelDescription> parseAgentChannelDescription(String s) {
        if (s == null || s.isEmpty()) {
            return Collections.emptyList();
        }
        return QDConfig.splitParenthesisSeparatedString(s).stream().map(ChannelDescription::new).collect(Collectors.toList());
    }

    private static class BasicAuthRealm
    implements QDAuthRealm {
        private static final String AUTHENTICATION_INFO = "Required";
        private final Map<AuthToken, ChannelDescription[]> channelDescriptions = new HashMap<AuthToken, ChannelDescription[]>();
        private final Map<AuthToken, AuthSession> sessions = new HashMap<AuthToken, AuthSession>();

        BasicAuthRealm(String auth) {
            if (auth.endsWith(BasicAuthRealmFactory.CONFIG_SUFFIX)) {
                this.readFromFile(auth);
                return;
            }
            QDConfig.splitParenthesisSeparatedString(auth).forEach(this::parseOneDescription);
        }

        @Override
        public Promise<AuthSession> authenticate(AuthToken accessToken, TypedMap connectionVariables) {
            try {
                return Promise.completed(this.generatedSession(accessToken));
            }
            catch (SecurityException e) {
                return Promise.failed(e);
            }
        }

        @Override
        public String getAuthenticationInfo() {
            return AUTHENTICATION_INFO;
        }

        private void readFromFile(String fileName) {
            try {
                Files.lines(Paths.get(fileName, new String[0]), StandardCharsets.UTF_8).forEach(this::parseOneLine);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        private void parseOneLine(String line) {
            if ((line = line.trim()).startsWith("#") || line.isEmpty()) {
                return;
            }
            this.parseOneDescription(line);
        }

        private void parseOneDescription(String desc) {
            String[] ss = desc.split(":");
            if (ss.length > 3 || ss.length < 2) {
                throw new InvalidFormatException("Basic auth description format is <user>:<password>[:<channels>]");
            }
            if (ss.length == 2 || ss[2].equals("*")) {
                AuthToken basicToken = AuthToken.createBasicToken(ss[0], ss[1]);
                this.channelDescriptions.put(basicToken, BasicChannelShaperFactory.ALL_DATA);
            } else {
                List<ChannelDescription> descriptions = BasicAuthRealmFactory.parseAgentChannelDescription(ss[2]);
                this.channelDescriptions.put(AuthToken.createBasicToken(ss[0], ss[1]), descriptions.toArray(new ChannelDescription[descriptions.size()]));
            }
        }

        private synchronized AuthSession generatedSession(AuthToken basicToken) throws SecurityException {
            AuthSession session = this.sessions.get(basicToken);
            if (session != null) {
                return session;
            }
            ChannelDescription[] permissions = this.channelDescriptions.get(basicToken);
            if (permissions == null) {
                throw new SecurityException("Access denied");
            }
            session = new AuthSession(basicToken);
            session.variables().set(BasicChannelShaperFactory.CHANNEL_CONFIGURATION_KEY, permissions);
            this.sessions.put(basicToken, session);
            return session;
        }
    }
}

