/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.qtp;

import com.devexperts.logging.Logging;
import com.devexperts.qd.qtp.AbstractMessageConnector;

public abstract class QTPWorkerThread
extends Thread
implements AbstractMessageConnector.Joinable {
    protected final Logging log = Logging.getLogging(this.getClass().getName());
    private volatile boolean closed;

    protected QTPWorkerThread(String name) {
        super(name);
        this.setDaemon(true);
    }

    public final void close() {
        this.closed = true;
        this.interrupt();
    }

    public final boolean isClosed() throws InterruptedException {
        if (Thread.interrupted()) {
            if (this.closed) {
                return true;
            }
            throw new InterruptedException();
        }
        return this.closed;
    }

    @Override
    public final void run() {
        Throwable reason = null;
        try {
            try {
                this.doWork();
            }
            catch (ThreadDeath tde) {
                this.log.error("External Thread.stop() -- will shut down", tde);
                this.handleShutdown();
                reason = tde;
            }
            catch (InterruptedException ie) {
                if (!this.closed) {
                    this.handleShutdown();
                    reason = ie;
                }
            }
            catch (Throwable t) {
                reason = t;
                if (t instanceof Error || t instanceof RuntimeException) {
                    this.log.error("Unchecked exception in QTP", t);
                }
            }
        }
        finally {
            this.handleClose(reason);
        }
    }

    protected abstract void doWork() throws Throwable;

    protected abstract void handleShutdown();

    protected abstract void handleClose(Throwable var1);
}

