/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.qtp;

import com.devexperts.connector.proto.EndpointId;
import com.devexperts.qd.DataRecord;
import com.devexperts.qd.DataScheme;
import com.devexperts.qd.QDAgent;
import com.devexperts.qd.QDCollector;
import com.devexperts.qd.QDContract;
import com.devexperts.qd.QDFactory;
import com.devexperts.qd.QDHistory;
import com.devexperts.qd.QDLog;
import com.devexperts.qd.QDStream;
import com.devexperts.qd.QDTicker;
import com.devexperts.qd.kit.RecordOnlyFilter;
import com.devexperts.qd.kit.SymbolSetFilter;
import com.devexperts.qd.ng.RecordBuffer;
import com.devexperts.qd.ng.RecordListener;
import com.devexperts.qd.ng.RecordMode;
import com.devexperts.qd.qtp.MessageConnector;
import com.devexperts.qd.qtp.MessageConnectorListener;
import com.devexperts.qd.qtp.MessageConnectors;
import com.devexperts.qd.stats.QDStats;
import com.devexperts.services.Service;
import com.devexperts.services.Services;
import com.devexperts.util.InvalidFormatException;
import com.devexperts.util.TimeFormat;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public class QDEndpoint
implements Closeable {
    public static final String NAME_PROPERTY = "name";
    private final Object lock = new Lock();
    private final String name;
    private final DataScheme scheme;
    private final QDStats rootStats;
    private final EndpointId endpointId;
    private QDTicker ticker;
    private QDStream stream;
    private QDHistory history;
    private ConnectorInitializer connectorInitializer;
    private String user = "";
    private String password = "";
    private final EnumMap<QDContract, QDCollector> collectors = new EnumMap(QDContract.class);
    private final Set<QDContract> collectorsKeys = Collections.unmodifiableSet(this.collectors.keySet());
    private final Collection<QDCollector> collectorsValues = Collections.unmodifiableCollection(this.collectors.values());
    private final List<MessageConnector> connectors = new CopyOnWriteArrayList<MessageConnector>();
    private final List<MessageConnectorListener> connectorListeners = new ArrayList<MessageConnectorListener>();
    private final List<Plugin> plugins = new ArrayList<Plugin>();
    private final boolean withEventTimeSequence;
    private final boolean storeEverything;
    private volatile boolean closed;

    public static Builder newBuilder() {
        Builder builder = Services.createService(Builder.class, null, null);
        if (builder == null) {
            builder = new Builder();
        }
        return builder;
    }

    protected QDEndpoint(String name, DataScheme scheme, QDStats rootStats, List<QDCollector.Factory> collectors, boolean withEventTimeSequence, boolean storeEverything) {
        this.name = name;
        this.scheme = scheme;
        this.rootStats = rootStats;
        this.endpointId = EndpointId.newEndpointId(name);
        this.withEventTimeSequence = withEventTimeSequence;
        this.storeEverything = storeEverything;
        this.initCollectors(collectors);
    }

    public Object getLock() {
        return this.lock;
    }

    private void initCollectors(List<QDCollector.Factory> collectorFactories) {
        if (collectorFactories.isEmpty()) {
            return;
        }
        QDLog.log.info(this.name + " with collectors " + collectorFactories);
        QDFactory defaultFactory = QDFactory.getDefaultFactory();
        for (QDCollector.Factory factory : collectorFactories) {
            QDCollector.Builder<?> builder;
            QDCollector collector = factory.createCollector(defaultFactory, builder = defaultFactory.collectorBuilder(factory.getContract()).withScheme(this.scheme).withStats(this.rootStats.create(factory.getStatsType())).withEventTimeSequence(this.withEventTimeSequence));
            if (this.collectors.containsKey(collector.getContract())) {
                throw new IllegalArgumentException("Cannot have two collectors with " + collector.getContract() + " contract");
            }
            this.collectors.put(collector.getContract(), collector);
            switch (collector.getContract()) {
                case TICKER: {
                    collector.setStoreEverything(this.storeEverything);
                    this.ticker = (QDTicker)collector;
                    break;
                }
                case STREAM: {
                    this.stream = (QDStream)collector;
                    break;
                }
                case HISTORY: {
                    collector.setStoreEverything(this.storeEverything);
                    this.history = (QDHistory)collector;
                }
            }
        }
    }

    public void connect(String address) {
        this.initializeConnectorsForAddress(address);
        this.startConnectors();
    }

    public void initializeConnectorsForAddress(String address) {
        if (!this.hasConnectorInitializer()) {
            throw new IllegalStateException("ConnectorsInitializer is not set");
        }
        this.connectorInitializer.createAndAddConnector(this, address);
        this.updateUserAndPasswordImpl(this.connectors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnectorInitializer(ConnectorInitializer connectorInitializer) {
        Object object = this.lock;
        synchronized (object) {
            this.connectorInitializer = connectorInitializer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasConnectorInitializer() {
        Object object = this.lock;
        synchronized (object) {
            return this.connectorInitializer != null;
        }
    }

    public boolean hasEventTimeSequence() {
        boolean hasEventTimeSequence = this.withEventTimeSequence;
        for (QDCollector c : this.collectorsValues) {
            hasEventTimeSequence |= c.hasEventTimeSequence();
        }
        return hasEventTimeSequence;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public final String getName() {
        return this.name;
    }

    public Map<String, String> getDescriptorProperties() {
        return Collections.emptyMap();
    }

    public final DataScheme getScheme() {
        return this.scheme;
    }

    public QDStats getRootStats() {
        return this.rootStats;
    }

    public final QDTicker getTicker() {
        return this.ticker;
    }

    public final QDStream getStream() {
        return this.stream;
    }

    public final QDHistory getHistory() {
        return this.history;
    }

    public QDCollector getCollector(QDContract contract) {
        return this.collectors.get(contract);
    }

    public Set<QDContract> getContracts() {
        return this.collectorsKeys;
    }

    public Collection<QDCollector> getCollectors() {
        return this.collectorsValues;
    }

    public List<MessageConnector> getConnectors() {
        return this.connectors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QDEndpoint addCollector(QDCollector collector) {
        Object object = this.lock;
        synchronized (object) {
            if (collector.getScheme() != this.scheme) {
                throw new IllegalArgumentException("Different scheme in endpoint collector. Found " + collector.getScheme() + ", expected " + this.scheme);
            }
            if (this.closed) {
                return this;
            }
            QDContract contract = collector.getContract();
            switch (contract) {
                case TICKER: {
                    if (this.ticker != null) {
                        this.collectorRedefined(contract);
                    }
                    this.ticker = (QDTicker)collector;
                    break;
                }
                case STREAM: {
                    if (this.stream != null) {
                        this.collectorRedefined(contract);
                    }
                    this.stream = (QDStream)collector;
                    break;
                }
                case HISTORY: {
                    if (this.history != null) {
                        this.collectorRedefined(contract);
                    }
                    this.history = (QDHistory)collector;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected contract " + contract);
                }
            }
            this.collectors.put(contract, collector);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QDEndpoint addCollectors(QDCollector ... collectors) {
        Object object = this.lock;
        synchronized (object) {
            for (QDCollector collector : collectors) {
                this.addCollector(collector);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addPlugin(Plugin plugin) {
        Object object = this.lock;
        synchronized (object) {
            this.plugins.add(plugin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removePlugin(Plugin plugin) {
        Object object = this.lock;
        synchronized (object) {
            this.plugins.remove(plugin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QDEndpoint user(String user) {
        if (user == null) {
            throw new NullPointerException();
        }
        Object object = this.lock;
        synchronized (object) {
            this.user = user;
            this.updateUserAndPasswordImpl(this.connectors);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QDEndpoint password(String password) {
        if (password == null) {
            throw new NullPointerException();
        }
        Object object = this.lock;
        synchronized (object) {
            this.password = password;
            this.updateUserAndPasswordImpl(this.connectors);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final QDEndpoint addConnectors(Collection<MessageConnector> connectors) {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return this;
            }
            this.addConnectorsImpl(connectors);
            this.onConnectorsChanged();
        }
        return this;
    }

    protected void addConnectorsImpl(Collection<MessageConnector> connectors) {
        this.updateUserAndPasswordImpl(connectors);
        this.connectors.addAll(connectors);
        for (MessageConnectorListener listener : this.connectorListeners) {
            for (MessageConnector connector : connectors) {
                connector.addMessageConnectorListener(listener);
                listener.stateChanged(connector);
            }
        }
    }

    private void onConnectorsChanged() {
        for (Plugin plugin : this.plugins) {
            plugin.connectorsChanged(this.connectors);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QDEndpoint startConnectors() {
        Object object = this.lock;
        synchronized (object) {
            block3: for (MessageConnector connector : this.connectors) {
                for (Plugin plugin : this.plugins) {
                    if (!plugin.skipConnectorOnStart(connector)) continue;
                    continue block3;
                }
                connector.start();
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void restartActiveConnectors() {
        Object object = this.lock;
        synchronized (object) {
            for (MessageConnector connector : this.connectors) {
                if (!connector.isActive()) continue;
                connector.restart();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reconnectActiveConnectors() {
        Object object = this.lock;
        synchronized (object) {
            for (MessageConnector connector : this.connectors) {
                if (!connector.isActive()) continue;
                connector.reconnect();
            }
        }
    }

    public final void awaitProcessed() throws InterruptedException {
        for (MessageConnector connector : this.connectors) {
            connector.awaitProcessed();
        }
    }

    public final void stopConnectors() {
        MessageConnectors.stopMessageConnectors(this.connectors);
    }

    public final void stopConnectorsAndWait() throws InterruptedException {
        for (MessageConnector connector : this.connectors) {
            connector.stopAndWait();
        }
    }

    public final void stopConnectorsAndWaitUninterruptibly() {
        for (MessageConnector connector : this.connectors) {
            try {
                connector.stopAndWait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cleanupConnectors() {
        Object object = this.lock;
        synchronized (object) {
            if (this.connectors.isEmpty()) {
                return;
            }
            this.cleanupConnectorsImpl(this.connectors);
            this.connectors.clear();
            this.onConnectorsChanged();
        }
    }

    protected void cleanupConnectorsImpl(Collection<MessageConnector> connectors) {
        this.stopConnectors();
        for (MessageConnector connector : connectors) {
            QDStats connectorStats = connector.getStats();
            if (connectorStats == null) continue;
            connectorStats.close();
        }
        for (MessageConnectorListener listener : this.connectorListeners) {
            MessageConnectors.removeMessageConnectorListener(connectors, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QDEndpoint addMessageConnectionListener(MessageConnectorListener listener) {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return this;
            }
            MessageConnectors.addMessageConnectorListener(this.connectors, listener);
            this.connectorListeners.add(listener);
            for (MessageConnector connector : this.connectors) {
                listener.stateChanged(connector);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QDEndpoint removeMessageConnectionListener(MessageConnectorListener listener) {
        Object object = this.lock;
        synchronized (object) {
            MessageConnectors.removeMessageConnectorListener(this.connectors, listener);
            this.connectorListeners.remove(listener);
        }
        return this;
    }

    public void registerMonitoringTask(Runnable task) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        this.closeImpl();
    }

    protected void closeImpl() {
        this.cleanupConnectors();
        this.connectorListeners.clear();
        this.collectorsValues.forEach(QDCollector::close);
    }

    private void collectorRedefined(QDContract contract) throws IllegalArgumentException {
        throw new IllegalArgumentException("Only one " + contract + " collector can be used");
    }

    private void updateUserAndPasswordImpl(Collection<MessageConnector> connectors) {
        for (MessageConnector connector : connectors) {
            if (this.user.length() > 0) {
                connector.setUser(this.user);
            }
            if (this.password.length() <= 0) continue;
            connector.setPassword(this.password);
        }
    }

    public EndpointId getEndpointId() {
        return this.endpointId;
    }

    public static interface ConnectorInitializer {
        public void createAndAddConnector(QDEndpoint var1, String var2);
    }

    @Service
    public static class Builder
    implements Cloneable {
        private static final AtomicInteger INSTANCES_NUMERATOR = new AtomicInteger();
        protected DataScheme scheme;
        protected List<QDCollector.Factory> collectors = new ArrayList<QDCollector.Factory>(3);
        protected Properties props = new Properties();
        protected boolean withEventTimeSequence = false;
        protected boolean storeEverything = false;
        private String subscribeSupportPrefix;

        protected Builder() {
        }

        public Builder clone() {
            try {
                Builder clone = (Builder)super.clone();
                clone.collectors = new ArrayList<QDCollector.Factory>(this.collectors);
                clone.props = new Properties();
                clone.props.putAll((Map<?, ?>)this.props);
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError((Object)e);
            }
        }

        public final Builder withName(String name) {
            return this.withProperty(QDEndpoint.NAME_PROPERTY, name);
        }

        public final Builder withScheme(DataScheme scheme) {
            if (scheme == null) {
                throw new NullPointerException();
            }
            this.scheme = scheme;
            return this;
        }

        public final Builder withContracts(EnumSet<QDContract> contracts) {
            return this.withCollectors(contracts);
        }

        public final Builder withCollectors(Collection<? extends QDCollector.Factory> collectors) {
            this.collectors.addAll(collectors);
            return this;
        }

        public final Builder withEventTimeSequence(boolean withEventTime) {
            this.withEventTimeSequence = withEventTime;
            return this;
        }

        public final Builder withStoreEverything(boolean storeEverything) {
            this.storeEverything = storeEverything;
            return this;
        }

        public final Builder withSubscribeSupport(String prefix) {
            this.subscribeSupportPrefix = prefix;
            return this;
        }

        public final Builder withProperty(String key, String value) {
            if (key == null || value == null) {
                throw new NullPointerException();
            }
            if (this.supportsProperty(key)) {
                this.props.setProperty(key, value);
            }
            return this;
        }

        public final Builder withProperties(Properties props) {
            for (String key : props.stringPropertyNames()) {
                this.withProperty(key, props.getProperty(key));
            }
            return this;
        }

        public boolean supportsProperty(String key) {
            return QDEndpoint.NAME_PROPERTY.equals(key) || this.subscribeSupportPrefix != null && key.startsWith(this.subscribeSupportPrefix);
        }

        protected final String getOrCreateName() {
            String name = this.props.getProperty(QDEndpoint.NAME_PROPERTY);
            if (name != null) {
                return name;
            }
            int number = INSTANCES_NUMERATOR.getAndIncrement();
            return "qd" + (number == 0 ? "" : "-" + number);
        }

        protected final DataScheme getSchemeOrDefault() {
            return this.scheme == null ? QDFactory.getDefaultScheme() : this.scheme;
        }

        public QDEndpoint build() {
            QDEndpoint endpoint = new QDEndpoint(this.getOrCreateName(), this.getSchemeOrDefault(), QDFactory.createStats(QDStats.SType.ANY, this.scheme), this.collectors, this.withEventTimeSequence, this.storeEverything);
            this.subscribe(endpoint);
            return endpoint;
        }

        protected void subscribe(QDEndpoint endpoint) {
            if (this.subscribeSupportPrefix == null) {
                return;
            }
            for (Object oKey : this.props.keySet()) {
                QDContract contract;
                String value;
                String key = (String)oKey;
                if (!key.startsWith(this.subscribeSupportPrefix) || (value = this.props.getProperty(key).trim()).isEmpty()) continue;
                QDLog.log.info(endpoint.getName() + " with " + key + "=" + value);
                try {
                    contract = QDContract.valueOf(key.substring(this.subscribeSupportPrefix.length()).toUpperCase(Locale.US));
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidFormatException("Unsupported contract name in property key '" + key + "'");
                }
                QDCollector collector = endpoint.getCollector(contract);
                if (collector == null) {
                    throw new InvalidFormatException("Endpoint does not have " + collector + " collector to subscribe");
                }
                String[] s = value.split("\\s+", 3);
                if (s.length < 2) {
                    throw new InvalidFormatException("Property '" + key + "' shall have '<records> <symbols> [<date-time>]' value");
                }
                DataScheme scheme = endpoint.getScheme();
                RecordOnlyFilter records = RecordOnlyFilter.valueOf(s[0], scheme);
                SymbolSetFilter symbols = SymbolSetFilter.valueOf(s[1], scheme);
                long millis = 0L;
                if (s.length == 3) {
                    try {
                        millis = TimeFormat.DEFAULT.parse(s[2]).getTime();
                    }
                    catch (InvalidFormatException e) {
                        throw new InvalidFormatException("Property '" + key + "' has wrong date-time value", e);
                    }
                }
                long qdTime = millis / 1000L << 32;
                RecordBuffer buf = RecordBuffer.getInstance(RecordMode.HISTORY_SUBSCRIPTION);
                for (int i = 0; i < scheme.getRecordCount(); ++i) {
                    DataRecord record = scheme.getRecord(i);
                    if (!records.acceptRecord(record)) continue;
                    symbols.getSymbolSet().examine((cipher, symbol) -> buf.add(record, cipher, symbol).setTime(qdTime));
                }
                QDAgent agent = collector.agentBuilder().withKeyProperties("agent=qd.subscribe").build();
                agent.setRecordListener(RecordListener.VOID);
                agent.addSubscription(buf);
                buf.release();
            }
        }
    }

    public static abstract class Plugin {
        public boolean skipConnectorOnStart(MessageConnector connector) {
            return false;
        }

        public void connectorsChanged(List<MessageConnector> connectors) {
        }
    }

    private static class Lock {
        private Lock() {
        }
    }
}

