/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.qtp;

import com.devexperts.util.SystemProperties;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public enum ProtocolOption {
    HISTORY_SNAPSHOT("hs");

    private final String tag;
    private static final ProtocolOption[] VALUES;
    private static final int N_OPTIONS;
    public static final Set EMPTY_SET;
    public static final Set SUPPORTED_SET;

    private ProtocolOption(String tag) {
        this.tag = tag;
    }

    public String tag() {
        return this.tag;
    }

    public static Set parseProtocolOptions(String s) {
        return ProtocolOption.parseOptSetImpl(s, SUPPORTED_SET);
    }

    private static Set parseOptSetImpl(String s, Set supportedSet) {
        if (s == null || s.isEmpty()) {
            return EMPTY_SET;
        }
        int size = 0;
        int bits = 0;
        StringTokenizer st = new StringTokenizer(s, ",");
        block0: while (st.hasMoreTokens()) {
            String t = st.nextToken();
            for (ProtocolOption value : VALUES) {
                if (!t.equals(value.tag)) continue;
                int mask = 1 << value.ordinal();
                if ((bits & mask) != 0) continue block0;
                ++size;
                bits |= mask;
                continue block0;
            }
        }
        if (supportedSet != null && bits == supportedSet.bits) {
            return supportedSet;
        }
        return new Set(size, bits);
    }

    static {
        VALUES = ProtocolOption.values();
        N_OPTIONS = VALUES.length;
        EMPTY_SET = new Set(0, 0);
        String s = SystemProperties.getProperty(ProtocolOption.class, "supportedSet", null);
        SUPPORTED_SET = s != null ? ProtocolOption.parseOptSetImpl(s, null) : new Set(N_OPTIONS, (1 << N_OPTIONS) - 1);
    }

    public static class Set
    extends AbstractSet<ProtocolOption> {
        private final int size;
        private final int bits;

        Set(int size, int bits) {
            this.size = size;
            this.bits = bits;
        }

        @Override
        public Iterator<ProtocolOption> iterator() {
            return new Iterator<ProtocolOption>(){
                int i;
                {
                    this.initNext();
                }

                private void initNext() {
                    while (this.i < N_OPTIONS && (bits & 1 << this.i) == 0) {
                        ++this.i;
                    }
                }

                @Override
                public boolean hasNext() {
                    return this.i < N_OPTIONS;
                }

                @Override
                public ProtocolOption next() {
                    if (this.i >= N_OPTIONS) {
                        throw new NoSuchElementException();
                    }
                    ProtocolOption result = VALUES[this.i];
                    this.initNext();
                    return result;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof ProtocolOption)) {
                return false;
            }
            return (this.bits & 1 << ((ProtocolOption)((Object)o)).ordinal()) != 0;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < N_OPTIONS; ++i) {
                if ((this.bits & 1 << i) == 0) continue;
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(VALUES[i].tag);
            }
            return sb.toString();
        }
    }
}

