/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.qtp;

import com.devexperts.connector.proto.EndpointId;
import com.devexperts.io.BufferedInput;
import com.devexperts.io.BufferedOutput;
import com.devexperts.qd.QDFactory;
import com.devexperts.qd.qtp.MessageDescriptor;
import com.devexperts.qd.qtp.MessageType;
import com.devexperts.qd.qtp.ProtocolOption;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ProtocolDescriptor {
    public static final String MAGIC_STRING = "DXP3";
    private static final byte[] MAGIC_BYTES;
    public static final String TYPE_PROPERTY = "type";
    public static final String VERSION_PROPERTY = "version";
    public static final String OPT_PROPERTY = "opt";
    public static final String TIME_PROPERTY = "time";
    public static final String NAME_PROPERTY = "name";
    public static final String FILTER_PROPERTY = "filter";
    public static final String SERVICES_PROPERTY = "services";
    public static final String AUTHORIZATION_PROPERTY = "authorization";
    public static final String AUTHENTICATION_PROPERTY = "authentication";
    public static final String RMI_PROPERTY = "rmi";
    public static final String BASIC_AUTHORIZATION = "Basic";
    private final Map<String, String> properties = new LinkedHashMap<String, String>();
    private final Set<MessageDescriptor> send = new LinkedHashSet<MessageDescriptor>();
    private final Set<MessageDescriptor> receive = new LinkedHashSet<MessageDescriptor>();
    private EndpointId endpointId;

    private ProtocolDescriptor(ProtocolDescriptor previouslyRead) {
        if (previouslyRead != null) {
            this.properties.putAll(previouslyRead.properties);
            this.send.addAll(previouslyRead.send);
            this.receive.addAll(previouslyRead.receive);
            this.endpointId = previouslyRead.getEndpointId();
        }
    }

    public static ProtocolDescriptor newSelfProtocolDescriptor(String type) {
        if (type == null) {
            throw new NullPointerException();
        }
        ProtocolDescriptor result = new ProtocolDescriptor(null);
        result.setProperty(TYPE_PROPERTY, type);
        result.setProperty(VERSION_PROPERTY, QDFactory.getVersion());
        if (!ProtocolOption.SUPPORTED_SET.isEmpty()) {
            result.setProperty(OPT_PROPERTY, ProtocolOption.SUPPORTED_SET.toString());
        }
        return result;
    }

    public static ProtocolDescriptor newPeerProtocolDescriptor(ProtocolDescriptor previouslyRead) {
        return new ProtocolDescriptor(previouslyRead);
    }

    public static ProtocolDescriptor newPeerProtocolDescriptorReadAs(ProtocolDescriptor original, MessageType readAs) {
        ProtocolDescriptor result = new ProtocolDescriptor(original);
        MessageDescriptor readAsMessage = new MessageDescriptor(result);
        readAsMessage.setMessageType(readAs);
        Iterator<MessageDescriptor> it = result.send.iterator();
        while (it.hasNext()) {
            MessageDescriptor md = it.next();
            if (!md.getMessageType().hasRecords()) continue;
            readAsMessage.properties.putAll(md.properties);
            it.remove();
        }
        result.send.add(readAsMessage);
        return result;
    }

    public MessageDescriptor newMessageDescriptor() {
        return new MessageDescriptor(this);
    }

    public MessageDescriptor newMessageDescriptor(MessageType messageType) {
        MessageDescriptor result = new MessageDescriptor(this);
        result.setMessageType(messageType);
        return result;
    }

    public EndpointId getEndpointId() {
        return this.endpointId;
    }

    public void setEndpointId(EndpointId endpointId) {
        this.endpointId = endpointId;
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public Set<MessageDescriptor> getSendMessages() {
        return Collections.unmodifiableSet(this.send);
    }

    public Set<MessageDescriptor> getReceiveMessages() {
        return Collections.unmodifiableSet(this.receive);
    }

    public String getProperty(String key) {
        return this.properties.get(key);
    }

    public void setProperty(String key, String value) {
        if (value == null) {
            this.properties.remove(key);
        } else {
            this.properties.put(key, value);
        }
    }

    public boolean canSend(MessageType message) {
        for (MessageDescriptor md : this.send) {
            if (md.getMessageType() != message) continue;
            return true;
        }
        return false;
    }

    public boolean canReceive(MessageType message) {
        for (MessageDescriptor md : this.receive) {
            if (md.getMessageType() != message) continue;
            return true;
        }
        return false;
    }

    public EnumSet<MessageType> getSendSet() {
        EnumSet<MessageType> result = EnumSet.noneOf(MessageType.class);
        for (MessageDescriptor md : this.send) {
            MessageType message = md.getMessageType();
            if (message == null) continue;
            result.add(message);
        }
        return result;
    }

    public MessageDescriptor getSend(MessageType message) {
        for (MessageDescriptor md : this.send) {
            if (md.getMessageType() != message) continue;
            return md;
        }
        return null;
    }

    public EnumSet<MessageType> getReceiveSet() {
        EnumSet<MessageType> result = EnumSet.noneOf(MessageType.class);
        for (MessageDescriptor md : this.receive) {
            MessageType message = md.getMessageType();
            if (message == null) continue;
            result.add(message);
        }
        return result;
    }

    public MessageDescriptor getReceive(MessageType message) {
        for (MessageDescriptor md : this.receive) {
            if (md.getMessageType() != message) continue;
            return md;
        }
        return null;
    }

    public void addSend(MessageDescriptor message) {
        this.send.add(message);
    }

    public void addReceive(MessageDescriptor message) {
        this.receive.add(message);
    }

    public void composeTo(BufferedOutput out) throws IOException {
        out.write(MAGIC_BYTES);
        ProtocolDescriptor.composePropertiesTo(out, this.properties);
        this.composeMessageListTo(out, this.send);
        this.composeMessageListTo(out, this.receive);
        if (this.endpointId != null) {
            EndpointId.writeEndpointId(out, this.endpointId, null);
        }
    }

    public void parseFrom(BufferedInput in) throws IOException {
        for (byte b : MAGIC_BYTES) {
            if (in.read() == b) continue;
            throw new IOException("Invalid protocol descriptor magic. Wrong protocol.");
        }
        ProtocolDescriptor.parsePropertiesFrom(in, this.properties);
        this.parseMessageListFrom(in, this.send);
        this.parseMessageListFrom(in, this.receive);
        if (in.hasAvailable()) {
            this.endpointId = EndpointId.readEndpointId(in, null);
        }
    }

    public List<String> convertToTextTokens() {
        ArrayList<String> tokens = new ArrayList<String>();
        ProtocolDescriptor.convertPropertiesToTextTokens(tokens, this.properties);
        this.convertMessageListToTextTokens(tokens, "+", this.send);
        this.convertMessageListToTextTokens(tokens, "-", this.receive);
        return tokens;
    }

    public int appendFromTextTokens(List<String> tokens, int i) {
        i = ProtocolDescriptor.appendPropertiesFromTextTokens(tokens, this.properties, i);
        i = this.appendMessageListFromTextTokens(tokens, "+", this.send, i);
        i = this.appendMessageListFromTextTokens(tokens, "-", this.receive, i);
        return i;
    }

    static void composePropertiesTo(BufferedOutput out, Map<String, String> properties) throws IOException {
        out.writeCompactInt(properties.size());
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            out.writeUTFString(entry.getKey());
            out.writeUTFString(entry.getValue());
        }
    }

    static void parsePropertiesFrom(BufferedInput in, Map<String, String> properties) throws IOException {
        int size = in.readCompactInt();
        if (size < 0) {
            throw new IOException("Invalid size: " + size);
        }
        for (int i = 0; i < size; ++i) {
            String key = in.readUTFString();
            String value = in.readUTFString();
            properties.put(key, value);
        }
    }

    private void composeMessageListTo(BufferedOutput out, Collection<MessageDescriptor> messages) throws IOException {
        out.writeCompactInt(messages.size());
        for (MessageDescriptor message : messages) {
            message.composeTo(out);
        }
    }

    private void parseMessageListFrom(BufferedInput in, Collection<MessageDescriptor> messages) throws IOException {
        int size = in.readCompactInt();
        if (size < 0) {
            throw new IOException("Invalid size: " + size);
        }
        for (int i = 0; i < size; ++i) {
            MessageDescriptor message = this.newMessageDescriptor();
            message.parseFrom(in);
            messages.add(message);
        }
    }

    static void convertPropertiesToTextTokens(List<String> tokens, Map<String, String> properties) {
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            tokens.add(entry.getKey() + "=" + entry.getValue());
        }
    }

    static int appendPropertiesFromTextTokens(List<String> tokens, Map<String, String> properties, int i) {
        String token;
        int j;
        while (i < tokens.size() && (j = (token = tokens.get(i)).indexOf(61)) >= 0) {
            String key = token.substring(0, j);
            String value = token.substring(j + 1);
            properties.put(key, value);
            ++i;
        }
        return i;
    }

    private void convertMessageListToTextTokens(List<String> tokens, String prefix, Set<MessageDescriptor> messages) {
        for (MessageDescriptor message : messages) {
            message.convertToTextTokens(tokens, prefix);
        }
    }

    private int appendMessageListFromTextTokens(List<String> tokens, String prefix, Set<MessageDescriptor> messages, int i) {
        while (i < tokens.size() && tokens.get(i).startsWith(prefix)) {
            MessageDescriptor message = this.newMessageDescriptor();
            i = message.appendFromTextTokens(tokens, prefix, i);
            messages.add(message);
        }
        return i;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.endpointId != null) {
            sb.append(this.endpointId).append(' ');
        }
        sb.append("[");
        int index = 0;
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            int i;
            if (index++ > 0) {
                sb.append(", ");
            }
            String key = entry.getKey();
            String value = entry.getValue();
            if (key.equals(AUTHORIZATION_PROPERTY) && (i = value.indexOf(32)) >= 0) {
                value = value.substring(0, i);
            }
            sb.append(key);
            sb.append("=");
            sb.append(value);
        }
        sb.append("] sending ");
        EnumSet<MessageType.Flag> flags = EnumSet.noneOf(MessageType.Flag.class);
        for (MessageDescriptor md : this.send) {
            MessageType message = md.getMessageType();
            if (message == null) continue;
            flags.addAll(message.getFlags());
        }
        sb.append(flags);
        return sb.toString();
    }

    static {
        int n = MAGIC_STRING.length();
        MAGIC_BYTES = new byte[n];
        for (int i = 0; i < n; ++i) {
            ProtocolDescriptor.MAGIC_BYTES[i] = (byte)MAGIC_STRING.charAt(i);
        }
    }
}

