/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.qtp;

import com.devexperts.io.StreamOutput;
import com.devexperts.qd.DataProvider;
import com.devexperts.qd.SubscriptionProvider;
import com.devexperts.qd.qtp.AbstractMessageVisitor;
import com.devexperts.qd.qtp.AbstractQTPComposer;
import com.devexperts.qd.qtp.HeartbeatPayload;
import com.devexperts.qd.qtp.MessageListener;
import com.devexperts.qd.qtp.MessageProvider;
import com.devexperts.qd.qtp.MessageType;
import com.devexperts.qd.qtp.RuntimeQTPException;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;

public class OutputStreamMessageVisitor
extends AbstractMessageVisitor
implements MessageListener,
Closeable,
Flushable {
    private final StreamOutput out;
    private final AbstractQTPComposer composer;
    private final boolean autoFlush;

    public OutputStreamMessageVisitor(OutputStream out, AbstractQTPComposer composer, boolean autoFlush) {
        this.out = new StreamOutput(out);
        this.composer = composer;
        this.autoFlush = autoFlush;
        this.composer.setOutput(this.out);
    }

    @Override
    public synchronized void visitHeartbeat(HeartbeatPayload heartbeatPayload) {
        this.composer.visitHeartbeat(heartbeatPayload);
        this.flushIfNeeded();
    }

    @Override
    public synchronized boolean visitData(DataProvider provider, MessageType message) {
        boolean result = this.composer.visitData(provider, message);
        this.flushIfNeeded();
        return result;
    }

    @Override
    public synchronized boolean visitSubscription(SubscriptionProvider provider, MessageType message) {
        boolean result = this.composer.visitSubscription(provider, message);
        this.flushIfNeeded();
        return result;
    }

    @Override
    public synchronized boolean visitOtherMessage(int messageType, byte[] messageBytes, int offset, int length) {
        boolean result = this.composer.visitOtherMessage(messageType, messageBytes, offset, length);
        this.flushIfNeeded();
        return result;
    }

    @Override
    public synchronized void close() throws IOException {
        this.out.close();
    }

    @Override
    public synchronized void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public synchronized void messagesAvailable(MessageProvider provider) {
        provider.retrieveMessages(this);
    }

    private void flushIfNeeded() {
        if (this.autoFlush) {
            try {
                this.out.flush();
            }
            catch (IOException e) {
                throw new RuntimeQTPException(e);
            }
        }
    }
}

