/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.qtp;

import com.devexperts.io.BufferedOutput;
import com.devexperts.io.Chunk;
import com.devexperts.io.ChunkList;
import com.devexperts.io.ChunkedOutput;
import com.devexperts.qd.DataIntField;
import com.devexperts.qd.DataObjField;
import com.devexperts.qd.DataProvider;
import com.devexperts.qd.DataRecord;
import com.devexperts.qd.DataScheme;
import com.devexperts.qd.QDCollector;
import com.devexperts.qd.SubscriptionFilter;
import com.devexperts.qd.SubscriptionProvider;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.qtp.BinaryQTPComposer;
import com.devexperts.qd.qtp.FileConstants;
import com.devexperts.qd.qtp.MessageType;
import com.devexperts.qd.qtp.QDEndpoint;
import com.devexperts.qd.qtp.RuntimeQTPException;
import java.io.IOException;
import java.io.OutputStream;

public class OutputStreamComposer
extends BinaryQTPComposer {
    private final ChunkedOutput bytes = new ChunkedOutput(FileConstants.CHUNK_POOL);
    private OutputStream output;
    private SubscriptionFilter filter;
    private MessageType messageType;
    private boolean skipRecord;
    private int recordCounter;

    public OutputStreamComposer(DataScheme scheme) {
        super(scheme, true);
        super.setOutput(this.bytes);
    }

    @Override
    public void setOutput(BufferedOutput output) {
        throw new UnsupportedOperationException();
    }

    public void init(OutputStream output, SubscriptionFilter filter) {
        this.output = output;
        this.filter = filter;
        this.messageType = null;
        this.skipRecord = false;
        this.recordCounter = 0;
        this.resetSession();
    }

    public void composeEndpoint(QDEndpoint endpoint) {
        for (QDCollector collector : endpoint.getCollectors()) {
            this.composeCollector(collector);
        }
    }

    public void composeCollector(QDCollector collector) {
        this.flush();
        this.setMessageType(MessageType.forData(collector.getContract()));
        try {
            collector.examineData(this);
        }
        catch (Throwable t) {
            this.abortMessageAndRethrow(t);
        }
        this.flush();
    }

    public void setMessageType(MessageType messageType) {
        this.messageType = messageType;
    }

    public int getRecordCounter() {
        return this.recordCounter;
    }

    @Override
    public void flush() {
        this.flushMessage();
        ChunkList chunks = this.bytes.getOutput(this);
        if (chunks == null) {
            return;
        }
        try {
            for (Chunk chunk : chunks) {
                this.output.write(chunk.getBytes(), chunk.getOffset(), chunk.getLength());
            }
            chunks.recycle(this);
        }
        catch (IOException e) {
            throw new RuntimeQTPException(e);
        }
    }

    public void flushMessage() {
        if (this.inMessage()) {
            this.endMessage();
        }
    }

    @Override
    public boolean visitData(DataProvider provider, MessageType type) {
        this.setMessageType(type);
        return super.visitData(provider, type);
    }

    @Override
    public boolean visitSubscription(SubscriptionProvider provider, MessageType type) {
        this.setMessageType(type);
        return super.visitSubscription(provider, type);
    }

    @Override
    public boolean visitOtherMessage(int messageType, byte[] messageBytes, int offset, int length) {
        this.setMessageType(MessageType.findById(messageType));
        return super.visitOtherMessage(messageType, messageBytes, offset, length);
    }

    @Override
    public boolean hasCapacity() {
        if (!super.hasCapacity()) {
            this.flushMessage();
        }
        return true;
    }

    @Override
    public void append(RecordCursor cursor) {
        boolean bl = this.skipRecord = this.filter != null && !this.filter.acceptRecord(cursor.getRecord(), cursor.getCipher(), cursor.getSymbol());
        if (this.skipRecord) {
            return;
        }
        if (!this.inMessage()) {
            this.beginMessage(this.messageType);
        }
        ++this.recordCounter;
        super.append(cursor);
    }

    @Override
    public void visitRecord(DataRecord record, int cipher, String symbol, long time) {
        boolean bl = this.skipRecord = this.filter != null && !this.filter.acceptRecord(record, cipher, symbol);
        if (this.skipRecord) {
            return;
        }
        if (!this.inMessage()) {
            this.beginMessage(this.messageType);
        }
        ++this.recordCounter;
        super.visitRecord(record, cipher, symbol, time);
    }

    @Override
    public void visitRecord(DataRecord record, int cipher, String symbol) {
        boolean bl = this.skipRecord = this.filter != null && !this.filter.acceptRecord(record, cipher, symbol);
        if (this.skipRecord) {
            return;
        }
        if (!this.inMessage()) {
            this.beginMessage(this.messageType);
        }
        ++this.recordCounter;
        super.visitRecord(record, cipher, symbol);
    }

    @Override
    public void visitIntField(DataIntField field, int value) {
        if (this.skipRecord) {
            return;
        }
        super.visitIntField(field, value);
    }

    @Override
    public void visitObjField(DataObjField field, Object value) {
        if (this.skipRecord) {
            return;
        }
        super.visitObjField(field, value);
    }
}

