/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.qtp;

import com.devexperts.qd.QDContract;
import com.devexperts.qd.ng.RecordMode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public enum MessageType {
    HEARTBEAT(0, new Flag[0]),
    DESCRIBE_PROTOCOL(1, new Flag[0]),
    DESCRIBE_RECORDS(2, new Flag[0]),
    DESCRIBE_RESERVED(3, new Flag[0]),
    PART(4, new Flag[0]),
    RAW_DATA(5, Flag.DATA),
    TICKER_DATA(10, Flag.TICKER, Flag.DATA),
    TICKER_ADD_SUBSCRIPTION(11, Flag.TICKER, Flag.ADDSUB),
    TICKER_REMOVE_SUBSCRIPTION(12, Flag.TICKER, Flag.REMSUB),
    STREAM_DATA(15, Flag.STREAM, Flag.DATA),
    STREAM_ADD_SUBSCRIPTION(16, Flag.STREAM, Flag.ADDSUB),
    STREAM_REMOVE_SUBSCRIPTION(17, Flag.STREAM, Flag.REMSUB),
    HISTORY_DATA(20, Flag.HISTORY, Flag.DATA),
    HISTORY_ADD_SUBSCRIPTION(21, Flag.HISTORY, Flag.ADDSUB),
    HISTORY_REMOVE_SUBSCRIPTION(22, Flag.HISTORY, Flag.REMSUB),
    RMI_ADVERTISE_SERVICES(49, Flag.RMIADS),
    RMI_DESCRIBE_SUBJECT(50, Flag.RMIREQ, Flag.RMICHAN),
    RMI_DESCRIBE_OPERATION(51, Flag.RMIREQ, Flag.RMICHAN),
    RMI_REQUEST(52, Flag.RMIREQ, Flag.RMICHAN),
    RMI_CANCEL(53, Flag.RMIREQ),
    RMI_RESPONSE(56, Flag.RMIREQ, Flag.RMICHAN),
    RMI_RESULT(54, Flag.RMIRES),
    RMI_ERROR(55, Flag.RMIRES),
    TEXT_FORMAT(61, new Flag[0]);

    private static final MessageType[] types;
    private static final MessageType[] typeById;
    private final int id;
    private final Collection<Flag> flags;
    private final boolean data;
    private final boolean subscriptionAdd;
    private final boolean subscriptionRemove;
    private final boolean hasRecords;
    private final boolean stream;
    private final boolean history;
    private final boolean historySubscriptionAdd;
    private final boolean rmiReq;
    private final boolean rmiRes;
    private final boolean rmiChan;
    private final boolean rmiAds;
    private final QDContract contract;
    private final RecordMode recordMode;
    int cannotReorderWithMask;
    private static final MessageType[] DATA_BY_CONTRACT;
    private static final MessageType[] ADD_SUB_BY_CONTRACT;
    private static final MessageType[] REMOVE_SUB_BY_CONTRACT;

    private MessageType(int id, Flag ... flags) {
        if (id > 63) {
            throw new IllegalArgumentException();
        }
        this.id = id;
        List<Flag> f = Arrays.asList(flags);
        this.flags = Collections.unmodifiableCollection(f);
        this.data = f.contains((Object)Flag.DATA);
        this.subscriptionAdd = f.contains((Object)Flag.ADDSUB);
        this.subscriptionRemove = f.contains((Object)Flag.REMSUB);
        this.hasRecords = this.data || this.subscriptionAdd || this.subscriptionRemove;
        this.stream = f.contains((Object)Flag.STREAM);
        this.history = f.contains((Object)Flag.HISTORY);
        this.historySubscriptionAdd = this.history && this.subscriptionAdd;
        this.rmiReq = f.contains((Object)Flag.RMIREQ);
        this.rmiRes = f.contains((Object)Flag.RMIRES);
        this.rmiChan = f.contains((Object)Flag.RMICHAN);
        this.rmiAds = f.contains((Object)Flag.RMIADS);
        QDContract qDContract = f.contains((Object)Flag.TICKER) ? QDContract.TICKER : (f.contains((Object)Flag.STREAM) ? QDContract.STREAM : (this.contract = f.contains((Object)Flag.HISTORY) ? QDContract.HISTORY : null));
        this.recordMode = f.contains((Object)Flag.DATA) ? RecordMode.FLAGGED_DATA : (f.contains((Object)Flag.ADDSUB) ? (f.contains((Object)Flag.HISTORY) ? RecordMode.HISTORY_SUBSCRIPTION : RecordMode.SUBSCRIPTION) : (f.contains((Object)Flag.REMSUB) ? RecordMode.SUBSCRIPTION : null));
    }

    public Collection<Flag> getFlags() {
        return this.flags;
    }

    public int getId() {
        return this.id;
    }

    public boolean isData() {
        return this.data;
    }

    public boolean isSubscription() {
        return this.subscriptionAdd || this.subscriptionRemove;
    }

    public boolean isSubscriptionAdd() {
        return this.subscriptionAdd;
    }

    public boolean isSubscriptionRemove() {
        return this.subscriptionRemove;
    }

    public boolean hasRecords() {
        return this.hasRecords;
    }

    public boolean isStream() {
        return this.stream;
    }

    public boolean isHistory() {
        return this.history;
    }

    public boolean isHistorySubscriptionAdd() {
        return this.historySubscriptionAdd;
    }

    public boolean isRMIReq() {
        return this.rmiReq;
    }

    public boolean isRMIRes() {
        return this.rmiRes;
    }

    public boolean isRMIChan() {
        return this.rmiChan;
    }

    public boolean isRMIAds() {
        return this.rmiAds;
    }

    public QDContract getContract() {
        return this.contract;
    }

    public RecordMode getRecordMode() {
        return this.recordMode;
    }

    public static MessageType findById(int id) {
        return id >= 0 && id < typeById.length ? typeById[id] : null;
    }

    public static MessageType findByName(String name) {
        for (MessageType type : types) {
            if (!type.name().equals(name)) continue;
            return type;
        }
        return null;
    }

    public static MessageType forData(QDContract contract) {
        return DATA_BY_CONTRACT[contract.ordinal()];
    }

    public static MessageType forAddSubscription(QDContract contract) {
        return ADD_SUB_BY_CONTRACT[contract.ordinal()];
    }

    public static MessageType forRemoveSubscription(QDContract contract) {
        return REMOVE_SUB_BY_CONTRACT[contract.ordinal()];
    }

    static {
        types = MessageType.values();
        int maxId = 0;
        for (MessageType type : types) {
            maxId = Math.max(maxId, type.id);
        }
        typeById = new MessageType[maxId + 1];
        MessageType[] messageTypeArray = types;
        int n = messageTypeArray.length;
        for (int i = 0; i < n; ++i) {
            MessageType type;
            MessageType.typeById[type.id] = type = messageTypeArray[i];
        }
        if (types.length > 32) {
            throw new AssertionError((Object)"Only 32 messages types are supported in cannotReorderWithMask");
        }
        for (MessageType type1 : types) {
            for (MessageType type2 : types) {
                if (type1 == type2 || (!type1.isData() || !type2.isData() || type1 != RAW_DATA && type2 != RAW_DATA) && (!type1.isSubscription() || !type2.isSubscription() || type1.getContract() != type2.getContract())) continue;
                type1.cannotReorderWithMask |= 1 << type2.ordinal();
            }
        }
        DATA_BY_CONTRACT = new MessageType[QDContract.values().length];
        ADD_SUB_BY_CONTRACT = new MessageType[QDContract.values().length];
        REMOVE_SUB_BY_CONTRACT = new MessageType[QDContract.values().length];
        for (MessageType type : types) {
            if (type.contract == null) continue;
            if (type.flags.contains((Object)Flag.DATA)) {
                MessageType.DATA_BY_CONTRACT[type.contract.ordinal()] = type;
                continue;
            }
            if (type.flags.contains((Object)Flag.ADDSUB)) {
                MessageType.ADD_SUB_BY_CONTRACT[type.contract.ordinal()] = type;
                continue;
            }
            if (!type.flags.contains((Object)Flag.REMSUB)) continue;
            MessageType.REMOVE_SUB_BY_CONTRACT[type.contract.ordinal()] = type;
        }
    }

    public static enum Flag {
        TICKER,
        STREAM,
        HISTORY,
        DATA,
        ADDSUB,
        REMSUB,
        RMIREQ,
        RMIRES,
        RMIADS,
        RMICHAN;

    }
}

