/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.qtp;

import com.devexperts.io.BufferedInput;
import com.devexperts.io.BufferedOutput;
import com.devexperts.qd.qtp.MessageType;
import com.devexperts.qd.qtp.ProtocolDescriptor;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class MessageDescriptor {
    private static final int ID_UNKNOWN = -1;
    private int id = -1;
    private String name;
    private final ProtocolDescriptor parent;
    final Map<String, String> properties = new LinkedHashMap<String, String>();

    MessageDescriptor(ProtocolDescriptor parent) {
        this.parent = parent;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setMessageType(MessageType type) {
        this.id = type.getId();
        this.name = type.name();
    }

    public MessageType getMessageType() {
        if (this.id == -1) {
            return MessageType.findByName(this.name);
        }
        MessageType type = MessageType.findById(this.id);
        return type == null || !type.name().equals(this.name) ? null : type;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, String> getProperties() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(this.parent.getProperties());
        result.putAll(this.properties);
        return Collections.unmodifiableMap(result);
    }

    public String getProperty(String key) {
        String result = this.properties.get(key);
        return result == null ? this.parent.getProperty(key) : result;
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    void composeTo(BufferedOutput out) throws IOException {
        out.writeCompactInt(this.id);
        out.writeUTFString(this.name);
        ProtocolDescriptor.composePropertiesTo(out, this.properties);
    }

    void parseFrom(BufferedInput in) throws IOException {
        MessageType messageType;
        this.id = in.readCompactInt();
        this.name = in.readUTFString();
        if (this.id == -1 && (messageType = MessageType.findByName(this.name)) != null) {
            this.id = messageType.getId();
        }
        ProtocolDescriptor.parsePropertiesFrom(in, this.properties);
    }

    void convertToTextTokens(List<String> tokens, String prefix) {
        tokens.add(prefix + this.name);
        ProtocolDescriptor.convertPropertiesToTextTokens(tokens, this.properties);
    }

    int appendFromTextTokens(List<String> tokens, String prefix, int i) {
        this.id = -1;
        this.name = tokens.get(i++).substring(prefix.length());
        MessageType messageType = MessageType.findByName(this.name);
        if (messageType != null) {
            this.id = messageType.getId();
        }
        return ProtocolDescriptor.appendPropertiesFromTextTokens(tokens, this.properties, i);
    }

    public boolean equals(Object o) {
        return this == o || o instanceof MessageDescriptor && this.id == ((MessageDescriptor)o).id;
    }

    public int hashCode() {
        return this.id;
    }
}

