/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.qtp;

import com.devexperts.io.BufferedInput;
import com.devexperts.io.ByteArrayInput;
import com.devexperts.qd.DataConsumer;
import com.devexperts.qd.DataIterator;
import com.devexperts.qd.QDLog;
import com.devexperts.qd.SubscriptionConsumer;
import com.devexperts.qd.SubscriptionIterator;
import com.devexperts.qd.SymbolCodec;
import com.devexperts.qd.ng.RecordSource;
import com.devexperts.qd.qtp.HeartbeatPayload;
import com.devexperts.qd.qtp.MessageConstants;
import com.devexperts.qd.qtp.MessageConsumer;
import com.devexperts.qd.qtp.MessageType;
import com.devexperts.qd.qtp.ProtocolDescriptor;
import com.devexperts.qd.qtp.RawDataConsumer;

public class MessageConsumerAdapter
implements MessageConsumer,
MessageConstants,
SymbolCodec.Resolver {
    @Override
    public String getSymbol(char[] chars, int offset, int length) {
        return null;
    }

    @Override
    public void handleCorruptedStream() {
        QDLog.log.error("Corrupted QTP byte stream!!!");
    }

    @Override
    public void handleCorruptedMessage(int messageTypeId) {
        QDLog.log.error("Corrupted QTP message " + MessageConsumerAdapter.messageTypeIdToString(messageTypeId) + "!!!");
    }

    @Override
    public void handleUnknownMessage(int messageTypeId) {
        QDLog.log.error("Unknown QTP message " + MessageConsumerAdapter.messageTypeIdToString(messageTypeId) + "!!!");
    }

    private static String messageTypeIdToString(int messageTypeId) {
        MessageType messageType = MessageType.findById(messageTypeId);
        return "#" + messageTypeId + (messageType == null ? "" : ":" + (Object)((Object)messageType));
    }

    @Override
    public void processDescribeProtocol(ProtocolDescriptor desc, boolean logDescriptor) {
    }

    @Override
    public void processHeartbeat(HeartbeatPayload heartbeatPayload) {
    }

    public void processTimeProgressReport(long timeMillis) {
    }

    public final void processRecordSource(RecordSource source, MessageType message) {
        if (message.isData()) {
            if (message == MessageType.RAW_DATA && !(this instanceof RawDataConsumer)) {
                this.expandRawData(source);
            } else {
                this.processData(source, message);
            }
        } else if (message.isSubscription()) {
            this.processSubscription(source, message);
        } else {
            this.handleUnknownMessage(message.getId());
        }
    }

    private void expandRawData(RecordSource source) {
        long position = source.getPosition();
        this.processData(source, MessageType.TICKER_DATA);
        source.setPosition(position);
        this.processData(source, MessageType.STREAM_DATA);
        source.setPosition(position);
        this.processData(source, MessageType.HISTORY_DATA);
    }

    protected void processData(DataIterator iterator, MessageType message) {
        DataConsumer.VOID.processData(iterator);
        this.handleUnknownMessage(message.getId());
    }

    protected void processSubscription(SubscriptionIterator iterator, MessageType message) {
        SubscriptionConsumer.VOID.processSubscription(iterator);
        this.handleUnknownMessage(message.getId());
    }

    @Override
    public void processTickerData(DataIterator iterator) {
        this.processData(iterator, MessageType.TICKER_DATA);
    }

    @Override
    public void processTickerAddSubscription(SubscriptionIterator iterator) {
        this.processSubscription(iterator, MessageType.TICKER_ADD_SUBSCRIPTION);
    }

    @Override
    public void processTickerRemoveSubscription(SubscriptionIterator iterator) {
        this.processSubscription(iterator, MessageType.TICKER_REMOVE_SUBSCRIPTION);
    }

    @Override
    public void processStreamData(DataIterator iterator) {
        this.processData(iterator, MessageType.STREAM_DATA);
    }

    @Override
    public void processStreamAddSubscription(SubscriptionIterator iterator) {
        this.processSubscription(iterator, MessageType.STREAM_ADD_SUBSCRIPTION);
    }

    @Override
    public void processStreamRemoveSubscription(SubscriptionIterator iterator) {
        this.processSubscription(iterator, MessageType.STREAM_REMOVE_SUBSCRIPTION);
    }

    @Override
    public void processHistoryData(DataIterator iterator) {
        this.processData(iterator, MessageType.HISTORY_DATA);
    }

    @Override
    public void processHistoryAddSubscription(SubscriptionIterator iterator) {
        this.processSubscription(iterator, MessageType.HISTORY_ADD_SUBSCRIPTION);
    }

    @Override
    public void processHistoryRemoveSubscription(SubscriptionIterator iterator) {
        this.processSubscription(iterator, MessageType.HISTORY_REMOVE_SUBSCRIPTION);
    }

    @Override
    public final void processOtherMessage(int messageTypeId, byte[] bytes, int ofs, int len) {
        this.processOtherMessage(messageTypeId, new ByteArrayInput(bytes, ofs, len), len);
    }

    public void processOtherMessage(int messageTypeId, BufferedInput data, int len) {
        this.handleUnknownMessage(messageTypeId);
    }
}

