/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.qtp;

import com.devexperts.connector.codec.CodecConnectionFactory;
import com.devexperts.connector.codec.CodecFactory;
import com.devexperts.connector.proto.ApplicationConnectionFactory;
import com.devexperts.connector.proto.ConfigurationException;
import com.devexperts.connector.proto.ConfigurationKey;
import com.devexperts.qd.qtp.AddressSyntaxException;
import com.devexperts.qd.qtp.ConfigurableMessageAdapterFactory;
import com.devexperts.qd.qtp.MessageAdapter;
import com.devexperts.qd.qtp.MessageAdapterConnectionFactory;
import com.devexperts.qd.qtp.MessageConnector;
import com.devexperts.qd.qtp.MessageConnectorFactory;
import com.devexperts.qd.qtp.MessageConnectorListener;
import com.devexperts.qd.qtp.MessageConnectorMBean;
import com.devexperts.qd.qtp.http.HttpConnector;
import com.devexperts.qd.qtp.socket.ClientSocketConnector;
import com.devexperts.qd.qtp.socket.ServerSocketConnector;
import com.devexperts.qd.stats.QDStats;
import com.devexperts.qd.util.QDConfig;
import com.devexperts.services.Services;
import com.devexperts.transport.stats.EndpointStats;
import com.devexperts.util.InvalidFormatException;
import com.devexperts.util.JMXNameBuilder;
import com.devexperts.util.LogUtil;
import com.devexperts.util.TypedKey;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class MessageConnectors {
    public static final ConfigurationKey<String> NAME_CONFIGURATION_KEY = ConfigurationKey.create("name", String.class, "name of this connection");
    public static final ConfigurationKey<String> FILTER_CONFIGURATION_KEY = ConfigurationKey.create("filter", String.class, "filter for this connection");
    public static final ConfigurationKey<String> USER_CONFIGURATION_KEY = ConfigurationKey.create("user", String.class, "user name for this connection");
    public static final ConfigurationKey<String> PASSWORD_CONFIGURATION_KEY = ConfigurationKey.create("password", String.class, "password for this connection");
    public static final ConfigurationKey<Integer> MAX_CONNECTIONS_CONFIGURATION_KEY = ConfigurationKey.create("maxConnections", Integer.class, "max number of allowed connections");
    public static final TypedKey<Socket> SOCKET_KEY = new TypedKey();
    public static final TypedKey<QDStats> STATS_KEY = new TypedKey();
    private static final String HTTP_PREFIX = "http:";
    private static final String HTTPS_PREFIX = "https:";
    private static final String SERVER_SOCKET_PREFIX = "server:";
    private static final String CLIENT_SOCKET_PREFIX = "socket:";
    private static final String CONFIG_SUFFIX = ".config";

    public static ConfigurableMessageAdapterFactory configurable(MessageAdapter.Factory factory) {
        return MessageConnectors.configurableFactory(factory);
    }

    public static MessageAdapter.ConfigurableFactory configurableFactory(MessageAdapter.Factory factory) {
        return factory == null ? null : (factory instanceof MessageAdapter.ConfigurableFactory ? (MessageAdapter.ConfigurableFactory)factory : new LegacyNonConfigurableFactory(factory));
    }

    public static ApplicationConnectionFactory applicationConnectionFactory(MessageAdapter.Factory factory) {
        return new MessageAdapterConnectionFactory(MessageConnectors.configurableFactory(factory));
    }

    public static ApplicationConnectionFactory applicationConnectionFactory(ConfigurableMessageAdapterFactory factory) {
        return new MessageAdapterConnectionFactory(MessageConnectors.configurableFactory(factory));
    }

    public static MessageAdapter.Factory retrieveMessageAdapterFactory(ApplicationConnectionFactory pFactory) {
        try {
            MessageAdapterConnectionFactory mapFactory = (MessageAdapterConnectionFactory)pFactory;
            return mapFactory.getMessageAdapterFactory();
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Unsupported application connection class: " + pFactory.getClass().getName(), e);
        }
    }

    public static List<MessageConnector> createMessageConnectors(ConfigurableMessageAdapterFactory cFactory, String addresses, QDStats parentStats) throws AddressSyntaxException {
        return MessageConnectors.createConnectorsInternal(MessageConnectors.applicationConnectionFactory(cFactory), addresses, parentStats, MessageConnectors.getCurrentDirURL());
    }

    public static List<MessageConnector> createMessageConnectors(ApplicationConnectionFactory acFactory, String addresses, QDStats stats) throws AddressSyntaxException {
        return MessageConnectors.createConnectorsInternal(acFactory, addresses, stats, MessageConnectors.getCurrentDirURL());
    }

    public static List<MessageConnector> createMessageConnectors(ApplicationConnectionFactory acFactory, String addresses) throws AddressSyntaxException {
        return MessageConnectors.createConnectorsInternal(acFactory, addresses, QDStats.VOID, MessageConnectors.getCurrentDirURL());
    }

    private static URL getCurrentDirURL() {
        URL base;
        try {
            base = new File(".").toURL();
        }
        catch (MalformedURLException e) {
            throw new AssertionError();
        }
        return base;
    }

    private static List<MessageConnector> createConnectorsInternal(ApplicationConnectionFactory acFactory, String addresses, QDStats parentStats, URL base) throws AddressSyntaxException {
        if (acFactory == null) {
            throw new NullPointerException("acFactory");
        }
        if (addresses == null) {
            throw new NullPointerException("addresses");
        }
        if (parentStats == null) {
            throw new NullPointerException("parentStats");
        }
        addresses = addresses.trim();
        ArrayList<MessageConnector> result = new ArrayList<MessageConnector>();
        HashSet<String> usedNames = new HashSet<String>();
        if (addresses.startsWith("(")) {
            for (String s : QDConfig.splitParenthesisSeparatedString(addresses)) {
                result.addAll(MessageConnectors.createConfiguredConnector(s, acFactory, parentStats, base, usedNames));
            }
        } else {
            ParsedAddress pa = MessageConnectors.parseAddress(addresses);
            if (!MessageConnectors.isLegacyAddress(addresses) || pa.address.startsWith(HTTP_PREFIX) || pa.address.startsWith(HTTPS_PREFIX)) {
                result.addAll(MessageConnectors.createConfiguredConnector(addresses, acFactory, parentStats, base, usedNames));
            } else {
                StringTokenizer st = new StringTokenizer(addresses, "/");
                while (st.hasMoreTokens()) {
                    result.addAll(MessageConnectors.createConfiguredConnector(st.nextToken(), acFactory, parentStats, base, usedNames));
                }
            }
        }
        return result;
    }

    private static boolean isLegacyAddress(String addresses) {
        if (addresses.startsWith("/") || addresses.endsWith("/")) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(addresses, "/");
        while (st.hasMoreTokens()) {
            String addr = st.nextToken();
            ParsedAddress pa = MessageConnectors.parseAddress(addr);
            if (pa.address.indexOf(58) >= 0) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public static String maskAuthorizationData(String address) {
        return LogUtil.hideCredentials(address);
    }

    private static ParsedAddress parseAddress(String address) throws AddressSyntaxException {
        String[] codecSplit;
        String[] specSplit = QDConfig.splitParenthesisedStringAt(address, '@');
        String spec = specSplit.length == 1 ? "" : specSplit[0];
        address = specSplit.length == 1 ? address : specSplit[1];
        ArrayList<String> propStrings = new ArrayList<String>();
        try {
            address = QDConfig.parseProperties(address, propStrings);
        }
        catch (InvalidFormatException e) {
            throw new AddressSyntaxException(e.getMessage(), e);
        }
        ArrayList<List<String>> codecs = new ArrayList<List<String>>();
        while ((codecSplit = QDConfig.splitParenthesisedStringAt(address, '+')).length != 1) {
            String codecStr = codecSplit[0];
            address = codecSplit[1];
            ArrayList<String> codecInfo = new ArrayList<String>();
            codecInfo.add(null);
            codecStr = QDConfig.parseProperties(codecStr, codecInfo);
            codecInfo.set(0, codecStr);
            codecs.add(codecInfo);
        }
        Collections.reverse(codecs);
        ArrayList<SharedProp> props = new ArrayList<SharedProp>();
        for (String s : propStrings) {
            props.add(new SharedProp(s));
        }
        return new ParsedAddress(spec, codecs, address, props);
    }

    public static List<Class<? extends MessageConnector>> listMessageConnectors(ClassLoader loader) {
        ArrayList<Class<? extends MessageConnector>> result = new ArrayList<Class<? extends MessageConnector>>();
        result.add(ClientSocketConnector.class);
        result.add(ServerSocketConnector.class);
        result.add(HttpConnector.class);
        for (MessageConnectorFactory mcf : Services.createServices(MessageConnectorFactory.class, loader)) {
            result.add(mcf.getResultingClass());
        }
        return result;
    }

    public static Class<? extends MessageConnector> findMessageConnector(String name, ClassLoader loader) {
        for (Class<? extends MessageConnector> connector : MessageConnectors.listMessageConnectors(loader)) {
            if (!connector.getSimpleName().equalsIgnoreCase(name)) continue;
            return connector;
        }
        return null;
    }

    public static <T extends CodecConnectionFactory> T getCodecFactory(ApplicationConnectionFactory factory, Class<T> codecFactoryClass) {
        Objects.nonNull(factory);
        while (factory instanceof CodecConnectionFactory && !codecFactoryClass.isInstance(factory)) {
            factory = ((CodecConnectionFactory)factory).getDelegate();
        }
        return (T)(codecFactoryClass.isInstance(factory) ? (CodecConnectionFactory)factory : null);
    }

    private static List<MessageConnector> createConfiguredConnector(String fullAddress, ApplicationConnectionFactory originalFactory, QDStats parentStats, URL base, Set<String> usedNames) throws AddressSyntaxException {
        ParsedAddress pa = MessageConnectors.parseAddress(fullAddress);
        String name = MessageConnectors.removeProperty(pa, NAME_CONFIGURATION_KEY.getName(), null);
        String filter = MessageConnectors.removeProperty(pa, FILTER_CONFIGURATION_KEY.getName(), "");
        if (pa.spec.length() > 0) {
            if (filter.length() > 0 && !filter.equals(pa.spec)) {
                throw new AddressSyntaxException("Filters specified before @ and with property \"filter\" conflict: \"" + pa.spec + "\" vs \"" + filter + "\"");
            }
            filter = pa.spec;
        }
        ApplicationConnectionFactory factoryWithFilter = originalFactory.clone();
        MessageConnectors.configureFactoryFilter(factoryWithFilter, filter);
        List<ConnectorWithConfig> cs = MessageConnectors.createConnectorOnly(pa, factoryWithFilter, parentStats, base);
        ArrayList<MessageConnector> result = new ArrayList<MessageConnector>();
        for (ConnectorWithConfig c : cs) {
            if (name != null) {
                c.connector.setName(name);
            } else {
                name = c.connector.getName();
                if (usedNames.contains(name)) {
                    int i = 1;
                    while (usedNames.contains(name)) {
                        name = c.connector.getName() + "-" + i;
                        ++i;
                    }
                    c.connector.setName(name);
                }
                usedNames.add(name);
            }
            if (c.type != null) {
                MessageConnectors.configureConnectorStats(c.connector, parentStats, c.type);
            }
            ApplicationConnectionFactory configuredFactory = MessageConnectors.configureConnectionFactory(c.connector.getFactory(), pa);
            c.connector.setFactory(configuredFactory);
            try {
                ArrayList<String> props = new ArrayList<String>();
                for (SharedProp prop : c.props) {
                    if (prop.used) {
                        prop.used = false;
                        continue;
                    }
                    props.add(prop.kv);
                }
                QDConfig.setProperties(c.connector, props);
            }
            catch (InvalidFormatException e) {
                throw new AddressSyntaxException(e.getMessage(), e);
            }
            result.add(c.connector);
        }
        return result;
    }

    private static String removeProperty(ParsedAddress pa, String propName, String def) {
        String propNamePrefix = propName + "=";
        Iterator<SharedProp> it = pa.props.iterator();
        while (it.hasNext()) {
            String s = it.next().kv;
            if (!s.startsWith(propNamePrefix)) continue;
            it.remove();
            return s.substring(propNamePrefix.length());
        }
        return def;
    }

    private static List<ConnectorWithConfig> createConnectorOnly(ParsedAddress pa, ApplicationConnectionFactory acFactory, QDStats parentStats, URL base) throws AddressSyntaxException {
        int port;
        MessageConnector connector;
        String address = pa.address;
        try {
            URL addressUrl = new URL(base, address);
            if (addressUrl.getRef() != null && addressUrl.getPath().endsWith(CONFIG_SUFFIX)) {
                return MessageConnectors.loadConfigurationFile(addressUrl, acFactory, parentStats, pa.props);
            }
        }
        catch (MalformedURLException addressUrl) {
            // empty catch block
        }
        if (address.startsWith(HTTP_PREFIX) || address.startsWith(HTTPS_PREFIX)) {
            HttpConnector connector2 = new HttpConnector(acFactory, address);
            return Collections.singletonList(new ConnectorWithConfig(connector2, pa.props, QDStats.SType.HTTP_CONNECTOR));
        }
        for (MessageConnectorFactory mcf : Services.createServices(MessageConnectorFactory.class, null)) {
            connector = mcf.createMessageConnector(acFactory, address);
            if (connector == null) continue;
            String name = connector.getClass().getName();
            int idx = name.lastIndexOf(46);
            if (idx >= 0) {
                name = name.substring(idx + 1);
            }
            return Collections.singletonList(new ConnectorWithConfig(connector, pa.props, new QDStats.SType(name, 2, new QDStats.SType[0])));
        }
        if (address.startsWith("nio:")) {
            throw new AddressSyntaxException("Address starting with \"nio:\" is considered ambiguous: use \"nio::<port>\" to create NIO server socket connector or use \"socket:nio:<port>\" to create client socket connector to the host named \"nio\".");
        }
        if (address.startsWith(SERVER_SOCKET_PREFIX)) {
            address = address.substring(SERVER_SOCKET_PREFIX.length() - 1);
        } else if (address.startsWith(CLIENT_SOCKET_PREFIX)) {
            address = address.substring(CLIENT_SOCKET_PREFIX.length());
        }
        int portSep = address.lastIndexOf(58);
        if (portSep < 0) {
            throw new AddressSyntaxException("Port number is missing in \"" + address + "\"");
        }
        try {
            port = Integer.decode(address.substring(portSep + 1));
        }
        catch (NumberFormatException e) {
            throw new AddressSyntaxException("Port number format error in \"" + address + "\"");
        }
        address = address.substring(0, portSep).trim();
        if (address.isEmpty()) {
            connector = new ServerSocketConnector(acFactory, port);
            return Collections.singletonList(new ConnectorWithConfig(connector, pa.props, QDStats.SType.SERVER_SOCKET_CONNECTOR));
        }
        connector = new ClientSocketConnector(acFactory, address, port);
        return Collections.singletonList(new ConnectorWithConfig(connector, pa.props, QDStats.SType.CLIENT_SOCKET_CONNECTOR));
    }

    private static void configureConnectorStats(MessageConnector connector, QDStats parentStats, QDStats.SType type) {
        connector.setStats(parentStats.create(type, "connector=" + JMXNameBuilder.quoteKeyPropertyValue(connector.getName())));
    }

    private static ApplicationConnectionFactory configureConnectionFactory(ApplicationConnectionFactory originalFactory, ParsedAddress parsedAddress) {
        ApplicationConnectionFactory factory = originalFactory;
        try {
            Iterable<CodecFactory> codecs = Services.createServices(CodecFactory.class, null);
            for (List<String> codecInfo : parsedAddress.codecs) {
                String codecName = codecInfo.get(0);
                ApplicationConnectionFactory newFactory = factory;
                boolean matched = false;
                for (CodecFactory codecFactory : codecs) {
                    newFactory = codecFactory.createCodec(codecName, newFactory);
                    if (newFactory == factory) continue;
                    matched = true;
                    Iterator<String> it = codecInfo.iterator();
                    it.next();
                    while (it.hasNext()) {
                        String value;
                        String kv = it.next();
                        int i = kv.indexOf(61);
                        String key = i < 0 ? kv : kv.substring(0, i).trim();
                        String string = value = i < 0 ? "" : kv.substring(i + 1).trim();
                        if (newFactory.setConfiguration(ConfigurationKey.create(key, String.class), value)) continue;
                        throw new AddressSyntaxException("Unknown property \"" + key + "\" for \"" + codecName + "\" codec");
                    }
                }
                if (!matched) {
                    throw new AddressSyntaxException("Unsupported codec \"" + codecName + "\"");
                }
                factory = newFactory;
            }
            for (SharedProp sharedProp : parsedAddress.props) {
                String value;
                String kv = sharedProp.kv;
                int i = kv.indexOf(61);
                String key = i < 0 ? kv : kv.substring(0, i).trim();
                String string = value = i < 0 ? "" : kv.substring(i + 1).trim();
                if (!originalFactory.setConfiguration(ConfigurationKey.create(key, String.class), value)) continue;
                sharedProp.used = true;
            }
            originalFactory.reinitConfiguration();
        }
        catch (ConfigurationException e) {
            throw new AddressSyntaxException("Invalid connection configuration for key \"" + e.getKey().getName() + "\": " + e.getMessage(), e);
        }
        return factory;
    }

    private static void configureFactoryFilter(ApplicationConnectionFactory factory, String spec) throws AddressSyntaxException {
        try {
            if (!factory.setConfiguration(FILTER_CONFIGURATION_KEY, spec) && spec.length() > 0) {
                throw new AddressSyntaxException("Connection does not support filter \"" + spec + "\"");
            }
        }
        catch (ConfigurationException e) {
            throw new AddressSyntaxException("Invalid filter: " + e.getMessage(), e);
        }
    }

    private static List<ConnectorWithConfig> loadConfigurationFile(URL configUrl, ApplicationConnectionFactory acFactory, QDStats parentStats, List<SharedProp> baseProps) {
        String prefix;
        SortedMap<String, String> config = MessageConnectors.readProperties(configUrl);
        String addresses = (String)config.get(prefix = configUrl.getRef());
        if (addresses == null) {
            throw new AddressSyntaxException("Property value is not found in \"" + configUrl + "\"");
        }
        List<MessageConnector> connectors = MessageConnectors.createConnectorsInternal(acFactory, addresses, parentStats, configUrl);
        Set<Map.Entry<String, String>> entries = config.subMap(prefix + '.', prefix + '/').entrySet();
        ArrayList<SharedProp> props = new ArrayList<SharedProp>();
        for (Map.Entry<String, String> entry : entries) {
            props.add(new SharedProp(entry.getKey().substring(prefix.length() + 1) + "=" + entry.getValue()));
        }
        props.addAll(baseProps);
        ArrayList<ConnectorWithConfig> result = new ArrayList<ConnectorWithConfig>();
        for (MessageConnector connector : connectors) {
            result.add(new ConnectorWithConfig(connector, props, null));
        }
        return result;
    }

    private static SortedMap<String, String> readProperties(URL url) {
        Properties props = new Properties();
        try (InputStream in = url.openStream();){
            props.load(in);
        }
        catch (IOException e) {
            throw new AddressSyntaxException("Cannot read configuration file \"" + url + "\"", e);
        }
        return new TreeMap<Object, Object>(props);
    }

    public static void startMessageConnectors(Collection<? extends MessageConnector> connectors) {
        connectors.forEach(MessageConnectorMBean::start);
    }

    public static void stopMessageConnectors(Collection<? extends MessageConnector> connectors) {
        connectors.forEach(MessageConnectorMBean::stop);
    }

    public static EndpointStats getEndpointStats(Collection<? extends MessageConnector> connectors) {
        EndpointStats stats = new EndpointStats();
        for (MessageConnector messageConnector : connectors) {
            stats.addEndpointStats(messageConnector.retrieveCompleteEndpointStats());
        }
        return stats;
    }

    public static void addMessageConnectorListener(Collection<? extends MessageConnector> connectors, MessageConnectorListener listener) {
        for (MessageConnector messageConnector : connectors) {
            messageConnector.addMessageConnectorListener(listener);
        }
    }

    public static void removeMessageConnectorListener(Collection<? extends MessageConnector> connectors, MessageConnectorListener listener) {
        for (MessageConnector messageConnector : connectors) {
            messageConnector.removeMessageConnectorListener(listener);
        }
    }

    public static void setThreadPriority(Collection<? extends MessageConnector> connectors, int priority) {
        for (MessageConnector messageConnector : connectors) {
            messageConnector.setThreadPriority(priority);
        }
    }

    private static class LegacyNonConfigurableFactory
    extends MessageAdapter.ConfigurableFactory {
        private MessageAdapter.Factory factory;

        LegacyNonConfigurableFactory(MessageAdapter.Factory factory) {
            this.factory = factory;
        }

        @Override
        public MessageAdapter createAdapter(QDStats stats) {
            return this.factory.createAdapter(stats);
        }

        @Override
        public <T> boolean setConfiguration(ConfigurationKey<T> key, T value) throws ConfigurationException {
            if (key.equals(FILTER_CONFIGURATION_KEY) && this.factory instanceof ConfigurableMessageAdapterFactory) {
                this.factory = ((ConfigurableMessageAdapterFactory)this.factory).createMessageAdapterFactory((String)value);
                return true;
            }
            return super.setConfiguration(key, value);
        }

        @Override
        public String toString() {
            return this.factory.toString();
        }
    }

    private static class ConnectorWithConfig {
        final MessageConnector connector;
        final List<SharedProp> props;
        final QDStats.SType type;

        ConnectorWithConfig(MessageConnector connector, List<SharedProp> props, QDStats.SType type) {
            this.connector = connector;
            this.props = props;
            this.type = type;
        }
    }

    private static class ParsedAddress {
        final String spec;
        final List<List<String>> codecs;
        final String address;
        final List<SharedProp> props;

        ParsedAddress(String spec, List<List<String>> codecs, String address, List<SharedProp> props) {
            this.spec = spec;
            this.codecs = codecs;
            this.address = address;
            this.props = props;
        }
    }

    private static class SharedProp {
        final String kv;
        boolean used;

        private SharedProp(String kv) {
            this.kv = kv;
        }
    }
}

