/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.qtp;

import com.devexperts.connector.proto.ApplicationConnection;
import com.devexperts.connector.proto.ApplicationConnectionFactory;
import com.devexperts.connector.proto.Configurable;
import com.devexperts.connector.proto.ConfigurationKey;
import com.devexperts.connector.proto.TransportConnection;
import com.devexperts.qd.qtp.MessageAdapter;
import com.devexperts.qd.qtp.MessageAdapterConnection;
import com.devexperts.qd.qtp.MessageConnectors;
import com.devexperts.qd.qtp.auth.BasicAuthRealmFactory;
import com.devexperts.qd.qtp.auth.BasicLoginHandler;
import com.devexperts.qd.qtp.auth.BasicLoginHandlerFactory;
import com.devexperts.qd.qtp.auth.QDAuthRealm;
import com.devexperts.qd.qtp.auth.QDAuthRealmFactory;
import com.devexperts.qd.qtp.auth.QDLoginHandler;
import com.devexperts.qd.qtp.auth.QDLoginHandlerFactory;
import com.devexperts.qd.qtp.socket.SocketMessageAdapterFactory;
import com.devexperts.qd.stats.QDStats;
import com.devexperts.services.Services;
import com.devexperts.util.InvalidFormatException;
import com.devexperts.util.SystemProperties;
import com.devexperts.util.TimePeriod;
import java.io.IOException;
import java.net.Socket;
import java.util.LinkedHashSet;
import java.util.Set;

public class MessageAdapterConnectionFactory
extends ApplicationConnectionFactory {
    private static final TimePeriod DEFAULT_HEARTBEAT_PERIOD = TimePeriod.valueOf(SystemProperties.getProperty("com.devexperts.connector.proto.heartbeatPeriod", "10s"));
    private static final TimePeriod DEFAULT_HEARTBEAT_TIMEOUT = TimePeriod.valueOf(SystemProperties.getProperty("com.devexperts.connector.proto.heartbeatTimeout", "2m"));
    private static final TimePeriod INITIAL_HEARTBEAT_PERIOD = TimePeriod.valueOf(SystemProperties.getProperty(MessageAdapterConnection.class, "initialHeartbeatPeriod", ".5s"));
    private MessageAdapter.ConfigurableFactory factory;
    private String user = "";
    private String password = "";
    private QDAuthRealm authRealm;
    private QDLoginHandler loginHandler;
    private TimePeriod heartbeatPeriod = DEFAULT_HEARTBEAT_PERIOD;
    private TimePeriod heartbeatTimeout = DEFAULT_HEARTBEAT_TIMEOUT;
    private TimePeriod initialHeartbeatPeriod = INITIAL_HEARTBEAT_PERIOD;

    public <T> T getEndpoint(Class<T> endpointClass) {
        return this.factory.getEndpoint(endpointClass);
    }

    MessageAdapterConnectionFactory(MessageAdapter.ConfigurableFactory factory) {
        if (factory == null) {
            throw new NullPointerException();
        }
        this.factory = factory;
    }

    @Override
    public ApplicationConnection<?> createConnection(TransportConnection transportConnection) throws IOException {
        MessageAdapter.ConfigurableFactory factory = this.getMessageAdapterFactory();
        Socket socket = transportConnection.variables().get(MessageConnectors.SOCKET_KEY);
        QDStats stats = transportConnection.variables().get(MessageConnectors.STATS_KEY);
        if (stats == null) {
            stats = QDStats.VOID;
        }
        MessageAdapter adapter = socket != null && factory instanceof SocketMessageAdapterFactory ? ((SocketMessageAdapterFactory)((Object)factory)).createAdapterWithSocket(socket, stats) : factory.createAdapter(stats);
        adapter.setConnectionVariables(transportConnection.variables());
        adapter.setLoginHandler(this.loginHandler);
        adapter.setAuthRealm(this.authRealm);
        transportConnection.variables();
        return new MessageAdapterConnection(adapter, this, transportConnection);
    }

    MessageAdapter.ConfigurableFactory getMessageAdapterFactory() {
        return this.factory;
    }

    @Override
    public ApplicationConnectionFactory clone() {
        MessageAdapterConnectionFactory clone = (MessageAdapterConnectionFactory)super.clone();
        clone.factory = this.factory.clone();
        return clone;
    }

    @Override
    public Set<ConfigurationKey<?>> supportedConfiguration() {
        LinkedHashSet set = new LinkedHashSet(super.supportedConfiguration());
        set.addAll(this.factory.supportedConfiguration());
        return set;
    }

    @Override
    public <T> T getConfiguration(ConfigurationKey<T> key) {
        if (super.supportedConfiguration().contains(key)) {
            return super.getConfiguration(key);
        }
        return this.factory.getConfiguration(key);
    }

    @Override
    public <T> boolean setConfiguration(ConfigurationKey<T> key, T value) {
        if (super.supportedConfiguration().contains(key)) {
            return super.setConfiguration(key, value);
        }
        return this.factory.setConfiguration(key, value);
    }

    public String getUser() {
        return this.user;
    }

    @Configurable(description="user name for basic authentication")
    public void setUser(String user) {
        if (user == null) {
            throw new NullPointerException();
        }
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    @Configurable(description="password for basic authentication")
    public void setPassword(String password) {
        if (password == null) {
            throw new NullPointerException();
        }
        this.password = password;
    }

    @Configurable(description="Login plugin")
    public void setLogin(String login) {
        for (QDLoginHandlerFactory factory : Services.createServices(QDLoginHandlerFactory.class, null)) {
            this.loginHandler = factory.createLoginHandler(login, this);
            if (this.loginHandler == null) continue;
            return;
        }
        this.loginHandler = BasicLoginHandlerFactory.INSTANCE.createLoginHandler(login, this);
    }

    public QDLoginHandler getLogin() {
        return this.loginHandler;
    }

    @Configurable(description="Auth plugin")
    public void setAuth(String auth) {
        for (QDAuthRealmFactory factory : Services.createServices(QDAuthRealmFactory.class, null)) {
            this.authRealm = factory.createAuthRealm(auth, this);
            if (this.authRealm == null) continue;
            return;
        }
        this.authRealm = BasicAuthRealmFactory.INSTANCE.createAuthRealm(auth, this);
    }

    public QDAuthRealm getAuth() {
        return this.authRealm;
    }

    @Override
    public void reinitConfiguration() {
        if (this.authRealm != null && this.loginHandler != null) {
            throw new InvalidFormatException("Cannot have both auth and login set");
        }
        if (this.authRealm == null && this.loginHandler == null && !this.user.isEmpty() && !this.password.isEmpty()) {
            this.loginHandler = new BasicLoginHandler(this.user, this.password);
        }
    }

    public TimePeriod getHeartbeatPeriod() {
        return this.heartbeatPeriod;
    }

    @Configurable(description="Long-term heartbeat period for this connection")
    public void setHeartbeatPeriod(TimePeriod heartbeatPeriod) {
        if (heartbeatPeriod.getTime() <= 0L) {
            throw new IllegalArgumentException("cannot be negative or zero");
        }
        this.heartbeatPeriod = heartbeatPeriod;
    }

    public TimePeriod getInitialHeartbeatPeriod() {
        return this.initialHeartbeatPeriod;
    }

    @Configurable(description="Initial heartbeat period for this connection")
    public void setInitialHeartbeatPeriod(TimePeriod initialHeartbeatPeriod) {
        if (initialHeartbeatPeriod.getTime() <= 0L) {
            throw new IllegalArgumentException("cannot be negative or zero");
        }
        this.initialHeartbeatPeriod = initialHeartbeatPeriod;
    }

    public TimePeriod getHeartbeatTimeout() {
        return this.heartbeatTimeout;
    }

    @Configurable(description="heartbeat timeout for this connection")
    public void setHeartbeatTimeout(TimePeriod heartbeatTimeout) {
        if (heartbeatTimeout.getTime() <= 0L) {
            throw new IllegalArgumentException("cannot be negative or zero");
        }
        this.heartbeatTimeout = heartbeatTimeout;
    }

    @Override
    public String toString() {
        return this.factory.toString();
    }
}

