/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.qtp;

import com.devexperts.auth.AuthSession;
import com.devexperts.auth.AuthToken;
import com.devexperts.connector.proto.Configurable;
import com.devexperts.connector.proto.ConfigurableObject;
import com.devexperts.connector.proto.ConfigurationException;
import com.devexperts.connector.proto.EndpointId;
import com.devexperts.connector.proto.TransportConnection;
import com.devexperts.qd.DataScheme;
import com.devexperts.qd.QDCollector;
import com.devexperts.qd.QDFilter;
import com.devexperts.qd.QDHistory;
import com.devexperts.qd.QDLog;
import com.devexperts.qd.QDStream;
import com.devexperts.qd.QDTicker;
import com.devexperts.qd.SubscriptionFilter;
import com.devexperts.qd.kit.CompositeFilters;
import com.devexperts.qd.kit.FilterSyntaxException;
import com.devexperts.qd.qtp.AddressSyntaxException;
import com.devexperts.qd.qtp.AuthManager;
import com.devexperts.qd.qtp.ConfigurableMessageAdapterFactory;
import com.devexperts.qd.qtp.LoginManager;
import com.devexperts.qd.qtp.MasterMessageAdapter;
import com.devexperts.qd.qtp.MessageAdapterMBean;
import com.devexperts.qd.qtp.MessageConnectors;
import com.devexperts.qd.qtp.MessageConsumerAdapter;
import com.devexperts.qd.qtp.MessageListener;
import com.devexperts.qd.qtp.MessageProvider;
import com.devexperts.qd.qtp.MessageType;
import com.devexperts.qd.qtp.MessageVisitor;
import com.devexperts.qd.qtp.ProtocolDescriptor;
import com.devexperts.qd.qtp.ProtocolOption;
import com.devexperts.qd.qtp.QDEndpoint;
import com.devexperts.qd.qtp.auth.QDAuthRealm;
import com.devexperts.qd.qtp.auth.QDLoginHandler;
import com.devexperts.qd.stats.QDStats;
import com.devexperts.util.SystemProperties;
import com.devexperts.util.TypedMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public abstract class MessageAdapter
extends MessageConsumerAdapter
implements MessageProvider,
MessageAdapterMBean {
    private static final boolean SKIP_CORRUPTED_MESSAGES = SystemProperties.getBooleanProperty(MessageAdapter.class, "skipCorruptedMessages", false);
    private static final boolean SKIP_UNKNOWN_MESSAGES = SystemProperties.getBooleanProperty(MessageAdapter.class, "skipUnknownMessages", false);
    public static final String AUTHENTICATION_LOGIN_REQUIRED = "LOGIN ";
    private final QDEndpoint endpoint;
    private volatile State state = State.NEW;
    private boolean markedForImmediateRestart;
    private final AtomicLong mask = new AtomicLong();
    private final QDStats stats;
    protected boolean useDescribeProtocol;
    protected boolean doNotCloseOnErrors;
    protected volatile CloseListener closeListener;
    protected volatile MessageListener messageListener;
    @Nullable
    private TypedMap connectionVariables;
    protected EndpointId remoteEndpointId;
    private ProtocolOption.Set remoteOptSet = ProtocolOption.EMPTY_SET;
    private MasterMessageAdapter master;
    private AuthManager authManager;
    private LoginManager loginManager;
    private long reportedIgnoredMessages;

    public static DataScheme getCommonScheme(QDCollector c1, QDCollector c2, QDCollector c3) {
        DataScheme s;
        DataScheme s3;
        DataScheme s1 = c1 != null ? c1.getScheme() : null;
        DataScheme s2 = c2 != null ? c2.getScheme() : null;
        DataScheme dataScheme = s3 = c3 != null ? c3.getScheme() : null;
        DataScheme dataScheme2 = s1 != null ? s1 : (s = s2 != null ? s2 : s3);
        if (s == null) {
            throw new IllegalArgumentException("All schemes are null.");
        }
        if (s != s2 && s2 != null || s != s3 && s3 != null) {
            throw new IllegalArgumentException("The schemes are different.");
        }
        return s;
    }

    protected MessageAdapter(QDEndpoint endpoint, QDStats stats) {
        this.endpoint = endpoint;
        this.stats = stats;
    }

    protected MessageAdapter(QDStats stats) {
        this(null, stats);
    }

    public abstract DataScheme getScheme();

    public QDEndpoint getEndpoint() {
        return this.endpoint;
    }

    public String toString() {
        String suffix;
        String desc = this.getClass().getSimpleName();
        return desc.endsWith(suffix = "Adapter") ? desc.substring(0, desc.length() - suffix.length()) : desc;
    }

    protected void notifyListener() {
        MessageListener listener = this.messageListener;
        if (listener != null) {
            listener.messagesAvailable(this);
        }
    }

    public void setCloseListener(CloseListener listener) {
        this.closeListener = listener;
    }

    public long nextRetrieveTime(long currentTime) {
        return this.authManager != null ? this.authManager.getAuthDisconnectTime() : Long.MAX_VALUE;
    }

    public boolean supportsMixedSubscription() {
        return false;
    }

    boolean hasAuthRealm() {
        return this.authManager != null;
    }

    public void setAuthRealm(QDAuthRealm authRealm) {
        if (authRealm == null) {
            return;
        }
        if (this.loginManager != null || this.authManager != null) {
            throw new IllegalStateException();
        }
        this.authManager = new AuthManager(this, authRealm);
    }

    public void setLoginHandler(QDLoginHandler loginHandler) {
        if (loginHandler == null) {
            return;
        }
        if (this.loginManager != null || this.authManager != null) {
            throw new IllegalStateException();
        }
        this.loginManager = new LoginManager(loginHandler, this, this.endpoint.getName());
    }

    @Nullable
    public TypedMap getConnectionVariables() {
        return this.connectionVariables;
    }

    public synchronized void setConnectionVariables(@Nonnull TypedMap connectionVariables) {
        if (this.connectionVariables != null) {
            throw new IllegalStateException("Connection variables were already set");
        }
        this.connectionVariables = connectionVariables;
    }

    protected String getRemoteHostAddress() {
        return this.connectionVariables == null ? null : this.connectionVariables.get(TransportConnection.REMOTE_HOST_ADDRESS_KEY);
    }

    public EndpointId getRemoteEndpointId() {
        return this.remoteEndpointId;
    }

    public void useDescribeProtocol() {
        if (this.isAlive()) {
            throw new IllegalStateException("Must be invoked before start");
        }
        this.useDescribeProtocol = true;
    }

    protected long retrieveDescribeProtocolMessage(MessageVisitor visitor, long mask) {
        if (!MessageAdapter.hasMessageMask(mask, MessageType.DESCRIBE_PROTOCOL)) {
            return mask;
        }
        ProtocolDescriptor desc = ProtocolDescriptor.newSelfProtocolDescriptor("qtp");
        this.prepareCommonProtocolDescriptor(desc);
        if (this.endpoint != null) {
            desc.setEndpointId(this.endpoint.getEndpointId());
        }
        this.updateManagerState(true);
        if (this.authManager == null || !this.authManager.authenticatePreparing()) {
            this.prepareProtocolDescriptor(desc);
        } else {
            this.prepareAuthenticateProtocolDescriptor(desc);
        }
        if (this.master != null) {
            this.master.augmentProtocolDescriptor(desc);
        }
        visitor.visitDescribeProtocol(desc);
        mask = MessageAdapter.clearMessageMask(mask, MessageType.DESCRIBE_PROTOCOL);
        this.updateManagerState(false);
        return mask;
    }

    public void reinitConfiguration(AuthSession session) {
    }

    public void prepareProtocolDescriptor(ProtocolDescriptor desc) {
        if (this.loginManager != null) {
            this.loginManager.prepareProtocolDescriptor(desc);
        }
        if (this.authManager != null && this.authManager.firstAuthProtocolWasSent()) {
            desc.setProperty("authentication", "");
        }
    }

    protected void prepareAuthenticateProtocolDescriptor(ProtocolDescriptor desc) {
        desc.setProperty("authentication", this.authManager.getReason());
    }

    private void prepareCommonProtocolDescriptor(ProtocolDescriptor desc) {
        if (this.endpoint != null) {
            Map<String, String> descriptorProperties = this.endpoint.getDescriptorProperties();
            for (Map.Entry<String, String> entry : descriptorProperties.entrySet()) {
                String key = entry.getKey();
                if (desc.getProperty(key) != null) continue;
                desc.setProperty(key, entry.getValue());
            }
        }
        desc.addSend(desc.newMessageDescriptor(MessageType.PART));
        desc.addReceive(desc.newMessageDescriptor(MessageType.PART));
    }

    @Override
    public void processDescribeProtocol(ProtocolDescriptor desc, boolean logDescriptor) {
        this.remoteOptSet = ProtocolOption.parseProtocolOptions(desc.getProperty("opt"));
        if (logDescriptor) {
            String authProp = desc.getProperty("authentication");
            if (authProp != null && !authProp.isEmpty()) {
                this.logAuthRequestDescriptor(desc);
            } else {
                this.logIncomingProtocolDescriptor(desc);
            }
        }
        this.remoteEndpointId = desc.getEndpointId();
        String auth = desc.getProperty("authorization");
        if (auth != null) {
            if (this.authManager != null) {
                this.authManager.authenticate(AuthToken.valueOf(auth), this.connectionVariables);
            } else if (this.connectionVariables != null) {
                this.connectionVariables.set(TransportConnection.SUBJECT_KEY, AuthToken.valueOf(auth));
            }
        }
        String authInfo = desc.getProperty("authentication");
        if (this.loginManager != null && authInfo != null) {
            if (authInfo.isEmpty()) {
                this.loginManager.completeLogin();
            } else {
                this.loginManager.login(authInfo);
            }
        }
    }

    public final void processDescribeProtocol(ProtocolDescriptor desc) {
        throw new UnsupportedOperationException();
    }

    public boolean isProtocolDescriptorCompatible(ProtocolDescriptor desc) {
        return true;
    }

    protected ProtocolOption.Set getRemoteOptSet() {
        return this.remoteOptSet;
    }

    private void updateManagerState(boolean beforePreparing) {
        if (this.loginManager != null) {
            this.loginManager.updateState(beforePreparing);
        } else if (this.authManager != null) {
            this.authManager.updateState(beforePreparing);
        }
    }

    private void logAuthRequestDescriptor(ProtocolDescriptor desc) {
        StringBuilder sb = new StringBuilder(this.toString());
        sb.append(" received authentication request ").append(desc);
        String host = this.getRemoteHostAddress();
        if (host != null) {
            sb.append(" from ").append(host);
        }
        QDLog.log.info(sb.toString());
    }

    private void logIncomingProtocolDescriptor(ProtocolDescriptor desc) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.toString()).append(" received protocol descriptor ").append(desc);
        String host = this.getRemoteHostAddress();
        if (host != null) {
            sb.append(" from ").append(host);
        }
        if (desc.getSendMessages().isEmpty() || this.isProtocolDescriptorCompatible(desc)) {
            QDLog.log.debug(sb.toString());
        } else {
            sb.append("\n!!! IT IS NOT A COMPATIBLE PROTOCOL !!!");
            sb.append(" Maybe connection was established to the wrong host or port?");
            QDLog.log.warn(sb.toString());
        }
    }

    public QDStats getStats() {
        return this.stats;
    }

    @Override
    public void handleCorruptedStream() {
        super.handleCorruptedStream();
        if (!this.doNotCloseOnErrors) {
            this.close();
        }
    }

    @Override
    public void handleCorruptedMessage(int messageTypeId) {
        super.handleCorruptedMessage(messageTypeId);
        if (!this.doNotCloseOnErrors && !SKIP_CORRUPTED_MESSAGES) {
            this.close();
        }
    }

    @Override
    public void handleUnknownMessage(int messageTypeId) {
        super.handleUnknownMessage(messageTypeId);
        if (!this.doNotCloseOnErrors && !SKIP_UNKNOWN_MESSAGES) {
            this.close();
        }
    }

    @Override
    public boolean retrieveMessages(MessageVisitor visitor) {
        if (this.authManager != null && System.currentTimeMillis() > this.authManager.getAuthDisconnectTime()) {
            this.close();
        }
        return false;
    }

    @Override
    public void setMessageListener(MessageListener listener) {
        this.messageListener = listener;
    }

    @Override
    public final boolean isAlive() {
        return this.state == State.STARTED;
    }

    public final boolean isClosed() {
        return this.state == State.CLOSED;
    }

    public final String getStatus() {
        return this.state.toString();
    }

    public final void start() {
        this.reinitConfiguration(null);
        this.start(null);
    }

    public final synchronized void start(MasterMessageAdapter master) {
        if (this.state != State.NEW) {
            throw new IllegalStateException(this.state == State.STARTED ? "Adapter is already started." : "Adapter is already closed.");
        }
        this.state = State.STARTED;
        this.startImpl(master);
        if (this.mask.get() != 0L) {
            this.notifyListener();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() {
        MessageAdapter messageAdapter = this;
        synchronized (messageAdapter) {
            if (this.state == State.CLOSED) {
                return;
            }
            this.state = State.CLOSED;
            this.closeImpl();
        }
        CloseListener listener = this.closeListener;
        if (listener != null) {
            listener.adapterClosed(this);
        }
        if (this.loginManager != null) {
            this.loginManager.close();
        }
        if (this.authManager != null) {
            this.authManager.close();
        }
    }

    public void markForImmediateRestart() {
        this.markedForImmediateRestart = true;
    }

    public boolean isMarkedForImmediateRestart() {
        return this.markedForImmediateRestart;
    }

    protected void startImpl(MasterMessageAdapter master) {
        this.master = master;
        if (this.useDescribeProtocol) {
            this.addMask(MessageAdapter.getMessageMask(MessageType.DESCRIBE_PROTOCOL));
        }
    }

    protected void closeImpl() {
    }

    protected void reportIgnoredMessage(String reason, MessageType message) {
        if ((this.reportedIgnoredMessages & 1L << message.ordinal()) != 0L) {
            return;
        }
        this.reportedIgnoredMessages |= 1L << message.ordinal();
        QDLog.log.error("WARNING: " + reason + " -- ignoring " + (Object)((Object)message) + " message");
    }

    protected final long retrieveMask() {
        if (!this.isAlive()) {
            return 0L;
        }
        return this.mask.getAndSet(0L);
    }

    protected final boolean addMask(long mask) {
        long newMask;
        long oldMask;
        if (mask == 0L) {
            return false;
        }
        do {
            if ((newMask = (oldMask = this.mask.get()) | mask) != oldMask) continue;
            return false;
        } while (!this.mask.compareAndSet(oldMask, newMask));
        if (this.isAlive()) {
            this.notifyListener();
            return true;
        }
        return false;
    }

    protected static long getMessageMask(MessageType message) {
        return 1L << message.getId();
    }

    protected static boolean hasMessageMask(long mask, MessageType message) {
        return (mask & MessageAdapter.getMessageMask(message)) != 0L;
    }

    protected static long clearMessageMask(long mask, MessageType message) {
        return mask & (MessageAdapter.getMessageMask(message) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private static enum State {
        NEW,
        STARTED,
        CLOSED;

    }

    public static abstract class AbstractFactory
    extends ConfigurableFactory {
        protected final QDEndpoint endpoint;
        protected final DataScheme scheme;
        protected final QDTicker ticker;
        protected final QDStream stream;
        protected final QDHistory history;
        @Nonnull
        @GuardedBy(value="this")
        protected QDFilter filter;
        @Nonnull
        private final QDFilter initialFilter;

        protected AbstractFactory(QDTicker ticker, QDStream stream, QDHistory history, SubscriptionFilter filter) {
            this.endpoint = null;
            this.scheme = MessageAdapter.getCommonScheme(ticker, stream, history);
            this.ticker = ticker;
            this.stream = stream;
            this.history = history;
            this.filter = this.initialFilter = QDFilter.fromFilter(filter, MessageAdapter.getCommonScheme(ticker, stream, history));
        }

        protected AbstractFactory(QDEndpoint endpoint, SubscriptionFilter filter) {
            this.endpoint = endpoint;
            this.scheme = endpoint.getScheme();
            this.ticker = endpoint.getTicker();
            this.stream = endpoint.getStream();
            this.history = endpoint.getHistory();
            this.filter = this.initialFilter = QDFilter.fromFilter(filter, this.scheme);
            this.setEndpoint(QDEndpoint.class, endpoint);
        }

        public DataScheme getScheme() {
            return this.scheme;
        }

        public QDCollector[] getCollectors() {
            return new QDCollector[]{this.ticker, this.stream, this.history};
        }

        public synchronized QDFilter getFilter() {
            this.filter = this.filter.getUpdatedFilter();
            return this.filter;
        }

        @Configurable(description="default filter for all channels")
        public synchronized void setFilter(String filterString) throws FilterSyntaxException {
            this.filter = filterString == null || filterString.isEmpty() ? this.initialFilter : CompositeFilters.makeAnd(CompositeFilters.valueOf(filterString, this.scheme), this.initialFilter);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String toString() {
            String filterString;
            String s = super.toString();
            AbstractFactory abstractFactory = this;
            synchronized (abstractFactory) {
                if (this.filter == QDFilter.ANYTHING) {
                    return s;
                }
                filterString = this.filter.toString();
            }
            return s + "[" + filterString.replace('.', '_') + "]";
        }
    }

    public static abstract class ConfigurableFactory
    extends ConfigurableObject
    implements Factory,
    ConfigurableMessageAdapterFactory {
        private final Map<Class<?>, Object> endpoints = new ConcurrentHashMap();

        @Override
        public abstract MessageAdapter createAdapter(QDStats var1);

        @Override
        public ConfigurableFactory clone() {
            return (ConfigurableFactory)super.clone();
        }

        @Override
        public final Factory createMessageAdapterFactory(String spec) throws AddressSyntaxException {
            if (spec == null || spec.isEmpty()) {
                return this;
            }
            ConfigurableFactory clone = this.clone();
            try {
                clone.setConfiguration(MessageConnectors.FILTER_CONFIGURATION_KEY, spec);
            }
            catch (ConfigurationException e) {
                throw new AddressSyntaxException(e.getMessage(), e.getCause());
            }
            return clone;
        }

        public String toString() {
            String suffix;
            String desc = this.getClass().getSimpleName();
            if (desc.equals(suffix = "Factory") && this.getClass().getEnclosingClass() != null) {
                desc = this.getClass().getEnclosingClass().getSimpleName();
            } else if (desc.length() > suffix.length() && desc.endsWith(suffix)) {
                desc = desc.substring(0, desc.length() - suffix.length());
            }
            suffix = "Adapter";
            if (desc.length() > suffix.length() && desc.endsWith(suffix)) {
                desc = desc.substring(0, desc.length() - suffix.length());
            }
            return desc;
        }

        public <T> void setEndpoint(Class<?> endpointClass, T endpointInstance) {
            Object old = this.endpoints.put(endpointClass, endpointInstance);
            if (old != null) {
                throw new IllegalStateException("Endpoint of class " + endpointClass + " was already set");
            }
        }

        public <T> T getEndpoint(Class<T> endpointClass) {
            return (T)this.endpoints.get(endpointClass);
        }
    }

    public static interface Factory {
        public MessageAdapter createAdapter(QDStats var1);
    }

    public static interface CloseListener {
        public void adapterClosed(MessageAdapter var1);
    }
}

