/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.qtp;

import com.devexperts.auth.AuthToken;
import com.devexperts.qd.qtp.MessageAdapter;
import com.devexperts.qd.qtp.MessageType;
import com.devexperts.qd.qtp.ProtocolDescriptor;
import com.devexperts.qd.qtp.auth.QDLoginHandler;
import com.dxfeed.promise.Promise;
import com.dxfeed.promise.PromiseHandler;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

class LoginManager
implements PromiseHandler<AuthToken> {
    private final MessageAdapter messageAdapter;
    private final String endpointName;
    private final QDLoginHandler handler;
    private AuthToken accessToken;
    private AuthToken lastSendAccessToken;
    private LoginState state;
    private boolean firstProtocolWasPrepared;
    private boolean firstProtocolWasSend;
    private final List<Promise<AuthToken>> promises = new CopyOnWriteArrayList<Promise<AuthToken>>();

    LoginManager(QDLoginHandler handler, MessageAdapter messageAdapter, String endpointName) {
        this.handler = handler;
        this.messageAdapter = messageAdapter;
        this.endpointName = endpointName;
        this.accessToken = handler.getAuthToken();
        this.state = LoginState.NEW;
    }

    void login(String reason) {
        Action action = this.loginSync(reason);
        if (action.needLogin) {
            Promise<AuthToken> authToken = this.handler.login(reason);
            authToken.whenDone(this);
            this.promises.add(authToken);
            return;
        }
        if (action == Action.ADD_MASK) {
            this.messageAdapter.addMask(MessageAdapter.getMessageMask(MessageType.DESCRIBE_PROTOCOL));
        }
    }

    private synchronized Action loginSync(String reason) {
        this.accessToken = this.handler.getAuthToken();
        boolean loginRequired = reason.startsWith("LOGIN ");
        if (this.accessToken != null && (!this.accessToken.equals(this.lastSendAccessToken) || loginRequired)) {
            LoginState current = this.state;
            if (current == LoginState.WAITING_OTHER_SIDE && loginRequired) {
                return Action.NOTHING;
            }
            this.state = LoginState.END_LOGIN;
            return current == LoginState.WAITING_OTHER_SIDE ? Action.ADD_MASK : Action.NOTHING;
        }
        switch (this.state) {
            case NEW: 
            case WAITING_OTHER_SIDE: {
                this.state = LoginState.LOGIN;
                break;
            }
            case START_DATA_PREPARING: {
                this.state = LoginState.LOGIN_AND_START_DATA_PREPARING;
                break;
            }
            case FINISH_DATA_PREPARING: {
                this.state = LoginState.LOGIN_AND_FINISH_DATA_PREPARING;
                break;
            }
            default: {
                throw new AssertionError((Object)(this.endpointName + ": state = " + (Object)((Object)this.state)));
            }
        }
        return Action.LOGIN;
    }

    synchronized void prepareProtocolDescriptor(ProtocolDescriptor desc) {
        this.firstProtocolWasPrepared = true;
        this.state = this.state == LoginState.LOGIN_AND_START_DATA_PREPARING ? LoginState.LOGIN_AND_FINISH_DATA_PREPARING : LoginState.FINISH_DATA_PREPARING;
        if (this.accessToken != null) {
            desc.setProperty("authorization", this.accessToken.toString());
            this.lastSendAccessToken = this.accessToken;
        }
    }

    synchronized void completeLogin() {
        this.state = LoginState.COMPLETED;
    }

    void updateState(boolean beforePreparing) {
        if (this.updateStateSync(beforePreparing)) {
            this.messageAdapter.addMask(MessageAdapter.getMessageMask(MessageType.DESCRIBE_PROTOCOL));
        }
    }

    private synchronized boolean updateStateSync(boolean beforePreparing) {
        return beforePreparing ? this.updateBefore() : this.updateAfter();
    }

    void close() {
        this.promises.forEach(Promise::cancel);
    }

    private boolean updateBefore() {
        switch (this.state) {
            case NEW: {
                this.state = LoginState.START_DATA_PREPARING;
                return false;
            }
            case LOGIN: {
                this.state = LoginState.LOGIN_AND_START_DATA_PREPARING;
                return false;
            }
            case END_LOGIN: {
                this.state = LoginState.START_DATA_PREPARING;
                return false;
            }
        }
        throw new AssertionError();
    }

    private boolean updateAfter() {
        boolean result;
        switch (this.state) {
            case FINISH_DATA_PREPARING: {
                this.state = LoginState.WAITING_OTHER_SIDE;
                result = false;
                break;
            }
            case LOGIN_AND_FINISH_DATA_PREPARING: {
                this.state = LoginState.LOGIN;
                result = false;
                break;
            }
            case END_LOGIN: {
                if (!this.firstProtocolWasSend) {
                    this.state = LoginState.WAITING_OTHER_SIDE;
                }
                result = this.firstProtocolWasSend;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        this.firstProtocolWasSend = true;
        return result;
    }

    @Override
    public void promiseDone(Promise<? extends AuthToken> promise) {
        if (promise.hasResult() && this.updateAccessTokenSync(promise.getResult())) {
            this.messageAdapter.addMask(MessageAdapter.getMessageMask(MessageType.DESCRIBE_PROTOCOL));
        }
        this.promises.remove(promise);
    }

    private synchronized boolean updateAccessTokenSync(AuthToken token) {
        if (!this.state.loginProcess) {
            return false;
        }
        this.accessToken = token;
        boolean addMask = this.state == LoginState.LOGIN && this.firstProtocolWasPrepared;
        this.state = LoginState.END_LOGIN;
        return addMask;
    }

    private static enum Action {
        ADD_MASK(false),
        LOGIN(true),
        NOTHING(false);

        private final boolean needLogin;

        private Action(boolean needLogin) {
            this.needLogin = needLogin;
        }
    }

    private static enum LoginState {
        NEW(false),
        LOGIN(true),
        END_LOGIN(false),
        LOGIN_AND_START_DATA_PREPARING(true),
        LOGIN_AND_FINISH_DATA_PREPARING(true),
        START_DATA_PREPARING(false),
        FINISH_DATA_PREPARING(false),
        WAITING_OTHER_SIDE(false),
        COMPLETED(false);

        private final boolean loginProcess;

        private LoginState(boolean loginProcess) {
            this.loginProcess = loginProcess;
        }
    }
}

