/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.qtp;

import com.devexperts.io.BufferedInput;
import com.devexperts.io.BufferedOutput;
import com.devexperts.util.InvalidFormatException;
import com.devexperts.util.TimeFormat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class HeartbeatPayload {
    private static final String TIME_MILLIS_KEY = "time=";
    private static final String TIME_MARK_KEY = "mark=";
    private static final String DELTA_MARK_KEY = "delta=";
    private static final String LAG_MARK_KEY = "lag=";
    private static final int CONTENT_EMPTY = 0;
    private static final int CONTENT_TIME_MILLIS = 1;
    private static final int CONTENT_TIME_MARK = 2;
    private static final int CONTENT_DELTA_MARK = 4;
    private static final int CONTENT_LAG_MARK = 8;
    private int contentBits;
    private long timeMillis;
    private int timeMark;
    private int deltaMark;
    private int lagMark;

    public boolean isEmpty() {
        return this.contentBits == 0;
    }

    public void clear() {
        this.contentBits = 0;
        this.timeMillis = 0L;
        this.timeMark = 0;
        this.deltaMark = 0;
        this.lagMark = 0;
    }

    public void updateFrom(HeartbeatPayload other) {
        if (other.hasTimeMillis()) {
            this.setTimeMillis(other.timeMillis);
        }
        if (other.hasTimeMark()) {
            this.setTimeMark(other.timeMark);
        }
        if (other.hasDeltaMark()) {
            this.setDeltaMark(other.deltaMark);
        }
        if (other.hasLagMark()) {
            this.setLagMark(other.lagMark);
        }
    }

    public boolean hasTimeMillis() {
        return (this.contentBits & 1) != 0;
    }

    public long getTimeMillis() {
        return this.timeMillis;
    }

    public void setTimeMillis(long timeMillis) {
        this.contentBits |= 1;
        this.timeMillis = timeMillis;
    }

    public boolean hasTimeMark() {
        return (this.contentBits & 2) != 0;
    }

    public int getTimeMark() {
        return this.timeMark;
    }

    public void setTimeMark(int timeMark) {
        this.contentBits |= 2;
        this.timeMark = timeMark;
    }

    public boolean hasDeltaMark() {
        return (this.contentBits & 4) != 0;
    }

    public int getDeltaMark() {
        return this.deltaMark;
    }

    public void setDeltaMark(int deltaMark) {
        this.contentBits |= 4;
        this.deltaMark = deltaMark;
    }

    public boolean hasLagMark() {
        return (this.contentBits & 8) != 0;
    }

    public int getLagMark() {
        return this.lagMark;
    }

    public void setLagMark(int lagMark) {
        this.contentBits |= 8;
        this.lagMark = lagMark;
    }

    public void composeTo(BufferedOutput out) throws IOException {
        out.writeCompactInt(this.contentBits);
        if (this.hasTimeMillis()) {
            out.writeCompactLong(this.timeMillis);
        }
        if (this.hasTimeMark()) {
            out.writeCompactInt(this.timeMark);
        }
        if (this.hasDeltaMark()) {
            out.writeCompactInt(this.deltaMark);
        }
        if (this.hasLagMark()) {
            out.writeCompactInt(this.lagMark);
        }
    }

    public void parseFrom(BufferedInput in) throws IOException {
        this.contentBits = in.readCompactInt();
        if (this.hasTimeMillis()) {
            this.timeMillis = in.readCompactLong();
        }
        if (this.hasTimeMark()) {
            this.timeMark = in.readCompactInt();
        }
        if (this.hasDeltaMark()) {
            this.deltaMark = in.readCompactInt();
        }
        if (this.hasLagMark()) {
            this.lagMark = in.readCompactInt();
        }
    }

    public List<String> convertToTextTokens() {
        ArrayList<String> tokens = new ArrayList<String>();
        if (this.hasTimeMillis()) {
            tokens.add(TIME_MILLIS_KEY + TimeFormat.DEFAULT.withMillis().withTimeZone().format(this.timeMillis));
        }
        if (this.hasTimeMark()) {
            tokens.add(TIME_MARK_KEY + this.timeMark);
        }
        if (this.hasDeltaMark()) {
            tokens.add(DELTA_MARK_KEY + this.deltaMark);
        }
        if (this.hasLagMark()) {
            tokens.add(LAG_MARK_KEY + this.lagMark);
        }
        return tokens;
    }

    public void appendFromTextTokens(List<String> tokens, int i) {
        while (i < tokens.size()) {
            String token;
            if ((token = tokens.get(i++)).startsWith(TIME_MILLIS_KEY)) {
                this.setTimeMillis(TimeFormat.DEFAULT.parse(token.substring(TIME_MILLIS_KEY.length())).getTime());
                continue;
            }
            if (token.startsWith(TIME_MARK_KEY)) {
                this.setTimeMark(HeartbeatPayload.parseInt(TIME_MARK_KEY, token));
                continue;
            }
            if (token.startsWith(DELTA_MARK_KEY)) {
                this.setDeltaMark(HeartbeatPayload.parseInt(DELTA_MARK_KEY, token));
                continue;
            }
            if (!token.startsWith(LAG_MARK_KEY)) continue;
            this.setLagMark(HeartbeatPayload.parseInt(LAG_MARK_KEY, token));
        }
    }

    private static int parseInt(String key, String token) {
        try {
            return Integer.parseInt(token.substring(key.length()));
        }
        catch (NumberFormatException e) {
            throw new InvalidFormatException(e.getMessage(), e);
        }
    }

    public String toString() {
        return this.convertToTextTokens().toString();
    }
}

