/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.qtp;

import com.devexperts.io.ChunkList;
import com.devexperts.io.ChunkedInput;
import com.devexperts.qd.DataRecord;
import com.devexperts.qd.DataScheme;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.ng.RecordMode;
import com.devexperts.qd.qtp.BinaryQTPParser;
import com.devexperts.qd.qtp.BinaryRecordDesc;
import com.devexperts.qd.qtp.HeartbeatPayload;
import com.devexperts.qd.qtp.MessageAdapterConnection;
import com.devexperts.qd.qtp.MessageType;
import com.devexperts.qd.qtp.ProtocolDescriptor;
import java.util.Arrays;

class ConnectionQTPParser
extends BinaryQTPParser {
    private final MessageAdapterConnection connection;
    private final ChunkedInput in;
    private volatile BinaryRecordDesc[] schemeMap;
    private int currentTimeMark;

    ConnectionQTPParser(DataScheme scheme, MessageAdapterConnection connection) {
        super(scheme);
        this.connection = connection;
        this.in = new ChunkedInput(connection.getChunkPool());
        this.setInput(this.in);
    }

    @Override
    public void resetSession() {
        super.resetSession();
        if (this.schemeMap != null) {
            Arrays.fill(this.schemeMap, null);
        }
    }

    @Override
    protected void remapRecord(int id, BinaryRecordDesc rr) {
        super.remapRecord(id, rr);
        if (rr.getRecord() == null) {
            return;
        }
        id = rr.getRecord().getId();
        if (this.schemeMap == null || id >= this.schemeMap.length) {
            this.schemeMap = this.newRecordMap(this.schemeMap, id);
        }
        this.schemeMap[id] = rr;
    }

    protected BinaryRecordDesc getRequestedRecordDesc(DataRecord record) {
        int id = record.getId();
        BinaryRecordDesc[] schemeMap = this.schemeMap;
        return schemeMap != null && id >= 0 && id < schemeMap.length ? schemeMap[id] : null;
    }

    void addChunks(ChunkList chunkList, Object owner) {
        this.in.addAllToInput(chunkList, owner);
    }

    void setCurrentTimeMark(int currentTimeMark) {
        this.currentTimeMark = currentTimeMark;
    }

    @Override
    protected RecordMode getRecordBufferMode(MessageType messageType) {
        RecordMode mode = super.getRecordBufferMode(messageType);
        return messageType.isData() ? mode.withTimeMark() : mode;
    }

    @Override
    void updateCursorTimeMark(RecordCursor cursor) {
        cursor.setTimeMark(this.currentTimeMark);
    }

    @Override
    void updateMoreIOReadSubRecordStats() {
        this.stats.updateIOReadRtts(this.connection.getConnectionRttMark());
    }

    @Override
    void updateMoreIOReadDataRecordStats() {
        this.stats.updateIOReadRtts(this.connection.getConnectionRttMark());
        this.stats.updateIOReadDataLags(this.connection.getIncomingLagMark());
    }

    @Override
    void onDescribeProtocol(ProtocolDescriptor desc) {
        this.connection.processIncomingDescribeProtocol(desc);
    }

    @Override
    void onHeartbeat(HeartbeatPayload heartbeatPayload) {
        this.connection.processIncomingHeartbeat(heartbeatPayload);
    }
}

