/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.qtp;

import com.devexperts.io.ChunkList;
import com.devexperts.io.ChunkedOutput;
import com.devexperts.qd.DataRecord;
import com.devexperts.qd.DataScheme;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.qtp.BinaryQTPComposer;
import com.devexperts.qd.qtp.BinaryRecordDesc;
import com.devexperts.qd.qtp.MessageAdapterConnection;
import com.devexperts.qd.qtp.QTPConstants;
import com.devexperts.qd.qtp.RuntimeQTPException;
import com.devexperts.qd.stats.QDStats;
import com.devexperts.qd.util.TimeMarkUtil;
import java.io.IOException;

class ConnectionQTPComposer
extends BinaryQTPComposer {
    private final MessageAdapterConnection connection;
    private final ChunkedOutput out;
    private long lastPosition;
    private int composingTimeMark;
    private int countDataRecords;
    private long sumTimeMarks;
    private int totalCountDataRecords;
    private long totalSumTimeMarks;
    boolean wideDecimalSupported = true;

    ConnectionQTPComposer(DataScheme scheme, MessageAdapterConnection connection) {
        super(scheme, true);
        this.connection = connection;
        this.out = new ChunkedOutput(connection.getChunkPool());
        this.setOutput(this.out);
    }

    @Override
    public boolean hasCapacity() {
        return this.getProcessed() + this.getMessagePayloadSize() < (long)QTPConstants.COMPOSER_THRESHOLD;
    }

    void writeAllFromChunkList(ChunkList chunks, Object owner) {
        try {
            this.out.writeAllFromChunkList(chunks, owner);
        }
        catch (IOException e) {
            throw new RuntimeQTPException(e);
        }
    }

    long getProcessed() {
        return this.out.totalPosition() - this.lastPosition;
    }

    ChunkList getOutput(Object owner) {
        this.lastPosition = this.out.totalPosition();
        return this.out.getOutput(owner);
    }

    void setComposingTimeMark(int composingTimeMark) {
        this.composingTimeMark = composingTimeMark;
    }

    void addComposingLag(int composingLagMark, QDStats stats) {
        if (this.countDataRecords == 0) {
            return;
        }
        long totalLag = this.sumTimeMarks + (long)composingLagMark * (long)this.countDataRecords;
        stats.updateIOWriteDataLags(totalLag);
        this.totalCountDataRecords += this.countDataRecords;
        this.totalSumTimeMarks += totalLag;
        this.countDataRecords = 0;
        this.sumTimeMarks = 0L;
    }

    int getTotalAverageLagAndClear() {
        if (this.totalCountDataRecords == 0) {
            return 0;
        }
        int result = (int)(this.totalSumTimeMarks / (long)this.totalCountDataRecords);
        this.totalCountDataRecords = 0;
        this.totalSumTimeMarks = 0L;
        return result;
    }

    @Override
    void updateMoreIOWriteRecordStats() {
        this.stats.updateIOWriteRtts(this.connection.getConnectionRttMark());
    }

    @Override
    public void append(RecordCursor cursor) {
        super.append(cursor);
        if (this.currentMessageType.isData()) {
            ++this.countDataRecords;
            int timeMark = cursor.getTimeMark();
            if (timeMark != 0) {
                this.sumTimeMarks += (long)TimeMarkUtil.signedDeltaMark(this.composingTimeMark - timeMark);
            }
        }
    }

    @Override
    protected BinaryRecordDesc getRequestedRecordDesc(DataRecord record) {
        return this.connection.getRequestedRecordDesc(record);
    }

    @Override
    protected boolean isWideDecimalSupported() {
        return this.wideDecimalSupported;
    }
}

