/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.qtp;

import com.devexperts.qd.QDCollector;
import com.devexperts.qd.QDContract;
import com.devexperts.qd.QDFilter;
import com.devexperts.qd.SubscriptionFilter;
import com.devexperts.qd.ng.RecordFilter;
import com.devexperts.qd.qtp.AgentChannel;
import java.util.concurrent.Executor;

public class ChannelShaper
implements Cloneable {
    private final QDContract contract;
    private final Executor subscriptionExecutor;
    private final boolean keepRejected;
    private volatile AgentChannel channel;
    private volatile QDCollector collector;
    private volatile QDFilter subscriptionFilter = QDFilter.ANYTHING;
    private volatile RecordFilter dataFilter;
    private volatile int weight = 1;
    private volatile long aggregationPeriod;

    public ChannelShaper(QDContract contract, Executor subscriptionExecutor) {
        this(contract, subscriptionExecutor, false);
    }

    public ChannelShaper(QDContract contract, Executor subscriptionExecutor, boolean keepRejected) {
        if (contract == null) {
            throw new NullPointerException();
        }
        this.contract = contract;
        this.subscriptionExecutor = subscriptionExecutor;
        this.keepRejected = keepRejected;
    }

    public ChannelShaper(Executor subscriptionExecutor, QDCollector collector, SubscriptionFilter subscriptionFilter, RecordFilter dataFilter) {
        this(collector.getContract(), subscriptionExecutor);
        this.setCollector(collector);
        this.setSubscriptionFilter(subscriptionFilter);
        this.setDataFilter(dataFilter);
    }

    synchronized void bind(AgentChannel channel) {
        if (this.channel != null) {
            throw new IllegalStateException("Already bound");
        }
        if (channel == null) {
            throw new NullPointerException();
        }
        this.channel = channel;
    }

    public void close() {
    }

    public ChannelShaper clone() {
        try {
            ChannelShaper clone = (ChannelShaper)super.clone();
            if (clone.channel != null) {
                throw new IllegalStateException("Cannot clone bound channel");
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public QDContract getContract() {
        return this.contract;
    }

    public boolean hasSubscriptionExecutor() {
        return this.subscriptionExecutor != null;
    }

    public Executor getSubscriptionExecutor() {
        return this.subscriptionExecutor;
    }

    public boolean isKeepRejected() {
        return this.keepRejected;
    }

    public final QDCollector getCollector() {
        return this.collector;
    }

    public void setCollector(QDCollector collector) {
        if (collector != null && collector.getContract() != this.contract) {
            throw new IllegalArgumentException("Wrong contract");
        }
        this.collector = collector;
        this.reconfigureIfNeeded();
    }

    public final QDFilter getSubscriptionFilter() {
        return this.subscriptionFilter;
    }

    public void setSubscriptionFilter(SubscriptionFilter subscriptionFilter) {
        this.setSubscriptionFilter(QDFilter.fromFilter(subscriptionFilter, this.collector == null ? null : this.collector.getScheme()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSubscriptionFilter(QDFilter subscriptionFilter) {
        if (subscriptionFilter == null) {
            subscriptionFilter = QDFilter.ANYTHING;
        }
        boolean updated = false;
        ChannelShaper channelShaper = this;
        synchronized (channelShaper) {
            if (this.subscriptionFilter != subscriptionFilter) {
                this.subscriptionFilter = subscriptionFilter;
                updated = true;
            }
        }
        if (updated) {
            this.reconfigureIfNeeded();
        }
    }

    public RecordFilter getDataFilter() {
        return this.dataFilter;
    }

    public void setDataFilter(RecordFilter dataFilter) {
        this.dataFilter = dataFilter;
        this.reconfigureIfNeeded();
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        if (weight < 1 || weight > 100) {
            throw new IllegalArgumentException("Weight is out of limits: " + weight);
        }
        this.weight = weight;
    }

    public long getAggregationPeriod() {
        return this.aggregationPeriod;
    }

    public void setAggregationPeriod(long aggregationPeriod) {
        if (aggregationPeriod < 0L || aggregationPeriod > 86400000L) {
            throw new IllegalArgumentException("Aggregation period is out of limits: " + aggregationPeriod);
        }
        this.aggregationPeriod = aggregationPeriod;
        this.reconfigureIfNeeded();
    }

    private void reconfigureIfNeeded() {
        AgentChannel channel = this.channel;
        if (channel != null) {
            channel.reconfigureIfNeeded();
        }
    }
}

