/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.qtp;

import com.devexperts.qd.QDContract;
import com.devexperts.qd.util.QDConfig;
import com.devexperts.util.InvalidFormatException;
import com.devexperts.util.TimePeriod;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class ChannelDescription {
    final String filterStr;
    final QDContract contract;
    final TimePeriod aggregationPeriod;
    final List<String> properties = new ArrayList<String>();
    final String channel;

    public ChannelDescription(String channel) {
        this.channel = channel;
        channel = QDConfig.parseProperties(channel, this.properties);
        String[] timeSplit = QDConfig.splitParenthesisedStringAt(channel, '@');
        String filterContract = timeSplit.length == 1 ? channel : timeSplit[0];
        this.aggregationPeriod = timeSplit.length == 1 ? null : TimePeriod.valueOf(timeSplit[1]);
        int i = filterContract.lastIndexOf(38);
        this.filterStr = i < 0 ? null : filterContract.substring(0, i);
        String contractStr = i < 0 ? filterContract : filterContract.substring(i + 1);
        try {
            this.contract = QDContract.valueOf(contractStr.toUpperCase(Locale.US));
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException("Invalid contract name: " + contractStr, e);
        }
    }

    public String toString() {
        return this.channel;
    }
}

