/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.qtp;

import com.devexperts.io.BufferedInput;
import com.devexperts.io.ByteArrayInput;
import com.devexperts.qd.DataScheme;
import com.devexperts.qd.qtp.BinaryQTPParser;
import com.devexperts.util.SystemProperties;

public class ByteArrayParser
extends BinaryQTPParser {
    private static final int POOLED_BUFFER_SIZE = SystemProperties.getIntProperty("com.devexperts.qd.qtp.parserBufferSize", 20000);
    protected final ByteArrayInput in;
    private byte[] pooledBuffer;
    private boolean schemeKnown;

    public ByteArrayParser(DataScheme scheme) {
        this(scheme, false);
    }

    public ByteArrayParser(DataScheme scheme, boolean parseDescribe) {
        super(scheme);
        this.schemeKnown = !parseDescribe;
        this.in = new ByteArrayInput();
        super.setInput(this.in);
    }

    @Override
    public void setInput(BufferedInput input) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean isSchemeKnown() {
        return this.schemeKnown;
    }

    public int getLimit() {
        return this.in.getLimit();
    }

    public int getProcessed() {
        return this.in.getPosition();
    }

    public byte[] getBuffer() {
        return this.in.getBuffer();
    }

    public void removeBytes(int n) {
        int processed = this.in.getPosition();
        int limit = this.in.getLimit();
        if (n < 0 || n > processed) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return;
        }
        if (n == limit) {
            this.in.setBuffer(null);
            this.in.setPosition(0);
            this.in.setLimit(0);
            return;
        }
        if (this.in.getBuffer() != this.pooledBuffer && limit - n < POOLED_BUFFER_SIZE >> 1) {
            byte[] pooledBuffer = this.getOrCreatePooledBuffer();
            System.arraycopy(this.in.getBuffer(), n, pooledBuffer, 0, limit - n);
            this.in.setBuffer(pooledBuffer);
        } else {
            System.arraycopy(this.in.getBuffer(), n, this.in.getBuffer(), 0, limit - n);
        }
        this.in.setPosition(processed -= n);
        this.in.setLimit(limit -= n);
    }

    public void resetBuffer() {
        this.in.setBuffer(null);
        this.in.setPosition(0);
        this.in.setLimit(0);
    }

    public void addBytes(byte[] bytes, int offset, int length) {
        if ((offset | length | offset + length | bytes.length - (offset + length)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (length <= 0) {
            return;
        }
        int limit = this.in.getLimit();
        this.ensureCapacity(limit + length);
        System.arraycopy(bytes, offset, this.in.getBuffer(), limit, length);
        this.in.setLimit(limit + length);
    }

    public void setLimit(int newLimit) {
        this.in.setLimit(newLimit);
    }

    public void ensureCapacity(int requiredCapacity) {
        if (requiredCapacity <= 0) {
            return;
        }
        if (this.in.getBuffer().length == 0 && requiredCapacity <= POOLED_BUFFER_SIZE) {
            this.in.setBuffer(this.getOrCreatePooledBuffer());
        } else {
            this.in.ensureCapacity(requiredCapacity);
        }
    }

    private byte[] getOrCreatePooledBuffer() {
        if (this.pooledBuffer == null) {
            this.pooledBuffer = new byte[POOLED_BUFFER_SIZE];
        }
        return this.pooledBuffer;
    }
}

