/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.qtp;

import com.devexperts.io.BufferedOutput;
import com.devexperts.io.ByteArrayOutput;
import com.devexperts.qd.DataScheme;
import com.devexperts.qd.qtp.BinaryQTPComposer;
import com.devexperts.qd.qtp.MessageProvider;
import com.devexperts.qd.qtp.QTPConstants;
import com.devexperts.qd.stats.QDStats;

public class ByteArrayComposer
extends BinaryQTPComposer {
    protected byte[] pooledBuffer;
    protected ByteArrayOutput out = new ByteArrayOutput(QTPConstants.COMPOSER_BUFFER_SIZE);

    public ByteArrayComposer(DataScheme scheme) {
        this(scheme, false);
    }

    public ByteArrayComposer(DataScheme scheme, boolean describeRecords) {
        super(scheme, describeRecords);
        this.pooledBuffer = this.out.getBuffer();
        super.setOutput(this.out);
    }

    @Override
    public void setOutput(BufferedOutput output) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasCapacity() {
        return (long)this.out.getPosition() + this.getMessagePayloadSize() < (long)QTPConstants.COMPOSER_THRESHOLD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compose(MessageProvider provider, QDStats stats) {
        this.setStats(stats);
        try {
            boolean bl = this.compose(provider);
            return bl;
        }
        finally {
            this.setStats(QDStats.VOID);
        }
    }

    public void removeBytes(int n) {
        this.removeBytes(0, n);
    }

    public void removeBytes(int off, int len) {
        int processed = this.out.getPosition();
        if (off < 0 || len < 0 || off + len > processed) {
            throw new IllegalArgumentException("off=" + off + ", len=" + len + ", processed=" + processed);
        }
        if (len == 0) {
            return;
        }
        int newLen = processed - len;
        if (this.out.getBuffer() != this.pooledBuffer && newLen < this.pooledBuffer.length >> 1) {
            if (newLen > 0) {
                if (off > 0) {
                    System.arraycopy(this.out.getBuffer(), 0, this.pooledBuffer, 0, off);
                }
                System.arraycopy(this.out.getBuffer(), off + len, this.pooledBuffer, off, newLen - off);
            }
            this.out.setBuffer(this.pooledBuffer);
        } else {
            System.arraycopy(this.out.getBuffer(), off + len, this.out.getBuffer(), off, newLen - off);
        }
        this.out.setPosition(newLen);
    }

    public int getProcessed() {
        return this.out.getPosition();
    }

    public byte[] getBuffer() {
        return this.out.getBuffer();
    }
}

