/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.qtp;

import com.devexperts.io.BufferedInput;
import com.devexperts.io.BufferedOutput;
import com.devexperts.io.IOUtil;
import com.devexperts.io.Marshalled;
import com.devexperts.io.Marshaller;
import com.devexperts.qd.DataField;
import com.devexperts.qd.DataIntField;
import com.devexperts.qd.DataObjField;
import com.devexperts.qd.DataRecord;
import com.devexperts.qd.SerialFieldType;
import com.devexperts.qd.kit.ByteArrayField;
import com.devexperts.qd.kit.MarshalledObjField;
import com.devexperts.qd.kit.PlainObjField;
import com.devexperts.qd.kit.StringField;
import com.devexperts.qd.ng.EventFlag;
import com.devexperts.qd.ng.RecordBuffer;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.util.Decimal;
import com.devexperts.qd.util.TimeSequenceUtil;
import com.devexperts.util.TimeUtil;
import com.devexperts.util.WideDecimal;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class BinaryRecordDesc {
    protected static final int SER_SHIFT = 22;
    protected static final int SER_MASK = 15;
    protected static final int SER_OTHER = 0;
    protected static final int SER_BYTE = 1;
    protected static final int SER_UTF_CHAR = 2;
    protected static final int SER_SHORT = 3;
    protected static final int SER_INT = 4;
    protected static final int SER_COMPACT_INT = 5;
    protected static final int SER_UTF_CHAR_ARRAY_STRING = 6;
    protected static final int SER_BYTE_ARRAY = 7;
    protected static final int SER_UTF_STRING = 8;
    protected static final int SER_MARSHALLED = 9;
    protected static final int SER_PLAIN_OBJECT = 10;
    protected static final int FLD_SHIFT = 26;
    protected static final int FLD_SKIP = 0;
    protected static final int FLD_INT = 1;
    protected static final int FLD_LONG = 2;
    protected static final int FLD_OBJ = 3;
    protected static final int FLD_DECIMAL_TO_INT = 4;
    protected static final int FLD_INT_TO_DECIMAL = 5;
    protected static final int FLD_WIDE_DECIMAL_TO_INT = 6;
    protected static final int FLD_INT_TO_WIDE_DECIMAL = 7;
    protected static final int FLD_WIDE_DECIMAL_TO_DECIMAL = 8;
    protected static final int FLD_DECIMAL_TO_WIDE_DECIMAL = 9;
    protected static final int FLD_DECIMAL_TO_SHARES = 10;
    protected static final int FLD_SHARES_TO_DECIMAL = 11;
    protected static final int FLD_WIDE_DECIMAL_TO_SHARES = 12;
    protected static final int FLD_SHARES_TO_WIDE_DECIMAL = 13;
    protected static final int FLD_EVENT_TIME = 14;
    protected static final int FLD_EVENT_SEQUENCE = 15;
    protected static final int FLD_DECIMAL_TO_LONG = 16;
    protected static final int FLD_LONG_TO_DECIMAL = 17;
    protected static final int FLD_WIDE_DECIMAL_TO_LONG = 18;
    protected static final int FLD_LONG_TO_WIDE_DECIMAL = 19;
    protected static final int FLD_TIME_MILLIS_TO_TIME_SECONDS = 20;
    protected static final int FLD_TIME_SECONDS_TO_TIME_MILLIS = 21;
    protected static final int FLD_TIME_MILLIS_TO_EVENT_TIME_SEQUENCE = 22;
    protected static final int FLD_EVENT_TIME_SEQUENCE_TO_TIME_MILLIS = 23;
    protected static final int FLAG_SHARES = -1;
    protected static final int INDEX_MASK = 0x3FFFFF;
    protected static final int DESC_VOID = 0x3FFFFF;
    protected static final int DESC_EVENT_TIME = 964689918;
    protected static final int DESC_EVENT_SEQUENCE = 1031798781;
    protected static final int DESC_CANT_CONVERT = 0x3FFFFC;
    protected static final int DIR_READ = 1;
    protected static final int DIR_WRITE = 2;
    protected final boolean empty;
    protected final DataRecord record;
    protected final String[] names;
    protected final int[] types;
    protected final int[] descs;
    protected final int nDesc;
    protected final int nDescEventFields;

    protected BinaryRecordDesc(BinaryRecordDesc desc) {
        this.empty = desc.empty;
        this.record = desc.record;
        this.names = desc.names;
        this.types = desc.types;
        this.descs = desc.descs;
        this.nDesc = desc.nDesc;
        this.nDescEventFields = desc.nDescEventFields;
    }

    protected BinaryRecordDesc(DataRecord record, boolean eventTimeSequence, int dir, boolean wideDecimalSupported) throws InvalidDescException {
        int d;
        int type;
        String name;
        DataField f;
        int i;
        if (dir != 1 && dir != 2) {
            throw new IllegalArgumentException("illegal direction");
        }
        int iFlds = record.getIntFieldCount();
        int oFlds = record.getObjFieldCount();
        int nFlds = (eventTimeSequence ? 2 : 0) + iFlds + oFlds;
        String[] names = new String[nFlds];
        int[] types = new int[nFlds];
        int[] descs = new int[nFlds];
        int nDesc = 0;
        if (eventTimeSequence) {
            names[nDesc] = "EventTime";
            types[nDesc] = SerialFieldType.TIME_SECONDS.getId();
            descs[nDesc++] = 964689918;
            names[nDesc] = "EventSequence";
            types[nDesc] = SerialFieldType.SEQUENCE.getId();
            descs[nDesc++] = 1031798781;
        }
        for (i = 0; i < iFlds; ++i) {
            f = record.getIntField(i);
            name = f.getPropertyName();
            type = f.getSerialType().getId();
            if ((type & 0xF0) == 112 && !wideDecimalSupported) {
                type = type & 0xFFFFFF0F | 0x10;
            }
            if ((d = BinaryRecordDesc.field2Desc(name, type, f, dir, record.getName().equals("Profile") && name.equals("Shares"))) == 0x3FFFFC) {
                throw new InvalidDescException(name, type);
            }
            if (d == 0x3FFFFF) continue;
            names[nDesc] = name;
            types[nDesc] = type;
            descs[nDesc] = d;
            ++nDesc;
        }
        for (i = 0; i < oFlds; ++i) {
            f = record.getObjField(i);
            name = f.getPropertyName();
            d = BinaryRecordDesc.field2Desc(name, type = f.getSerialType().getId(), f, dir, record.getName().equals("Profile") && name.equals("Shares"));
            if (d == 0x3FFFFC) {
                throw new InvalidDescException(name, type);
            }
            if (d == 0x3FFFFF) continue;
            names[nDesc] = name;
            types[nDesc] = type;
            descs[nDesc] = d;
            ++nDesc;
        }
        this.empty = false;
        this.record = record;
        this.names = names;
        this.types = types;
        this.descs = descs;
        this.nDesc = nDesc;
        this.nDescEventFields = this.countEventFields();
    }

    protected BinaryRecordDesc(DataRecord record, int nFld, String[] namesIn, int[] typesIn, boolean eventTimeSequence, int dir) throws InvalidDescException {
        String[] names = (String[])namesIn.clone();
        int[] types = (int[])typesIn.clone();
        int[] descs = new int[nFld];
        int nDesc = 0;
        int i = 0;
        if (eventTimeSequence && nFld >= 1 && names[0].equals("EventTime") && types[0] == 56) {
            ++i;
            descs[nDesc++] = 964689918;
            if (nFld >= 2 && names[1].equals("EventSequence") && types[1] == 72) {
                ++i;
                descs[nDesc++] = 1031798781;
            }
        }
        while (i < nFld) {
            boolean isShares;
            String name = names[i];
            int type = types[i];
            DataField f = record == null ? null : record.findFieldByName(name);
            int d = BinaryRecordDesc.field2Desc(name, type, f, dir, isShares = record != null && record.getName().equals("Profile") && name.equals("Shares"));
            if (d == 0x3FFFFC) {
                if (f == null) {
                    throw new InvalidDescException(name, type);
                }
                d = BinaryRecordDesc.field2Desc(name, type = type & 0xFFFFFF0F | f.getSerialType().getId() & 0xF0, f, dir, isShares);
                if (d == 0x3FFFFC) {
                    throw new InvalidDescException(name, type);
                }
            }
            if (d != 0x3FFFFF && (dir != 2 || d >> 26 != 0)) {
                names[nDesc] = name;
                types[nDesc] = type;
                descs[nDesc] = d;
                ++nDesc;
            }
            ++i;
        }
        this.empty = nFld == 0;
        this.record = record;
        this.names = names;
        this.types = types;
        this.descs = descs;
        this.nDesc = nDesc;
        this.nDescEventFields = this.countEventFields();
    }

    private int countEventFields() {
        int i;
        for (i = 0; i < this.nDesc && this.names[i].startsWith("Event"); ++i) {
        }
        return i;
    }

    public DataRecord getRecord() {
        return this.record;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public RecordCursor readRecord(BufferedInput msg, RecordBuffer buffer, int cipher, String symbol, int eventFlags) throws IOException {
        RecordCursor cur = null;
        if (this.record != null) {
            cur = buffer.add(this.record, cipher, symbol);
            cur.setEventFlags(eventFlags);
        }
        if (EventFlag.REMOVE_EVENT.in(eventFlags)) {
            this.readRemoveEventFields(msg, cur);
        } else {
            this.readFields(msg, cur, this.nDesc);
        }
        return cur;
    }

    private void readRemoveEventFields(BufferedInput msg, RecordCursor cur) throws IOException {
        this.readFields(msg, cur, this.nDescEventFields);
        long time = this.readTime(msg);
        if (cur != null) {
            cur.setTime(time);
        }
    }

    protected long readTime(BufferedInput msg) throws IOException {
        return msg.readCompactLong();
    }

    protected void readFields(BufferedInput msg, RecordCursor cur, int nDesc) throws IOException {
        block32: for (int i = 0; i < nDesc; ++i) {
            this.beforeField(msg);
            long iVal = 0L;
            Marshalled<Object> oVal = null;
            int d = this.descs[i];
            switch (d >> 22 & 0xF) {
                case 1: {
                    iVal = msg.readByte();
                    break;
                }
                case 2: {
                    iVal = msg.readUTFChar();
                    break;
                }
                case 3: {
                    iVal = msg.readShort();
                    break;
                }
                case 4: {
                    iVal = msg.readInt();
                    break;
                }
                case 5: {
                    iVal = msg.readCompactLong();
                    break;
                }
                case 6: {
                    oVal = IOUtil.readCharArrayString(msg);
                    break;
                }
                case 7: {
                    oVal = (Marshalled<Object>)msg.readByteArray();
                    break;
                }
                case 8: {
                    oVal = msg.readUTFString();
                    break;
                }
                case 9: {
                    oVal = msg.readMarshalled(Marshaller.SERIALIZATION);
                    break;
                }
                case 10: {
                    oVal = msg.readObject();
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            switch (d >>> 26) {
                case 0: {
                    continue block32;
                }
                case 1: {
                    this.setIntValue(cur, d & 0x3FFFFF, (int)iVal, msg);
                    continue block32;
                }
                case 2: {
                    this.setLongValue(cur, d & 0x3FFFFF, iVal, msg);
                    continue block32;
                }
                case 3: {
                    this.setObjValue(cur, d & 0x3FFFFF, oVal, msg);
                    continue block32;
                }
                case 4: {
                    this.setIntValue(cur, d & 0x3FFFFF, (int)Decimal.toDouble((int)iVal), msg);
                    continue block32;
                }
                case 5: 
                case 17: {
                    this.setIntValue(cur, d & 0x3FFFFF, Decimal.composeDecimal(iVal, 0), msg);
                    continue block32;
                }
                case 6: {
                    this.setIntValue(cur, d & 0x3FFFFF, (int)WideDecimal.toLong(iVal), msg);
                    continue block32;
                }
                case 7: 
                case 19: {
                    this.setLongValue(cur, d & 0x3FFFFF, WideDecimal.composeWide(iVal, 0), msg);
                    continue block32;
                }
                case 8: {
                    this.setIntValue(cur, d & 0x3FFFFF, Decimal.wideToTiny(iVal), msg);
                    continue block32;
                }
                case 9: {
                    this.setLongValue(cur, d & 0x3FFFFF, Decimal.tinyToWide((int)iVal), msg);
                    continue block32;
                }
                case 11: {
                    this.setIntValue(cur, d & 0x3FFFFF, Decimal.compose(Decimal.toDouble((int)iVal) * 1000.0), msg);
                    continue block32;
                }
                case 13: {
                    this.setLongValue(cur, d & 0x3FFFFF, WideDecimal.composeWide(Decimal.toDouble((int)iVal) * 1000.0), msg);
                    continue block32;
                }
                case 14: {
                    cur.setEventTimeSeconds((int)iVal);
                    continue block32;
                }
                case 15: {
                    cur.setEventSequence((int)iVal);
                    continue block32;
                }
                case 16: {
                    this.setLongValue(cur, d & 0x3FFFFF, (long)Decimal.toDouble((int)iVal), msg);
                    continue block32;
                }
                case 18: {
                    this.setLongValue(cur, d & 0x3FFFFF, WideDecimal.toLong(iVal), msg);
                    continue block32;
                }
                case 20: {
                    this.setIntValue(cur, d & 0x3FFFFF, TimeUtil.getSecondsFromTime(iVal), msg);
                    continue block32;
                }
                case 21: {
                    this.setLongValue(cur, d & 0x3FFFFF, iVal * 1000L, msg);
                    continue block32;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
    }

    protected void beforeField(BufferedInput msg) {
    }

    protected void setIntValue(RecordCursor cur, int index, int value, BufferedInput msg) {
        cur.setInt(index, value);
    }

    protected void setLongValue(RecordCursor cur, int index, long value, BufferedInput msg) {
        cur.setLong(index, value);
    }

    protected void setObjValue(RecordCursor cur, int index, Object value, BufferedInput msg) {
        cur.setObj(index, value);
    }

    public void writeRecord(BufferedOutput msg, RecordCursor cur, int eventFlags, long eventTimeSequence) throws IOException {
        if (EventFlag.REMOVE_EVENT.in(eventFlags)) {
            this.writeFields(msg, cur, this.nDescEventFields, eventTimeSequence);
            this.writeTime(msg, cur.getTime());
        } else {
            this.writeFields(msg, cur, this.nDesc, eventTimeSequence);
        }
    }

    private void writeTime(BufferedOutput msg, long time) throws IOException {
        msg.writeCompactLong(time);
    }

    private void writeFields(BufferedOutput msg, RecordCursor cur, int nDesc, long eventTimeSequence) throws IOException {
        block30: for (int i = 0; i < nDesc; ++i) {
            int d = this.descs[i];
            long iVal = 0L;
            Object oVal = null;
            switch (d >>> 26) {
                case 1: {
                    iVal = cur.getInt(d & 0x3FFFFF);
                    break;
                }
                case 2: {
                    iVal = cur.getLong(d & 0x3FFFFF);
                    break;
                }
                case 3: {
                    oVal = cur.getObj(d & 0x3FFFFF);
                    break;
                }
                case 4: 
                case 16: {
                    iVal = (long)Decimal.toDouble(cur.getInt(d & 0x3FFFFF));
                    break;
                }
                case 5: {
                    iVal = Decimal.composeDecimal(cur.getInt(d & 0x3FFFFF), 0);
                    break;
                }
                case 6: 
                case 18: {
                    iVal = WideDecimal.toLong(cur.getLong(d & 0x3FFFFF));
                    break;
                }
                case 7: {
                    iVal = WideDecimal.composeWide(cur.getInt(d & 0x3FFFFF), 0);
                    break;
                }
                case 8: {
                    iVal = Decimal.wideToTiny(cur.getLong(d & 0x3FFFFF));
                    break;
                }
                case 9: {
                    iVal = Decimal.tinyToWide(cur.getInt(d & 0x3FFFFF));
                    break;
                }
                case 10: {
                    iVal = Decimal.compose(Decimal.toDouble(cur.getInt(d & 0x3FFFFF)) / 1000.0);
                    break;
                }
                case 12: {
                    iVal = Decimal.compose(WideDecimal.toDouble(cur.getLong(d & 0x3FFFFF)) / 1000.0);
                    break;
                }
                case 14: {
                    iVal = TimeSequenceUtil.getTimeSecondsFromTimeSequence(eventTimeSequence);
                    break;
                }
                case 15: {
                    iVal = TimeSequenceUtil.getSequenceFromTimeSequence(eventTimeSequence);
                    break;
                }
                case 17: {
                    iVal = Decimal.composeDecimal(cur.getLong(d & 0x3FFFFF), 0);
                    break;
                }
                case 19: {
                    iVal = WideDecimal.composeWide(cur.getLong(d & 0x3FFFFF), 0);
                    break;
                }
                case 20: {
                    iVal = TimeUtil.getSecondsFromTime(cur.getLong(d & 0x3FFFFF));
                    break;
                }
                case 21: {
                    iVal = (long)cur.getInt(d & 0x3FFFFF) * 1000L;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            switch (d >> 22 & 0xF) {
                case 1: {
                    msg.writeByte((int)iVal);
                    continue block30;
                }
                case 2: {
                    msg.writeUTFChar((int)iVal);
                    continue block30;
                }
                case 3: {
                    msg.writeShort((int)iVal);
                    continue block30;
                }
                case 4: {
                    msg.writeInt((int)iVal);
                    continue block30;
                }
                case 5: {
                    msg.writeCompactLong(iVal);
                    continue block30;
                }
                case 6: {
                    if (oVal == null || oVal instanceof String) {
                        IOUtil.writeCharArray((DataOutput)msg, (String)oVal);
                        continue block30;
                    }
                    if (oVal instanceof char[]) {
                        IOUtil.writeCharArray((DataOutput)msg, (char[])oVal);
                        continue block30;
                    }
                    if (oVal instanceof byte[]) {
                        IOUtil.writeCharArray((DataOutput)msg, new String((byte[])oVal, StandardCharsets.UTF_8));
                        continue block30;
                    }
                    IOUtil.writeCharArray((DataOutput)msg, oVal.toString());
                    continue block30;
                }
                case 7: {
                    if (oVal == null || oVal instanceof byte[]) {
                        msg.writeByteArray((byte[])oVal);
                        continue block30;
                    }
                    if (oVal instanceof String) {
                        msg.writeUTFString((String)oVal);
                        continue block30;
                    }
                    if (oVal instanceof char[]) {
                        msg.writeUTFString(new String((char[])oVal));
                        continue block30;
                    }
                    msg.writeObject(oVal);
                    continue block30;
                }
                case 8: {
                    if (oVal == null || oVal instanceof String) {
                        msg.writeUTFString((String)oVal);
                        continue block30;
                    }
                    if (oVal instanceof char[]) {
                        msg.writeUTFString(new String((char[])oVal));
                        continue block30;
                    }
                    if (oVal instanceof byte[]) {
                        msg.writeByteArray((byte[])oVal);
                        continue block30;
                    }
                    msg.writeUTFString(oVal.toString());
                    continue block30;
                }
                case 9: 
                case 10: {
                    msg.writeObject(oVal);
                    continue block30;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
    }

    private static int field2Desc(String name, int type, DataField f, int dir, boolean isShares) throws InvalidDescException {
        int fld;
        int ser;
        switch (type & 0xFFFFFF0F) {
            case 0: {
                return 0x3FFFFF;
            }
            case 1: {
                ser = 1;
                break;
            }
            case 2: {
                ser = 2;
                break;
            }
            case 3: {
                ser = 3;
                break;
            }
            case 4: {
                ser = 4;
                break;
            }
            case 8: {
                ser = 5;
                break;
            }
            case 9: {
                if (f instanceof ByteArrayField) {
                    ser = 7;
                    break;
                }
                if (f instanceof StringField) {
                    ser = 8;
                    break;
                }
                if (f instanceof PlainObjField) {
                    ser = 10;
                    break;
                }
                if (f instanceof MarshalledObjField) {
                    ser = 9;
                    break;
                }
                return 0x1FFFFFF;
            }
            case 10: {
                ser = 6;
                break;
            }
            default: {
                throw new InvalidDescException(name, type);
            }
        }
        if (f instanceof DataIntField) {
            int wire = type & 0xF0;
            if (wire == 16 && isShares) {
                wire = -1;
            }
            if ((fld = dir == 1 ? BinaryRecordDesc.getIntConverterType(wire, f.getSerialType().getId() & 0xF0) : BinaryRecordDesc.getIntConverterType(f.getSerialType().getId() & 0xF0, wire)) == 0) {
                return 0x3FFFFC;
            }
            if (fld == 1 && f.getSerialType().isLong()) {
                fld = 2;
            }
        } else if (f instanceof DataObjField) {
            fld = 3;
        } else {
            return ser << 22 | 0 | 0x3FFFFF;
        }
        return ser << 22 | fld << 26 | f.getIndex();
    }

    private static int getIntConverterType(int from, int to) {
        if (from == to) {
            return 1;
        }
        if (from == 16 && to == 0) {
            return 4;
        }
        if (from == 0 && to == 16) {
            return 5;
        }
        if (from == 112 && to == 0) {
            return 6;
        }
        if (from == 0 && to == 112) {
            return 7;
        }
        if (from == 112 && to == 16) {
            return 8;
        }
        if (from == 16 && to == 112) {
            return 9;
        }
        if (from == 16 && to == -1) {
            return 10;
        }
        if (from == -1 && to == 16) {
            return 11;
        }
        if (from == 112 && to == -1) {
            return 12;
        }
        if (from == -1 && to == 112) {
            return 13;
        }
        if (from == 16 && to == 96) {
            return 16;
        }
        if (from == 96 && to == 16) {
            return 17;
        }
        if (from == 112 && to == 96) {
            return 18;
        }
        if (from == 96 && to == 112) {
            return 19;
        }
        if (from == 144 && to == 48) {
            return 20;
        }
        if (from == 48 && to == 144) {
            return 21;
        }
        return 0;
    }

    static class InvalidDescException
    extends Exception {
        InvalidDescException(String name, int type) {
            super("Unsupported type 0x" + Integer.toHexString(type) + " for field '" + name + "'");
        }
    }
}

