/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.qtp;

import com.devexperts.io.BufferedOutput;
import com.devexperts.io.ByteArrayOutput;
import com.devexperts.io.Chunk;
import com.devexperts.io.ChunkList;
import com.devexperts.io.IOUtil;
import com.devexperts.qd.DataField;
import com.devexperts.qd.DataIntField;
import com.devexperts.qd.DataObjField;
import com.devexperts.qd.DataRecord;
import com.devexperts.qd.DataScheme;
import com.devexperts.qd.SymbolCodec;
import com.devexperts.qd.ng.EventFlag;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.qtp.AbstractQTPComposer;
import com.devexperts.qd.qtp.BinaryRecordDesc;
import com.devexperts.qd.qtp.HeartbeatPayload;
import com.devexperts.qd.qtp.MessageType;
import com.devexperts.qd.qtp.ProtocolDescriptor;
import java.io.IOException;

public class BinaryQTPComposer
extends AbstractQTPComposer {
    private static final int MAX_MESSAGE_LENGTH = Integer.MAX_VALUE;
    private static final int MAX_MESSAGE_LENGTH_LENGTH = IOUtil.getCompactLength(Integer.MAX_VALUE);
    private final SymbolCodec.Writer symbolWriter;
    private final ByteArrayOutput aux = new ByteArrayOutput();
    private BinaryRecordDesc[] recordMap;
    private long messageBodyStartPosition;
    private int currentSupportedFlags;

    public BinaryQTPComposer(DataScheme scheme, boolean describeRecords) {
        super(scheme, describeRecords);
        this.symbolWriter = scheme.getCodec().createWriter();
    }

    @Override
    protected void writeDescribeProtocolMessage(BufferedOutput out, ProtocolDescriptor descriptor) throws IOException {
        this.beginMessage(MessageType.DESCRIBE_PROTOCOL);
        descriptor.composeTo(this.msg);
        this.endMessage();
    }

    @Override
    protected void writeEmptyHeartbeatMessage(BufferedOutput out) throws IOException {
        out.writeByte(0);
    }

    @Override
    protected void writeHeartbeatMessage(BufferedOutput out, HeartbeatPayload heartbeatPayload) throws IOException {
        this.beginMessage(MessageType.HEARTBEAT);
        heartbeatPayload.composeTo(this.msg);
        this.endMessage();
    }

    @Override
    protected int writeRecordHeader(DataRecord record, int cipher, String symbol, int eventFlags) throws IOException {
        this.symbolWriter.writeSymbol(this.msg, cipher, symbol, eventFlags &= this.currentSupportedFlags);
        this.msg.writeCompactInt(record.getId());
        return eventFlags;
    }

    @Override
    protected void writeRecordPayload(RecordCursor cursor, int eventFlags) throws IOException {
        if (this.currentMessageType.isData()) {
            this.getRecordDesc(cursor.getRecord()).writeRecord(this.msg, cursor, eventFlags, this.getEventTimeSequence(cursor));
        } else if (this.currentMessageType.isHistorySubscriptionAdd()) {
            this.writeHistorySubscriptionTime(cursor.getRecord(), cursor.getTime());
        }
    }

    @Override
    protected void writeHistorySubscriptionTime(DataRecord record, long time) throws IOException {
        this.msg.writeCompactLong(time);
    }

    @Override
    protected void writeEventTimeSequence(long eventTimeSequence) throws IOException {
        throw new UnsupportedOperationException("Legacy field-by-field writing is not supported, use 'append'");
    }

    @Override
    protected void writeIntField(DataIntField field, int value) throws IOException {
        throw new UnsupportedOperationException("Legacy field-by-field writing is not supported, use 'append'");
    }

    @Override
    protected void writeObjField(DataObjField field, Object value) throws IOException {
        throw new UnsupportedOperationException("Legacy field-by-field writing is not supported, use 'append'");
    }

    @Override
    protected void writeField(DataField field, RecordCursor cursor) throws IOException {
        throw new UnsupportedOperationException("Legacy field-by-field writing is not supported, use 'append'");
    }

    @Override
    protected void writeOtherMessageBody(byte[] messageBytes, int offset, int length) throws IOException {
        this.msg.write(messageBytes, offset, length);
    }

    @Override
    protected void writeMessageHeader(MessageType messageType) throws IOException {
        this.symbolWriter.reset(this.optSet);
        this.currentSupportedFlags = EventFlag.getSupportedEventFlags(this.optSet, this.currentMessageType);
        this.msg.writeCompactInt(Integer.MAX_VALUE);
        this.messageBodyStartPosition = this.msg.totalPosition();
        this.msg.writeCompactInt(messageType.getId());
    }

    @Override
    protected void finishComposingMessage(BufferedOutput out) throws IOException {
        long messageBodyLength = this.msg.totalPosition() - this.messageBodyStartPosition;
        ChunkList chunks = this.msg.getOutput(this);
        Chunk chunk0 = chunks.get(0);
        int shift = MAX_MESSAGE_LENGTH_LENGTH - IOUtil.getCompactLength(messageBodyLength);
        this.aux.setBuffer(chunk0.getBytes());
        this.aux.setPosition(chunk0.getOffset() + shift);
        this.aux.writeCompactLong(messageBodyLength);
        this.aux.setBuffer(null);
        chunks.setChunkRange(0, chunk0.getOffset() + shift, chunk0.getLength() - shift, this);
        out.writeAllFromChunkList(chunks, this);
    }

    protected BinaryRecordDesc getRequestedRecordDesc(DataRecord record) {
        return null;
    }

    protected boolean isWideDecimalSupported() {
        return true;
    }

    private void remapRecord(int id, BinaryRecordDesc rw) {
        if (this.recordMap == null || id >= this.recordMap.length) {
            int len = this.recordMap == null ? 0 : this.recordMap.length;
            int newLen = Math.max(Math.max(10, id + 1), len * 3 / 2);
            BinaryRecordDesc[] newRecordMap = new BinaryRecordDesc[newLen];
            if (this.recordMap != null) {
                System.arraycopy(this.recordMap, 0, newRecordMap, 0, len);
            }
            this.recordMap = newRecordMap;
        }
        this.recordMap[id] = rw;
    }

    private BinaryRecordDesc getRecordDesc(DataRecord record) throws IOException {
        int id = record.getId();
        if (this.recordMap != null && id >= 0 && id < this.recordMap.length && this.recordMap[id] != null) {
            return this.recordMap[id];
        }
        BinaryRecordDesc desc = this.getRequestedRecordDesc(record);
        try {
            BinaryRecordDesc rw = desc != null && !desc.isEmpty() ? new BinaryRecordDesc(record, desc.nDesc, desc.names, desc.types, this.writeEventTimeSequence, 2) : new BinaryRecordDesc(record, this.writeEventTimeSequence, 2, this.isWideDecimalSupported());
            this.remapRecord(id, rw);
            return rw;
        }
        catch (BinaryRecordDesc.InvalidDescException e) {
            throw new IOException("Cannot write record '" + record.getName() + "': " + e.getMessage(), e);
        }
    }

    @Override
    protected void describeRecord(DataRecord record) throws IOException {
        MessageType lastMessageType = this.currentMessageType;
        this.endMessage();
        this.beginMessage(MessageType.DESCRIBE_RECORDS);
        BinaryRecordDesc rw = this.getRecordDesc(record);
        this.msg.writeCompactInt(record.getId());
        this.msg.writeUTFString(record.getName());
        this.msg.writeCompactInt(rw.nDesc);
        for (int i = 0; i < rw.nDesc; ++i) {
            this.msg.writeUTFString(rw.names[i]);
            this.msg.writeCompactInt(rw.types[i]);
        }
        this.endMessage();
        this.beginMessage(lastMessageType);
    }
}

