/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.qtp;

import com.devexperts.auth.AuthSession;
import com.devexperts.auth.AuthToken;
import com.devexperts.auth.SessionCloseListener;
import com.devexperts.connector.proto.TransportConnection;
import com.devexperts.qd.QDLog;
import com.devexperts.qd.qtp.MessageAdapter;
import com.devexperts.qd.qtp.MessageType;
import com.devexperts.qd.qtp.auth.QDAuthRealm;
import com.devexperts.util.SystemProperties;
import com.devexperts.util.TimePeriod;
import com.devexperts.util.TypedMap;
import com.dxfeed.promise.Promise;
import com.dxfeed.promise.PromiseHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.GuardedBy;

class AuthManager
implements PromiseHandler<AuthSession> {
    private static final long AUTHENTICATE_TIMEOUT = TimePeriod.valueOf(SystemProperties.getProperty(AuthManager.class, "authenticateTimeout", "5m")).getTime();
    private final MessageAdapter messageAdapter;
    private final QDAuthRealm realm;
    private AuthSession session;
    private String reason;
    private AuthState state = AuthState.NEW;
    private boolean firstAuthProtocolWasSent = false;
    private boolean authenticatePreparing;
    private TypedMap connectionVariables;
    private SessionCloseListener listener;
    private long startTime;
    @GuardedBy(value="this")
    private List<Promise<AuthSession>> promises = new ArrayList<Promise<AuthSession>>();

    AuthManager(MessageAdapter messageAdapter, QDAuthRealm realm) {
        this.messageAdapter = messageAdapter;
        this.realm = realm;
        this.reason = "LOGIN " + realm.getAuthenticationInfo();
        this.startTime = System.currentTimeMillis();
    }

    long getAuthDisconnectTime() {
        return this.authIsOk() ? Long.MAX_VALUE : this.startTime + AUTHENTICATE_TIMEOUT;
    }

    void authenticate(AuthToken authToken, TypedMap connectionVariables) {
        this.authenticateSync(connectionVariables);
        Promise<AuthSession> authSession = this.realm.authenticate(authToken, connectionVariables);
        authSession.whenDone(this);
        this.syncAddPromise(authSession);
    }

    private synchronized void authenticateSync(TypedMap connectionVariables) {
        this.connectionVariables = connectionVariables;
        this.state = this.state == AuthState.AUTH_PREPARING ? AuthState.AUTHENTICATE_AND_AUTH_PREPARING : AuthState.AUTHENTICATE;
    }

    synchronized String getReason() {
        String temp = this.reason;
        this.reason = null;
        return temp;
    }

    synchronized boolean authenticatePreparing() {
        return this.authenticatePreparing;
    }

    synchronized boolean firstAuthProtocolWasSent() {
        return this.firstAuthProtocolWasSent;
    }

    void updateState(boolean beforePreparing) {
        if (this.updateSync(beforePreparing)) {
            this.messageAdapter.addMask(MessageAdapter.getMessageMask(MessageType.DESCRIBE_PROTOCOL));
        }
    }

    private synchronized boolean updateSync(boolean beforePreparing) {
        if (beforePreparing) {
            this.updateBefore();
            return false;
        }
        return this.updateAfter();
    }

    private synchronized boolean authIsOk() {
        return this.state == AuthState.AUTH_OK || this.state == AuthState.DATA_PREPARING || this.state == AuthState.COMPLETED;
    }

    @Override
    public void promiseDone(Promise<? extends AuthSession> promise) {
        if (promise.hasResult()) {
            QDLog.log.warn(this.messageAdapter + " authentication success");
            this.messageAdapter.reinitConfiguration(promise.getResult());
            boolean addMask = this.successSync(promise.getResult());
            if (addMask) {
                this.messageAdapter.addMask(MessageAdapter.getMessageMask(MessageType.DESCRIBE_PROTOCOL));
            }
        } else if (promise.hasException() && !promise.isCancelled()) {
            if (this.failSync(promise.getException().getMessage())) {
                this.messageAdapter.addMask(MessageAdapter.getMessageMask(MessageType.DESCRIBE_PROTOCOL));
            }
            QDLog.log.warn(this.messageAdapter + " authentication FAIL: " + this.reason);
        }
        this.syncRemovePromise(promise);
    }

    private synchronized boolean successSync(AuthSession session) {
        if (this.session != null) {
            return false;
        }
        this.session = Objects.requireNonNull(session, "null auth session");
        this.connectionVariables.set(TransportConnection.SUBJECT_KEY, session.getSubject());
        boolean addMask = this.state == AuthState.AUTHENTICATE_AND_AUTH_PREPARING || this.state == AuthState.AUTHENTICATE && this.firstAuthProtocolWasSent;
        this.state = AuthState.AUTH_OK;
        this.listener = (session1, closeReason) -> this.messageAdapter.close();
        session.addCloseListener(this.listener);
        return addMask;
    }

    private synchronized boolean failSync(String reason) {
        boolean addMask = this.state == AuthState.AUTHENTICATE && this.firstAuthProtocolWasSent || this.state == AuthState.AUTHENTICATE_AND_AUTH_PREPARING && this.reason == null;
        this.state = AuthState.AUTH_FAILED;
        this.reason = reason;
        return addMask;
    }

    void close() {
        List<Promise<AuthSession>> promises = this.syncClose();
        if (promises != null) {
            promises.forEach(Promise::cancel);
        }
    }

    private synchronized List<Promise<AuthSession>> syncClose() {
        if (this.session != null) {
            this.session.removeCloseListener(this.listener);
            this.session.close("Connection close");
        }
        List<Promise<AuthSession>> promises = this.promises;
        this.promises = null;
        return promises;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncAddPromise(Promise<AuthSession> promise) {
        boolean added;
        AuthManager authManager = this;
        synchronized (authManager) {
            added = this.promises != null;
            if (added) {
                this.promises.add(promise);
            }
        }
        if (!added) {
            promise.cancel();
        }
    }

    private synchronized void syncRemovePromise(Promise<? extends AuthSession> promise) {
        if (this.promises != null) {
            this.promises.remove(promise);
        }
    }

    private void updateBefore() {
        switch (this.state) {
            case NEW: {
                this.state = AuthState.AUTH_PREPARING;
                this.firstAuthProtocolWasSent = true;
                this.authenticatePreparing = true;
                break;
            }
            case AUTH_FAILED: {
                this.state = AuthState.AUTH_PREPARING;
                this.authenticatePreparing = true;
                break;
            }
            case AUTH_OK: {
                this.state = AuthState.DATA_PREPARING;
                break;
            }
            case AUTHENTICATE: {
                this.state = AuthState.AUTHENTICATE_AND_AUTH_PREPARING;
                this.firstAuthProtocolWasSent = true;
                this.authenticatePreparing = true;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    private boolean updateAfter() {
        this.authenticatePreparing = false;
        switch (this.state) {
            case AUTH_PREPARING: {
                this.state = AuthState.WAITING_OTHER_SIDE;
                break;
            }
            case AUTHENTICATE_AND_AUTH_PREPARING: {
                this.state = AuthState.AUTHENTICATE;
                break;
            }
            case AUTH_OK: {
                return true;
            }
            case AUTH_FAILED: {
                break;
            }
            case DATA_PREPARING: {
                this.state = AuthState.COMPLETED;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return false;
    }

    private static enum AuthState {
        NEW,
        AUTH_PREPARING,
        AUTH_FAILED,
        AUTH_OK,
        DATA_PREPARING,
        WAITING_OTHER_SIDE,
        AUTHENTICATE,
        AUTHENTICATE_AND_AUTH_PREPARING,
        COMPLETED;

    }
}

