/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.qtp;

import com.devexperts.qd.QDCollector;
import com.devexperts.qd.QDFilter;
import com.devexperts.qd.kit.CompositeFilters;
import com.devexperts.qd.qtp.AgentAdapter;
import com.devexperts.qd.qtp.ChannelDescription;
import com.devexperts.qd.qtp.ChannelShaper;
import com.devexperts.qd.qtp.DynamicChannelShaper;
import com.devexperts.qd.qtp.auth.BasicAuthRealmFactory;
import com.devexperts.qd.util.QDConfig;
import com.devexperts.util.InvalidFormatException;
import com.devexperts.util.TimePeriod;
import java.util.ArrayList;
import java.util.List;

public class AgentAdapterChannels {
    private final ChannelDescription[] channels;
    private final List<DynamicChannelShaper> shapers = new ArrayList<DynamicChannelShaper>();

    public AgentAdapterChannels(ChannelDescription[] channels, AgentAdapter adapter) throws InvalidFormatException {
        this(channels, adapter.getAgentFactory());
    }

    public AgentAdapterChannels(ChannelDescription[] channels, AgentAdapter.Factory factory) throws InvalidFormatException {
        this.channels = channels;
        QDFilter factoryFilter = factory.getFilter();
        TimePeriod factoryAggregationPeriod = factory.getAggregationPeriod();
        if (channels.length != 0) {
            for (ChannelDescription channel : channels) {
                TimePeriod aggregationPeriod = channel.aggregationPeriod == null ? factoryAggregationPeriod : channel.aggregationPeriod;
                QDFilter filter = channel.filterStr == null ? factoryFilter : CompositeFilters.makeAnd(factoryFilter, CompositeFilters.valueOf(channel.filterStr, factory.getScheme()));
                boolean found = false;
                for (QDCollector collector : factory.getCollectors()) {
                    if (collector == null || collector.getContract() != channel.contract) continue;
                    DynamicChannelShaper shaper = new DynamicChannelShaper(channel.contract, factory.getOrCreateSubscriptionExecutor(), filter);
                    shaper.setCollector(collector);
                    shaper.setAggregationPeriod(aggregationPeriod.getTime());
                    QDConfig.setProperties(shaper, channel.properties);
                    this.shapers.add(shaper);
                    found = true;
                    break;
                }
                if (found) continue;
                throw new InvalidFormatException("Missing contract: " + channel.contract);
            }
        } else {
            for (QDCollector collector : factory.getCollectors()) {
                if (collector == null) continue;
                DynamicChannelShaper shaper = new DynamicChannelShaper(collector.getContract(), factory.getOrCreateSubscriptionExecutor(), factoryFilter);
                shaper.setCollector(collector);
                shaper.setAggregationPeriod(factoryAggregationPeriod.getTime());
                this.shapers.add(shaper);
            }
        }
    }

    AgentAdapterChannels(String channels, AgentAdapter.Factory factory) {
        this(BasicAuthRealmFactory.parseAgentChannelDescription(channels).toArray(new ChannelDescription[0]), factory);
    }

    public ChannelShaper[] getNewShapers() {
        ChannelShaper[] result = this.shapers.toArray(new DynamicChannelShaper[this.shapers.size()]);
        for (int i = 0; i < result.length; ++i) {
            ((DynamicChannelShaper)result[i]).updateFilter();
            result[i] = ((DynamicChannelShaper)result[i]).clone();
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (ChannelDescription channel : this.channels) {
            sb.append('(').append(channel).append(')');
        }
        return sb.toString();
    }
}

