/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.qtp;

import com.devexperts.io.BufferedInput;
import com.devexperts.qd.DataScheme;
import com.devexperts.qd.ng.RecordBuffer;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.ng.RecordMode;
import com.devexperts.qd.qtp.FieldReplacer;
import com.devexperts.qd.qtp.MessageConsumer;
import com.devexperts.qd.qtp.MessageType;
import com.devexperts.qd.qtp.ProtocolDescriptor;
import com.devexperts.qd.qtp.RawDataConsumer;
import com.devexperts.qd.qtp.RuntimeQTPException;
import com.devexperts.qd.stats.QDStats;
import java.io.IOException;
import java.util.List;

public abstract class AbstractQTPParser {
    private static final int N_PENDING = 3;
    protected final DataScheme scheme;
    protected QDStats stats = QDStats.VOID;
    protected boolean readEventTimeSequence;
    protected boolean mixedSubscription;
    protected long eventTimeSequence;
    protected List<FieldReplacer> fieldReplacers;
    private BufferedInput input;
    private final RecordBuffer[] pendingRecordBuffers = new RecordBuffer[3];
    private final MessageType[] pendingMessageTypes = new MessageType[3];
    private int pendingMessageMask;
    private MessageType readAs;

    protected AbstractQTPParser(DataScheme scheme) {
        this.scheme = scheme;
    }

    public void setInput(BufferedInput input) {
        this.input = input;
    }

    public void setStats(QDStats stats) {
        this.stats = stats;
    }

    public void readAs(MessageType readAs) {
        if (readAs != null && !readAs.hasRecords()) {
            throw new IllegalArgumentException("Invalid readAs=" + (Object)((Object)readAs));
        }
        this.readAs = readAs;
    }

    public void setReadEventTimeSequence(boolean readEventTimeSequence) {
        this.readEventTimeSequence = readEventTimeSequence;
    }

    public void setMixedSubscription(boolean mixedSubscription) {
        this.mixedSubscription = mixedSubscription;
    }

    public void setEventTimeSequence(long eventTimeSequence) {
        this.eventTimeSequence = eventTimeSequence;
    }

    public void setFieldReplacers(List<FieldReplacer> fieldReplacers) {
        this.fieldReplacers = fieldReplacers;
    }

    public void resetSession() {
    }

    public final void parse(MessageConsumer consumer) {
        try {
            this.parseImpl(this.input, consumer);
        }
        catch (IOException e) {
            throw new RuntimeQTPException(e);
        }
        finally {
            this.processPending(consumer);
        }
    }

    protected abstract void parseImpl(BufferedInput var1, MessageConsumer var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processPending(MessageConsumer consumer) {
        MessageType pendingMessageType;
        Throwable throwable = null;
        for (int i = 0; i < 3 && (pendingMessageType = this.pendingMessageTypes[i]) != null; ++i) {
            try {
                RecordBuffer buf = this.pendingRecordBuffers[i];
                if (!buf.isEmpty()) {
                    this.processRecordsMessage(buf, consumer, pendingMessageType);
                }
                buf.release();
                continue;
            }
            catch (Throwable t) {
                if (throwable != null) continue;
                throwable = t;
                continue;
            }
            finally {
                this.pendingRecordBuffers[i] = null;
                this.pendingMessageTypes[i] = null;
                this.pendingMessageMask &= ~(1 << pendingMessageType.ordinal());
            }
        }
        if (throwable != null) {
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new RuntimeException(throwable);
        }
    }

    protected RecordBuffer nextRecordsMessage(MessageConsumer consumer, MessageType messageType) {
        assert (messageType.hasRecords());
        if (this.readAs != null) {
            messageType = this.readAs;
        } else if (messageType.isSubscriptionRemove() && this.mixedSubscription) {
            messageType = MessageType.forAddSubscription(messageType.getContract());
        }
        if ((this.pendingMessageMask & messageType.cannotReorderWithMask) != 0 || (this.pendingMessageMask & 1 << messageType.ordinal()) == 0 && this.pendingMessageTypes[2] != null) {
            this.processPending(consumer);
        }
        for (int i = 0; i < 3; ++i) {
            MessageType pendingMessageType = this.pendingMessageTypes[i];
            if (pendingMessageType == null) {
                RecordBuffer buf;
                this.pendingRecordBuffers[i] = buf = RecordBuffer.getInstance(this.getRecordBufferMode(messageType));
                this.pendingMessageTypes[i] = messageType;
                this.pendingMessageMask |= 1 << messageType.ordinal();
                return buf;
            }
            if (pendingMessageType != messageType) continue;
            return this.pendingRecordBuffers[i];
        }
        throw new AssertionError((Object)("Cannot find space for " + (Object)((Object)messageType) + ". nextMessage was not called?"));
    }

    protected RecordMode getRecordBufferMode(MessageType messageType) {
        RecordMode mode = messageType.getRecordMode();
        if (messageType.isData()) {
            return this.readEventTimeSequence ? mode.withEventTimeSequence() : mode;
        }
        if (messageType.isSubscription()) {
            return this.mixedSubscription ? mode.withEventFlags() : mode;
        }
        throw new IllegalArgumentException(messageType.toString());
    }

    private void processRecordsMessage(RecordBuffer buf, MessageConsumer consumer, MessageType messageType) {
        messageType = this.readAs != null && messageType.hasRecords() ? this.readAs : messageType;
        switch (messageType) {
            case RAW_DATA: {
                if (consumer instanceof RawDataConsumer) {
                    ((RawDataConsumer)((Object)consumer)).processData(buf, MessageType.RAW_DATA);
                    break;
                }
                consumer.processTickerData(buf);
                buf.rewind();
                consumer.processStreamData(buf);
                buf.rewind();
                consumer.processHistoryData(buf);
                break;
            }
            case TICKER_DATA: {
                consumer.processTickerData(buf);
                break;
            }
            case STREAM_DATA: {
                consumer.processStreamData(buf);
                break;
            }
            case HISTORY_DATA: {
                consumer.processHistoryData(buf);
                break;
            }
            case TICKER_ADD_SUBSCRIPTION: {
                consumer.processTickerAddSubscription(buf);
                break;
            }
            case TICKER_REMOVE_SUBSCRIPTION: {
                consumer.processTickerRemoveSubscription(buf);
                break;
            }
            case STREAM_ADD_SUBSCRIPTION: {
                consumer.processStreamAddSubscription(buf);
                break;
            }
            case STREAM_REMOVE_SUBSCRIPTION: {
                consumer.processStreamRemoveSubscription(buf);
                break;
            }
            case HISTORY_ADD_SUBSCRIPTION: {
                consumer.processHistoryAddSubscription(buf);
                break;
            }
            case HISTORY_REMOVE_SUBSCRIPTION: {
                consumer.processHistoryRemoveSubscription(buf);
            }
        }
    }

    protected ProtocolDescriptor applyReadAs(ProtocolDescriptor protocolDescriptor) {
        return this.readAs == null ? protocolDescriptor : ProtocolDescriptor.newPeerProtocolDescriptorReadAs(protocolDescriptor, this.readAs);
    }

    protected final void setEventTimeSequenceIfNeeded(RecordCursor cur) {
        if (this.readEventTimeSequence && this.eventTimeSequence != 0L) {
            cur.setEventTimeSequence(this.eventTimeSequence);
        }
    }
}

