/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.qtp;

import com.devexperts.io.BufferedOutput;
import com.devexperts.io.ChunkList;
import com.devexperts.io.ChunkedOutput;
import com.devexperts.qd.DataField;
import com.devexperts.qd.DataIntField;
import com.devexperts.qd.DataObjField;
import com.devexperts.qd.DataProvider;
import com.devexperts.qd.DataRecord;
import com.devexperts.qd.DataScheme;
import com.devexperts.qd.DataVisitor;
import com.devexperts.qd.SubscriptionProvider;
import com.devexperts.qd.SubscriptionVisitor;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.ng.RecordSink;
import com.devexperts.qd.qtp.AbstractMessageVisitor;
import com.devexperts.qd.qtp.HeartbeatPayload;
import com.devexperts.qd.qtp.MessageProvider;
import com.devexperts.qd.qtp.MessageType;
import com.devexperts.qd.qtp.ProtocolDescriptor;
import com.devexperts.qd.qtp.ProtocolOption;
import com.devexperts.qd.qtp.QTPConstants;
import com.devexperts.qd.qtp.RuntimeQTPException;
import com.devexperts.qd.stats.QDStats;
import com.devexperts.qd.util.TimeSequenceUtil;
import java.io.IOException;
import java.util.Arrays;

public abstract class AbstractQTPComposer
extends AbstractMessageVisitor
implements DataVisitor,
SubscriptionVisitor,
RecordSink {
    private static final byte RECORD_STATE_NEW = 0;
    private static final byte RECORD_STATE_DESCRIBED = 1;
    protected final DataScheme scheme;
    protected QDStats stats = QDStats.VOID;
    protected MessageType currentMessageType;
    protected boolean writeEventTimeSequence;
    protected boolean writeHeartbeat;
    protected ProtocolOption.Set optSet = ProtocolOption.EMPTY_SET;
    protected final ChunkedOutput msg = new ChunkedOutput();
    private final byte[] recordState;
    private BufferedOutput output;
    private long messagePayloadStartPosition;
    private int lastRecordId = -1;
    private long lastRecordPosition;
    private long lastPayloadTimeSequence;
    private boolean inMessage;

    protected AbstractQTPComposer(DataScheme scheme, boolean describeRecords) {
        this.scheme = scheme;
        this.recordState = (byte[])(describeRecords ? new byte[scheme.getRecordCount()] : null);
    }

    public void setOutput(BufferedOutput output) {
        this.output = output;
    }

    public void setStats(QDStats stats) {
        if (stats == null) {
            throw new NullPointerException();
        }
        this.stats = stats;
    }

    public void setWriteEventTimeSequence(boolean writeEventTimeSequence) {
        this.writeEventTimeSequence = writeEventTimeSequence;
    }

    public void setWriteHeartbeat(boolean writeHeartbeat) {
        this.writeHeartbeat = writeHeartbeat;
    }

    public void setOptSet(ProtocolOption.Set optSet) {
        this.optSet = optSet;
    }

    public void resetSession() {
        if (this.recordState == null) {
            throw new UnsupportedOperationException("describe records mode was not set");
        }
        Arrays.fill(this.recordState, (byte)0);
        if (this.inMessage) {
            this.inMessage = false;
            this.undoWriteMessageHeaderStateChange();
            this.msg.clear();
        }
    }

    public final boolean compose(MessageProvider provider) {
        try {
            long composeStartPosition = this.output.totalPosition();
            boolean result = provider.retrieveMessages(this);
            this.stats.updateIOWriteBytes(this.output.totalPosition() - composeStartPosition);
            return result;
        }
        catch (Throwable t) {
            this.abortMessageAndRethrow(t);
            return false;
        }
    }

    public final void composeDescribeProtocol(ProtocolDescriptor descriptor) {
        try {
            long composeStartPosition = this.output.totalPosition();
            this.writeDescribeProtocolMessage(this.output, descriptor);
            this.stats.updateIOWriteBytes(this.output.totalPosition() - composeStartPosition);
        }
        catch (Throwable t) {
            this.abortMessageAndRethrow(t);
        }
    }

    public final void composeEmptyHeartbeat() {
        try {
            long composeStartPosition = this.output.totalPosition();
            this.writeEmptyHeartbeatMessage(this.output);
            this.stats.updateIOWriteBytes(this.output.totalPosition() - composeStartPosition);
        }
        catch (Throwable t) {
            this.abortMessageAndRethrow(t);
        }
    }

    public final void composeHeartbeatMessage(HeartbeatPayload heartbeatPayload) {
        try {
            long composeStartPosition = this.output.totalPosition();
            this.writeHeartbeatMessage(this.output, heartbeatPayload);
            this.stats.updateIOWriteBytes(this.output.totalPosition() - composeStartPosition);
        }
        catch (Throwable t) {
            this.abortMessageAndRethrow(t);
        }
    }

    public final void composeTimeProgressReport(long timeMillis) {
        HeartbeatPayload heartbeatPayload = new HeartbeatPayload();
        heartbeatPayload.setTimeMillis(timeMillis);
        this.composeHeartbeatMessage(heartbeatPayload);
    }

    @Override
    public boolean hasCapacity() {
        return !this.inMessage || this.msg.totalPosition() < this.messagePayloadStartPosition + (long)QTPConstants.COMPOSER_THRESHOLD;
    }

    protected long getMessagePayloadSize() {
        return !this.inMessage ? 0L : this.msg.totalPosition() - this.messagePayloadStartPosition;
    }

    @Override
    public void visitDescribeProtocol(ProtocolDescriptor descriptor) {
        try {
            this.writeDescribeProtocolMessage(this.output, descriptor);
        }
        catch (Throwable t) {
            this.abortMessageAndRethrow(t);
        }
    }

    @Override
    public void visitHeartbeat(HeartbeatPayload heartbeatPayload) {
        if (heartbeatPayload.hasTimeMillis()) {
            this.lastPayloadTimeSequence = TimeSequenceUtil.getTimeSequenceFromTimeMillis(heartbeatPayload.getTimeMillis());
        }
        if (!this.writeHeartbeat) {
            return;
        }
        if (heartbeatPayload.isEmpty()) {
            return;
        }
        try {
            this.writeHeartbeatMessage(this.output, heartbeatPayload);
        }
        catch (Throwable t) {
            this.abortMessageAndRethrow(t);
        }
    }

    @Override
    public boolean visitData(DataProvider provider, MessageType type) {
        if (!type.isData()) {
            throw new IllegalArgumentException(type.toString());
        }
        if (!this.hasCapacity()) {
            return true;
        }
        try {
            boolean hasMore;
            this.beginMessage(type);
            while ((hasMore = provider.retrieveData(this)) && this.hasCapacity()) {
            }
            this.flushRecordStats();
            this.endMessage();
            return hasMore;
        }
        catch (Throwable t) {
            this.abortMessageAndRethrow(t);
            return false;
        }
    }

    @Override
    public boolean visitSubscription(SubscriptionProvider provider, MessageType type) {
        if (!type.isSubscription()) {
            throw new IllegalArgumentException(type.toString());
        }
        if (!this.hasCapacity()) {
            return true;
        }
        try {
            boolean hasMore;
            this.beginMessage(type);
            while ((hasMore = provider.retrieveSubscription(this)) && this.hasCapacity()) {
            }
            this.flushRecordStats();
            this.endMessage();
            return hasMore;
        }
        catch (Throwable t) {
            this.abortMessageAndRethrow(t);
            return false;
        }
    }

    @Override
    public boolean visitOtherMessage(int messageType, byte[] messageBytes, int offset, int length) {
        if (!this.hasCapacity()) {
            return true;
        }
        try {
            this.beginMessage(MessageType.findById(messageType));
            this.writeOtherMessageBody(messageBytes, offset, length);
            this.endMessage();
            return false;
        }
        catch (Throwable t) {
            this.abortMessageAndRethrow(t);
            return false;
        }
    }

    @Override
    public void append(RecordCursor cursor) {
        try {
            DataRecord record = cursor.getRecord();
            this.beginRecord(record);
            int eventFlags = this.writeRecordHeader(record, cursor.getCipher(), cursor.getSymbol(), cursor.getEventFlags());
            this.writeRecordPayload(cursor, eventFlags);
        }
        catch (IOException e) {
            throw new RuntimeQTPException(e);
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void visitRecord(DataRecord record, int cipher, String symbol) {
        try {
            this.beginRecord(record);
            this.writeRecordHeader(record, cipher, symbol, 0);
            if (this.writeEventTimeSequence) {
                this.writeEventTimeSequence(this.lastPayloadTimeSequence);
            }
        }
        catch (IOException e) {
            throw new RuntimeQTPException(e);
        }
    }

    @Override
    public void visitRecord(DataRecord record, int cipher, String symbol, long time) {
        try {
            this.beginRecord(record);
            this.writeRecordHeader(record, cipher, symbol, 0);
            if (this.currentMessageType.isHistorySubscriptionAdd()) {
                this.writeHistorySubscriptionTime(record, time);
            }
        }
        catch (IOException e) {
            throw new RuntimeQTPException(e);
        }
    }

    @Override
    public void visitIntField(DataIntField field, int value) {
        try {
            this.writeIntField(field, value);
        }
        catch (IOException e) {
            throw new RuntimeQTPException(e);
        }
    }

    @Override
    public void visitObjField(DataObjField field, Object value) {
        try {
            this.writeObjField(field, value);
        }
        catch (IOException e) {
            throw new RuntimeQTPException(e);
        }
    }

    protected final boolean inMessage() {
        return this.inMessage;
    }

    public final void beginMessage(MessageType messageType) {
        if (this.inMessage) {
            throw new IllegalStateException("Already in message");
        }
        this.inMessage = true;
        this.currentMessageType = messageType;
        this.msg.clear();
        try {
            this.writeMessageHeader(messageType);
        }
        catch (IOException e) {
            throw new RuntimeQTPException(e);
        }
        this.messagePayloadStartPosition = this.msg.totalPosition();
    }

    public final void endMessage() {
        if (!this.inMessage) {
            throw new IllegalStateException("Not in message");
        }
        this.inMessage = false;
        if (this.messagePayloadStartPosition == this.msg.totalPosition()) {
            this.undoWriteMessageHeaderStateChange();
            this.msg.clear();
            return;
        }
        try {
            this.finishComposingMessage(this.output);
        }
        catch (IOException e) {
            throw new RuntimeQTPException(e);
        }
    }

    protected void abortMessageAndRethrow(Throwable t) {
        this.inMessage = false;
        this.msg.clear();
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new RuntimeQTPException(t);
    }

    protected void writeDescribeProtocolMessage(BufferedOutput out, ProtocolDescriptor descriptor) throws IOException {
    }

    protected void writeEmptyHeartbeatMessage(BufferedOutput out) throws IOException {
    }

    protected void writeHeartbeatMessage(BufferedOutput out, HeartbeatPayload heartbeatPayload) throws IOException {
    }

    protected abstract void writeMessageHeader(MessageType var1) throws IOException;

    protected void undoWriteMessageHeaderStateChange() {
    }

    protected abstract int writeRecordHeader(DataRecord var1, int var2, String var3, int var4) throws IOException;

    protected void writeRecordPayload(RecordCursor cursor, int eventFlags) throws IOException {
        DataRecord record = cursor.getRecord();
        if (this.currentMessageType.isData()) {
            int i;
            if (this.writeEventTimeSequence) {
                this.writeEventTimeSequence(this.getEventTimeSequence(cursor));
            }
            for (i = 0; i < cursor.getIntCount(); ++i) {
                this.writeField(record.getIntField(i), cursor);
            }
            for (i = 0; i < cursor.getObjCount(); ++i) {
                this.writeField(record.getObjField(i), cursor);
            }
        } else if (this.currentMessageType.isHistorySubscriptionAdd()) {
            this.writeHistorySubscriptionTime(record, cursor.getTime());
        }
    }

    protected void writeEventTimeSequence(long eventTimeSequence) throws IOException {
    }

    protected abstract void writeHistorySubscriptionTime(DataRecord var1, long var2) throws IOException;

    protected abstract void writeIntField(DataIntField var1, int var2) throws IOException;

    protected abstract void writeObjField(DataObjField var1, Object var2) throws IOException;

    protected abstract void writeField(DataField var1, RecordCursor var2) throws IOException;

    protected void writeOtherMessageBody(byte[] messageBytes, int offset, int length) throws IOException {
    }

    protected void finishComposingMessage(BufferedOutput out) throws IOException {
        ChunkList chunks = this.msg.getOutput(this);
        out.writeAllFromChunkList(chunks, this);
    }

    protected long getEventTimeSequence(RecordCursor cursor) {
        long eventTimeSequence = cursor.getEventTimeSequence();
        return eventTimeSequence != 0L ? eventTimeSequence : this.lastPayloadTimeSequence;
    }

    protected void describeRecord(DataRecord record) throws IOException {
    }

    void updateMoreIOWriteRecordStats() {
    }

    protected final void beginRecord(DataRecord record) {
        this.flushRecordStats();
        int id = record.getId();
        if (this.recordState != null && this.recordState[id] == 0) {
            try {
                this.describeRecord(record);
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            this.recordState[id] = 1;
        }
        this.lastRecordId = id;
        this.lastRecordPosition = this.msg.totalPosition();
    }

    private void flushRecordStats() {
        if (this.lastRecordId >= 0) {
            this.stats.updateIOWriteRecordBytes(this.lastRecordId, this.msg.totalPosition() - this.lastRecordPosition);
            if (this.currentMessageType.isData()) {
                this.stats.updateIOWriteDataRecord();
            } else {
                this.stats.updateIOWriteSubRecord();
            }
            this.updateMoreIOWriteRecordStats();
            this.lastRecordId = -1;
        }
    }
}

