/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.qtp;

import com.devexperts.connector.proto.ApplicationConnectionFactory;
import com.devexperts.logging.Logging;
import com.devexperts.qd.qtp.AbstractConnectionHandler;
import com.devexperts.qd.qtp.MessageConnector;
import com.devexperts.qd.qtp.MessageConnectorListener;
import com.devexperts.qd.qtp.MessageConnectors;
import com.devexperts.qd.qtp.QTPConstants;
import com.devexperts.qd.qtp.help.MessageConnectorProperty;
import com.devexperts.qd.stats.QDStats;
import com.devexperts.transport.stats.ConnectionStats;
import com.devexperts.transport.stats.EndpointStats;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class AbstractMessageConnector
implements MessageConnector {
    protected Logging log;
    private ApplicationConnectionFactory factory;
    private final EndpointStats closedConnectionsStats = new EndpointStats();
    private final List<MessageConnectorListener> messageConnectorListeners = new CopyOnWriteArrayList<MessageConnectorListener>();
    private QDStats stats;
    private long reconnectDelay = QTPConstants.RECONNECT_DELAY;
    private int threadPriority = 5;
    private volatile boolean restarting;
    private volatile EndpointStats endpointStatsSnapshot = new EndpointStats();

    protected AbstractMessageConnector(ApplicationConnectionFactory factory) {
        if (factory == null) {
            throw new NullPointerException();
        }
        if (factory.getConfiguration(ApplicationConnectionFactory.NAME) == null) {
            factory = factory.clone();
            factory.setConfiguration(ApplicationConnectionFactory.NAME, this.getDefaultName(factory));
        }
        this.factory = factory;
        this.log = AbstractMessageConnector.getLoggingInternal(this.getName());
    }

    private String getDefaultName(ApplicationConnectionFactory factory) {
        String suffix;
        String type = this.getClass().getSimpleName().replace('$', '-');
        if (type.endsWith(suffix = "Connector")) {
            type = type.substring(0, type.length() - suffix.length());
        }
        return type + "-" + factory.toString();
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getName() {
        return this.factory.getConfiguration(ApplicationConnectionFactory.NAME);
    }

    @Override
    @MessageConnectorProperty(value="Name of this connector")
    public synchronized void setName(String name) {
        if (name == null) {
            name = this.getDefaultName(this.factory);
        }
        if (!this.getName().equals(name)) {
            this.log = AbstractMessageConnector.getLoggingInternal(name);
            this.log.info("Setting name=" + name);
            this.factory = this.factory.clone();
            this.factory.setConfiguration(ApplicationConnectionFactory.NAME, name);
            this.reconfigure();
        }
    }

    @Override
    public synchronized String getUser() {
        return this.factory.getConfiguration(MessageConnectors.USER_CONFIGURATION_KEY);
    }

    @Override
    @MessageConnectorProperty(value="User login name")
    public synchronized void setUser(String user) {
        if (!user.equals(this.getUser())) {
            this.factory = this.factory.clone();
            this.factory.setConfiguration(MessageConnectors.USER_CONFIGURATION_KEY, user);
            this.reconfigure();
        }
    }

    @Override
    public synchronized String getPassword() {
        return this.factory.getConfiguration(MessageConnectors.PASSWORD_CONFIGURATION_KEY);
    }

    @Override
    @MessageConnectorProperty(value="User password")
    public synchronized void setPassword(String password) {
        if (!password.equals(this.getPassword())) {
            this.factory = this.factory.clone();
            this.factory.setConfiguration(MessageConnectors.PASSWORD_CONFIGURATION_KEY, password);
            this.reconfigure();
        }
    }

    @Override
    public ApplicationConnectionFactory getFactory() {
        return this.factory;
    }

    @Override
    public void setFactory(ApplicationConnectionFactory factory) {
        this.factory = factory;
    }

    @Override
    public long getReconnectDelay() {
        return this.reconnectDelay;
    }

    @Override
    @MessageConnectorProperty(value="Delay between reconnection attempts in milliseconds")
    public synchronized void setReconnectDelay(long reconnectDelay) {
        if (this.reconnectDelay != reconnectDelay) {
            this.log.info("Setting reconnectDelay=" + reconnectDelay);
            this.reconnectDelay = reconnectDelay;
            this.reconfigure();
        }
    }

    @Override
    public QDStats getStats() {
        QDStats stats = this.stats;
        return stats == null ? QDStats.VOID : stats;
    }

    @Override
    public synchronized void setStats(QDStats stats) {
        if (this.stats != null) {
            throw new IllegalStateException("Stats are already initialized. You may change them only before start.");
        }
        if (stats == null) {
            throw new NullPointerException("stats is null");
        }
        this.stats = stats;
    }

    @Override
    public abstract void start();

    protected abstract Joinable stopImpl();

    protected void handlerClosed(AbstractConnectionHandler handler) {
    }

    @Override
    public final void stop() {
        this.stopImpl();
    }

    @Override
    public final void stopAndWait() throws InterruptedException {
        Joinable j = this.stopImpl();
        if (j != null) {
            j.join();
        }
    }

    @Override
    public synchronized void restart() {
        this.restarting = true;
        try {
            this.restartImpl(true);
        }
        finally {
            this.restarting = false;
            this.notifyMessageConnectorListeners();
        }
    }

    @Override
    public synchronized void reconnect() {
        this.restarting = true;
        try {
            this.restartImpl(false);
        }
        finally {
            this.restarting = false;
            this.notifyMessageConnectorListeners();
        }
    }

    protected void restartImpl(boolean fullStop) {
        this.stop();
        this.start();
    }

    protected synchronized void reconfigure() {
        this.factory.reinitConfiguration();
        if (this.isActive()) {
            this.restart();
        }
    }

    @Override
    public int getThreadPriority() {
        return this.threadPriority;
    }

    @Override
    @MessageConnectorProperty(value="Priority for threads associated with this connector")
    public synchronized void setThreadPriority(int priority) {
        if (this.threadPriority != priority) {
            this.log.info("Setting threadPriority=" + priority);
            this.threadPriority = priority;
            this.reconfigure();
        }
    }

    @Override
    public String getEndpointStats() {
        return new EndpointStats(this.retrieveCompleteEndpointStats(), this.endpointStatsSnapshot).toString();
    }

    @Override
    public void resetEndpointStats() {
        this.endpointStatsSnapshot = new EndpointStats(this.retrieveCompleteEndpointStats());
    }

    @Override
    public synchronized EndpointStats retrieveCompleteEndpointStats() {
        EndpointStats stats = new EndpointStats();
        stats.addEndpointStats(this.closedConnectionsStats);
        return stats;
    }

    @Override
    public long getClosedConnectionCount() {
        return this.closedConnectionsStats.getClosedConnectionCount();
    }

    public synchronized void addClosedConnectionStats(ConnectionStats stats) {
        this.closedConnectionsStats.addClosedConnectionCount(1L);
        this.closedConnectionsStats.addConnectionStats(stats);
    }

    @Override
    public void addMessageConnectorListener(MessageConnectorListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.messageConnectorListeners.add(listener);
    }

    @Override
    public void removeMessageConnectorListener(MessageConnectorListener listener) {
        this.messageConnectorListeners.remove(listener);
    }

    public void notifyMessageConnectorListeners() {
        if (this.restarting) {
            return;
        }
        for (MessageConnectorListener listener : this.messageConnectorListeners) {
            try {
                listener.stateChanged(this);
            }
            catch (Throwable t) {
                this.log.error("Error in MessageConnectorListener", t);
            }
        }
    }

    public Logging getLogging() {
        return this.log;
    }

    private static Logging getLoggingInternal(String name) {
        return Logging.getLogging(MessageConnector.class.getName() + "." + name);
    }

    public static interface Joinable {
        public void join() throws InterruptedException;
    }
}

