/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.qtp;

import com.devexperts.qd.qtp.AbstractMessageConnector;
import com.devexperts.qd.qtp.MessageConnectorState;
import com.devexperts.qd.qtp.QTPWorkerThread;
import com.devexperts.transport.stats.ConnectionStats;

public abstract class AbstractConnectionHandler<C extends AbstractMessageConnector>
extends QTPWorkerThread {
    protected final C connector;
    protected final String address;
    protected final ConnectionStats connectionStats = new ConnectionStats();
    private volatile MessageConnectorState state = MessageConnectorState.CONNECTING;

    protected AbstractConnectionHandler(C connector) {
        super(((AbstractMessageConnector)connector).getName());
        this.connector = connector;
        this.address = connector.getAddress();
    }

    public final ConnectionStats getConnectionStats() {
        return this.connectionStats;
    }

    public final MessageConnectorState getHandlerState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean makeConnected() {
        AbstractConnectionHandler abstractConnectionHandler = this;
        synchronized (abstractConnectionHandler) {
            if (this.state != MessageConnectorState.CONNECTING) {
                return false;
            }
            this.state = MessageConnectorState.CONNECTED;
        }
        ((AbstractMessageConnector)this.connector).notifyMessageConnectorListeners();
        return true;
    }

    @Override
    protected final void handleShutdown() {
        ((AbstractMessageConnector)this.connector).stop();
    }

    @Override
    protected final void handleClose(Throwable reason) {
        this.state = MessageConnectorState.DISCONNECTED;
        try {
            this.closeImpl(reason);
        }
        finally {
            ((AbstractMessageConnector)this.connector).handlerClosed(this);
            ((AbstractMessageConnector)this.connector).addClosedConnectionStats(this.connectionStats);
            ((AbstractMessageConnector)this.connector).notifyMessageConnectorListeners();
        }
    }

    protected abstract void closeImpl(Throwable var1);

    public static interface Factory {
        public AbstractConnectionHandler<AbstractMessageConnector> createHandler(String var1, AbstractMessageConnector var2);
    }
}

