/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.ng;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.QDContract;

public final class RecordMode {
    private static final RecordMode[] FLAG_TO_MODE = new RecordMode[128];
    public static final RecordMode DATA = RecordMode.get(3);
    public static final RecordMode HISTORY_SUBSCRIPTION = RecordMode.get(1);
    public static final RecordMode SUBSCRIPTION = RecordMode.get(0);
    public static final RecordMode FLAGGED_DATA = RecordMode.get(7);
    public static final RecordMode MARKED_DATA = RecordMode.get(11);
    public static final RecordMode TIMESTAMPED_DATA = RecordMode.get(19);
    final int f;
    final boolean data;
    final boolean historyTime;
    final int eventFlagsOfs;
    final int timeMarkOfs;
    final int eventTimeSequenceOfs;
    final int linkOfs;
    final int attachmentOfs;
    final int extraIntCount;
    final int extraObjCount;
    final int intBufOffset;
    final int objBufOffset;

    private static RecordMode get(int f) {
        RecordMode mode = FLAG_TO_MODE[f];
        if (mode != null) {
            return mode;
        }
        return RecordMode.getSync(f);
    }

    private static synchronized RecordMode getSync(int f) {
        RecordMode mode = FLAG_TO_MODE[f];
        if (mode != null) {
            return mode;
        }
        RecordMode.FLAG_TO_MODE[f] = new RecordMode(f);
        return RecordMode.FLAG_TO_MODE[f];
    }

    public static RecordMode addedSubscriptionFor(QDContract contract) {
        return contract == QDContract.HISTORY ? HISTORY_SUBSCRIPTION : SUBSCRIPTION;
    }

    RecordMode(int f) {
        this.f = f;
        this.data = (f & 3) == 3;
        this.historyTime = (f & 1) == 1;
        int intOfs = 0;
        this.eventFlagsOfs = (f & 4) != 0 ? --intOfs : 0;
        this.timeMarkOfs = (f & 8) != 0 ? --intOfs : 0;
        this.eventTimeSequenceOfs = (f & 0x10) != 0 ? (intOfs -= 2) : 0;
        this.linkOfs = (f & 0x20) != 0 ? --intOfs : 0;
        this.extraIntCount = -intOfs;
        int objOfs = 0;
        this.attachmentOfs = (f & 0x40) != 0 ? --objOfs : 0;
        this.extraObjCount = -objOfs;
        this.intBufOffset = 1 + this.extraIntCount;
        this.objBufOffset = 2 + this.extraObjCount;
    }

    public boolean isSubsetOf(RecordMode mode) {
        return (this.f & mode.f) == this.f;
    }

    public boolean hasData() {
        return this.data;
    }

    public boolean hasEventFlags() {
        return this.eventFlagsOfs != 0;
    }

    public RecordMode withEventFlags() {
        return RecordMode.get(this.f | 4);
    }

    public boolean hasTimeMark() {
        return this.timeMarkOfs != 0;
    }

    public RecordMode withTimeMark() {
        return RecordMode.get(this.f | 8);
    }

    public boolean hasEventTimeSequence() {
        return this.eventTimeSequenceOfs != 0;
    }

    public RecordMode withEventTimeSequence() {
        return RecordMode.get(this.f | 0x10);
    }

    public boolean hasLink() {
        return this.linkOfs != 0;
    }

    public RecordMode withLink() {
        return RecordMode.get(this.f | 0x20);
    }

    public boolean hasAttachment() {
        return this.attachmentOfs != 0;
    }

    public RecordMode withAttachment() {
        return RecordMode.get(this.f | 0x40);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.data) {
            sb.append("DATA");
        } else {
            if (this.historyTime) {
                sb.append("HISTORY_");
            }
            sb.append("SUBSCRIPTION");
        }
        if (this.eventFlagsOfs != 0) {
            sb.append(",EVENT_FLAGS");
        }
        if (this.timeMarkOfs != 0) {
            sb.append(",MARK");
        }
        if (this.eventTimeSequenceOfs != 0) {
            sb.append(",TIMESTAMP");
        }
        if (this.linkOfs != 0) {
            sb.append(",LINK");
        }
        if (this.attachmentOfs != 0) {
            sb.append(",ATTACHMENT");
        }
        return sb.toString();
    }

    int intFieldCount(DataRecord record) {
        if (this.data) {
            return record.getIntFieldCount();
        }
        if (this.historyTime) {
            return record.hasTime() ? 2 : 0;
        }
        return 0;
    }

    int objFieldCount(DataRecord record) {
        if (this.data) {
            return record.getObjFieldCount();
        }
        return 0;
    }

    boolean differentIntFieldCount(DataRecord oldRecord, DataRecord newRecord) {
        return this.intFieldCount(oldRecord) != this.intFieldCount(newRecord);
    }

    boolean differentObjFieldCount(DataRecord oldRecord, DataRecord newRecord) {
        return this.objFieldCount(oldRecord) != this.objFieldCount(newRecord);
    }

    private static class F {
        static final int HISTORY_TIME = 1;
        static final int DATA_ONLY_BIT = 2;
        static final int DATA = 3;
        static final int EVENT_FLAGS = 4;
        static final int TIME_MARK = 8;
        static final int EVENT_TIME_SEQUENCE = 16;
        static final int LINK = 32;
        static final int ATTACHMENT = 64;
        static final int N = 128;

        private F() {
        }
    }
}

