/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.ng;

import com.devexperts.qd.DataField;
import com.devexperts.qd.DataIntField;
import com.devexperts.qd.DataRecord;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.util.Decimal;
import com.devexperts.util.TimeUtil;
import com.devexperts.util.WideDecimal;
import java.util.HashMap;
import java.util.Map;

public abstract class RecordMapping {
    private final DataRecord record;
    private final Map<String, String> nonDefaultPropertyName = new HashMap<String, String>();

    protected RecordMapping(DataRecord record) {
        this.record = record;
    }

    protected void putNonDefaultPropertyName(String localName, String propertyName) {
        this.nonDefaultPropertyName.put(localName, propertyName);
    }

    public String getNonDefaultPropertyName(String localName) {
        return this.nonDefaultPropertyName.get(localName);
    }

    public Object getEventSymbolByQDSymbol(String qdSymbol) {
        return qdSymbol;
    }

    public String getQDSymbolByEventSymbol(Object symbol) {
        return symbol.toString();
    }

    public final DataRecord getRecord() {
        return this.record;
    }

    protected final int getInt(RecordCursor cursor, int intFieldIndex) {
        return cursor.getIntMappedImpl(this.record, intFieldIndex);
    }

    protected final long getLong(RecordCursor cursor, int intFieldIndex) {
        return cursor.getLongMappedImpl(this.record, intFieldIndex);
    }

    protected final Object getObj(RecordCursor cursor, int objFieldIndex) {
        return cursor.getObjMappedImpl(this.record, objFieldIndex);
    }

    protected final void setInt(RecordCursor cursor, int intFieldIndex, int value) {
        cursor.setIntMappedImpl(this.record, intFieldIndex, value);
    }

    protected final void setLong(RecordCursor cursor, int intFieldIndex, long value) {
        cursor.setLongMappedImpl(this.record, intFieldIndex, value);
    }

    protected final void setObj(RecordCursor cursor, int objFieldIndex, Object value) {
        cursor.setObjMappedImpl(this.record, objFieldIndex, value);
    }

    protected final int findIntField(String localName, boolean required) {
        DataField field = this.record.findFieldByName(localName);
        if (field instanceof DataIntField) {
            return field.getIndex() << 8 | field.getSerialType().getId() & 0xFF;
        }
        if (required) {
            throw new IllegalArgumentException("Required int field " + localName + " is missing in record " + this.record);
        }
        return Integer.MIN_VALUE;
    }

    protected final int getAsInt(RecordCursor cursor, int fieldId) {
        switch (fieldId & 0xF0) {
            case 0: {
                return cursor.getIntMappedImpl(this.record, fieldId >> 8);
            }
            case 96: {
                return (int)cursor.getLongMappedImpl(this.record, fieldId >> 8);
            }
            case 16: {
                return (int)Decimal.toDouble(cursor.getIntMappedImpl(this.record, fieldId >> 8));
            }
            case 112: {
                return (int)WideDecimal.toLong(cursor.getLongMappedImpl(this.record, fieldId >> 8));
            }
        }
        throw new IllegalArgumentException();
    }

    protected final long getAsLong(RecordCursor cursor, int fieldId) {
        switch (fieldId & 0xF0) {
            case 0: {
                return cursor.getIntMappedImpl(this.record, fieldId >> 8);
            }
            case 96: {
                return cursor.getLongMappedImpl(this.record, fieldId >> 8);
            }
            case 16: {
                return (long)Decimal.toDouble(cursor.getIntMappedImpl(this.record, fieldId >> 8));
            }
            case 112: {
                return WideDecimal.toLong(cursor.getLongMappedImpl(this.record, fieldId >> 8));
            }
        }
        throw new IllegalArgumentException();
    }

    protected final double getAsDouble(RecordCursor cursor, int fieldId) {
        switch (fieldId & 0xF0) {
            case 0: {
                return cursor.getIntMappedImpl(this.record, fieldId >> 8);
            }
            case 96: {
                return cursor.getLongMappedImpl(this.record, fieldId >> 8);
            }
            case 16: {
                return Decimal.toDouble(cursor.getIntMappedImpl(this.record, fieldId >> 8));
            }
            case 112: {
                return WideDecimal.toDouble(cursor.getLongMappedImpl(this.record, fieldId >> 8));
            }
        }
        throw new IllegalArgumentException();
    }

    protected final int getAsTinyDecimal(RecordCursor cursor, int fieldId) {
        switch (fieldId & 0xF0) {
            case 0: {
                return Decimal.composeDecimal(cursor.getIntMappedImpl(this.record, fieldId >> 8), 0);
            }
            case 96: {
                return Decimal.composeDecimal(cursor.getLongMappedImpl(this.record, fieldId >> 8), 0);
            }
            case 16: {
                return cursor.getIntMappedImpl(this.record, fieldId >> 8);
            }
            case 112: {
                return Decimal.wideToTiny(cursor.getLongMappedImpl(this.record, fieldId >> 8));
            }
        }
        throw new IllegalArgumentException();
    }

    protected final long getAsWideDecimal(RecordCursor cursor, int fieldId) {
        switch (fieldId & 0xF0) {
            case 0: {
                return WideDecimal.composeWide(cursor.getIntMappedImpl(this.record, fieldId >> 8), 0);
            }
            case 96: {
                return WideDecimal.composeWide(cursor.getLongMappedImpl(this.record, fieldId >> 8), 0);
            }
            case 16: {
                return Decimal.tinyToWide(cursor.getIntMappedImpl(this.record, fieldId >> 8));
            }
            case 112: {
                return cursor.getLongMappedImpl(this.record, fieldId >> 8);
            }
        }
        throw new IllegalArgumentException();
    }

    protected final void setAsInt(RecordCursor cursor, int fieldId, int value) {
        switch (fieldId & 0xF0) {
            case 0: {
                cursor.setIntMappedImpl(this.record, fieldId >> 8, value);
                break;
            }
            case 96: {
                cursor.setLongMappedImpl(this.record, fieldId >> 8, value);
                break;
            }
            case 16: {
                cursor.setIntMappedImpl(this.record, fieldId >> 8, Decimal.composeDecimal(value, 0));
                break;
            }
            case 112: {
                cursor.setLongMappedImpl(this.record, fieldId >> 8, WideDecimal.composeWide(value, 0));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    protected final void setAsLong(RecordCursor cursor, int fieldId, long value) {
        switch (fieldId & 0xF0) {
            case 0: {
                cursor.setIntMappedImpl(this.record, fieldId >> 8, (int)value);
                break;
            }
            case 96: {
                cursor.setLongMappedImpl(this.record, fieldId >> 8, value);
                break;
            }
            case 16: {
                cursor.setIntMappedImpl(this.record, fieldId >> 8, Decimal.composeDecimal(value, 0));
                break;
            }
            case 112: {
                cursor.setLongMappedImpl(this.record, fieldId >> 8, WideDecimal.composeWide(value, 0));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    protected final void setAsDouble(RecordCursor cursor, int fieldId, double value) {
        switch (fieldId & 0xF0) {
            case 0: {
                cursor.setIntMappedImpl(this.record, fieldId >> 8, (int)value);
                break;
            }
            case 96: {
                cursor.setLongMappedImpl(this.record, fieldId >> 8, (long)value);
                break;
            }
            case 16: {
                cursor.setIntMappedImpl(this.record, fieldId >> 8, Decimal.compose(value));
                break;
            }
            case 112: {
                cursor.setLongMappedImpl(this.record, fieldId >> 8, WideDecimal.composeWide(value));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    protected final void setAsTinyDecimal(RecordCursor cursor, int fieldId, int value) {
        switch (fieldId & 0xF0) {
            case 0: {
                cursor.setIntMappedImpl(this.record, fieldId >> 8, (int)Decimal.toDouble(value));
                break;
            }
            case 96: {
                cursor.setLongMappedImpl(this.record, fieldId >> 8, (long)Decimal.toDouble(value));
                break;
            }
            case 16: {
                cursor.setIntMappedImpl(this.record, fieldId >> 8, value);
                break;
            }
            case 112: {
                cursor.setLongMappedImpl(this.record, fieldId >> 8, Decimal.tinyToWide(value));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    protected final void setAsWideDecimal(RecordCursor cursor, int fieldId, long value) {
        switch (fieldId & 0xF0) {
            case 0: {
                cursor.setIntMappedImpl(this.record, fieldId >> 8, (int)WideDecimal.toLong(value));
                break;
            }
            case 96: {
                cursor.setLongMappedImpl(this.record, fieldId >> 8, WideDecimal.toLong(value));
                break;
            }
            case 16: {
                cursor.setIntMappedImpl(this.record, fieldId >> 8, Decimal.wideToTiny(value));
                break;
            }
            case 112: {
                cursor.setLongMappedImpl(this.record, fieldId >> 8, value);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    protected final int getAsTimeSeconds(RecordCursor cursor, int fieldId) {
        switch (fieldId & 0xF0) {
            case 48: {
                return cursor.getIntMappedImpl(this.record, fieldId >> 8);
            }
            case 144: {
                return TimeUtil.getSecondsFromTime(cursor.getLongMappedImpl(this.record, fieldId >> 8));
            }
        }
        throw new IllegalArgumentException();
    }

    protected final void setAsTimeSeconds(RecordCursor cursor, int fieldId, int value) {
        switch (fieldId & 0xF0) {
            case 48: {
                cursor.setIntMappedImpl(this.record, fieldId >> 8, value);
                break;
            }
            case 144: {
                cursor.setLongMappedImpl(this.record, fieldId >> 8, (long)value * 1000L);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    protected final long getAsTimeMillis(RecordCursor cursor, int fieldId) {
        switch (fieldId & 0xF0) {
            case 48: {
                return (long)cursor.getIntMappedImpl(this.record, fieldId >> 8) * 1000L;
            }
            case 144: {
                return cursor.getLongMappedImpl(this.record, fieldId >> 8);
            }
        }
        throw new IllegalArgumentException();
    }

    protected final void setAsTimeMillis(RecordCursor cursor, int fieldId, long value) {
        switch (fieldId & 0xF0) {
            case 48: {
                cursor.setIntMappedImpl(this.record, fieldId >> 8, TimeUtil.getSecondsFromTime(value));
                break;
            }
            case 144: {
                cursor.setLongMappedImpl(this.record, fieldId >> 8, value);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }
}

