/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.ng;

import com.devexperts.io.BufferedInput;
import com.devexperts.qd.DataField;
import com.devexperts.qd.DataIterator;
import com.devexperts.qd.DataRecord;
import com.devexperts.qd.DataVisitor;
import com.devexperts.qd.SubscriptionVisitor;
import com.devexperts.qd.kit.VoidIntField;
import com.devexperts.qd.ng.RecordMode;
import com.devexperts.qd.ng.RecordSink;
import com.devexperts.qd.ng.Throws;
import java.io.DataInput;
import java.io.IOException;
import java.util.Objects;

public final class RecordCursor {
    static final int UNLINKED = -1;
    private boolean readOnly;
    private DataRecord record;
    private RecordMode mode;
    private int cipher;
    private String symbol;
    private int[] intFlds;
    private Object[] objFlds;
    private int intOffset;
    private int objOffset;
    int intCount;
    int objCount;
    int eventFlags;
    int timeMark;
    Object attachment;

    public static RecordCursor allocate(RecordCursor source) {
        RecordCursor cursor = RecordCursor.allocate(source.getRecord(), source.getCipher(), source.getSymbol());
        cursor.copyFrom(source);
        return cursor;
    }

    public static RecordCursor allocate(DataRecord record, int cipher, String symbol) {
        return RecordCursor.allocate(record, cipher, symbol, RecordMode.DATA);
    }

    public static RecordCursor allocate(DataRecord record, int cipher, String symbol, RecordMode mode) {
        RecordCursor cursor = RecordCursor.allocateInternal(record, mode);
        cursor.setSymbolInternal(cipher, symbol);
        return cursor;
    }

    public static RecordCursor allocate(DataRecord record, String symbol) {
        return RecordCursor.allocate(record, record.getScheme().getCodec().encode(symbol), symbol);
    }

    public static RecordCursor allocate(DataRecord record, String symbol, RecordMode mode) {
        return RecordCursor.allocate(record, record.getScheme().getCodec().encode(symbol), symbol, mode);
    }

    public static Owner allocateOwner(RecordCursor source) {
        return RecordCursor.allocate(source).new Owner();
    }

    public static Owner allocateOwner(DataRecord record, int cipher, String symbol) {
        return RecordCursor.allocate(record, cipher, symbol).new Owner();
    }

    public static Owner allocateOwner(DataRecord record, int cipher, String symbol, RecordMode mode) {
        return RecordCursor.allocate(record, cipher, symbol, mode).new Owner();
    }

    public static Owner allocateOwner(DataRecord record) {
        return RecordCursor.allocateInternal(record, RecordMode.DATA).new Owner();
    }

    public static Owner allocateOwner(DataRecord record, RecordMode mode) {
        return RecordCursor.allocateInternal(record, mode).new Owner();
    }

    public static Owner allocateOwner() {
        return new RecordCursor(false).new Owner();
    }

    public DataRecord getRecord() {
        return this.record;
    }

    public RecordMode getMode() {
        return this.mode;
    }

    public int getCipher() {
        return this.cipher;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String getDecodedSymbol() {
        return this.record.getScheme().getCodec().decode(this.cipher, this.symbol);
    }

    public int getIntCount() {
        return this.intCount;
    }

    public int getInt(int intFieldIndex) {
        if (intFieldIndex < 0 || intFieldIndex >= this.intCount) {
            Throws.throwIndexOutOfBoundsException(intFieldIndex, this.intCount);
        }
        return this.intFlds[this.intOffset + intFieldIndex];
    }

    int getIntMappedImpl(DataRecord record, int intFieldIndex) {
        if (record != this.record) {
            Throws.throwWrongRecord(this.record, record);
        }
        if (!this.mode.hasData()) {
            Throws.throwWrongMode(this.mode);
        }
        return this.intFlds[this.intOffset + intFieldIndex];
    }

    public long getLong(int intFieldIndex) {
        if (intFieldIndex < 0 || intFieldIndex >= this.intCount - 1) {
            Throws.throwIndexOutOfBoundsException(intFieldIndex, this.intCount - 1);
        }
        return this.getLongImpl(intFieldIndex);
    }

    long getLongMappedImpl(DataRecord record, int intFieldIndex) {
        if (record != this.record) {
            Throws.throwWrongRecord(this.record, record);
        }
        if (!this.mode.hasData()) {
            Throws.throwWrongMode(this.mode);
        }
        return this.getLongImpl(intFieldIndex);
    }

    public int getObjCount() {
        return this.objCount;
    }

    public Object getObj(int objFieldIndex) {
        if (objFieldIndex < 0 || objFieldIndex >= this.objCount) {
            Throws.throwIndexOutOfBoundsException(objFieldIndex, this.objCount);
        }
        return this.objFlds[this.objOffset + objFieldIndex];
    }

    Object getObjMappedImpl(DataRecord record, int objFieldIndex) {
        if (record != this.record) {
            Throws.throwWrongRecord(this.record, record);
        }
        if (!this.mode.hasData()) {
            Throws.throwWrongMode(this.mode);
        }
        return this.objFlds[this.objOffset + objFieldIndex];
    }

    public void getIntsTo(int intFieldIndex, int[] to, int offset, int length) {
        length = Math.min(length, this.intCount - intFieldIndex);
        if (intFieldIndex < 0 || length < 0) {
            Throws.throwIndexOutOfBoundsException(intFieldIndex, this.intCount, length);
        }
        this.getIntsImpl(intFieldIndex, to, offset, length);
    }

    public void getObjsTo(int objFieldIndex, Object[] to, int offset, int length) {
        length = Math.min(length, this.objCount - objFieldIndex);
        if (objFieldIndex < 0 || length < 0) {
            Throws.throwIndexOutOfBoundsException(objFieldIndex, this.objCount, length);
        }
        this.getObjsImpl(objFieldIndex, to, offset, length);
    }

    public boolean updateIntsTo(int intFieldIndex, int[] to, int offset, int length) {
        length = Math.min(length, this.intCount - intFieldIndex);
        if (intFieldIndex < 0 || length < 0) {
            Throws.throwIndexOutOfBoundsException(intFieldIndex, this.intCount, length);
        }
        if (offset < 0 || offset > to.length - length) {
            Throws.throwIndexOutOfBoundsException(offset, to.length, length);
        }
        boolean changed = false;
        for (int i = 0; i < length; ++i) {
            int v = this.intFlds[this.intOffset + intFieldIndex + i];
            if (this.record.getIntField(intFieldIndex + i).equals(to[offset + i], v)) continue;
            to[offset + i] = v;
            changed = true;
        }
        return changed;
    }

    public boolean updateObjsTo(int objFieldIndex, Object[] to, int offset, int length) {
        length = Math.min(length, this.objCount - objFieldIndex);
        if (objFieldIndex < 0 || length < 0) {
            Throws.throwIndexOutOfBoundsException(objFieldIndex, this.objCount, length);
        }
        if (offset < 0 || offset > to.length - length) {
            Throws.throwIndexOutOfBoundsException(offset, to.length, length);
        }
        boolean changed = false;
        for (int i = 0; i < length; ++i) {
            Object v = this.objFlds[this.objOffset + objFieldIndex + i];
            if (this.record.getObjField(objFieldIndex + i).equals(to[offset + i], v)) continue;
            to[offset + i] = v;
            changed = true;
        }
        return changed;
    }

    public boolean hasTime() {
        return this.record.hasTime() && this.intCount >= 2;
    }

    public long getTime() {
        return this.hasTime() ? this.getLongImpl(0) : 0L;
    }

    public void setTime(long time) {
        if (this.hasTime()) {
            this.setLongImpl(0, time);
        }
    }

    public boolean hasEventFlags() {
        return this.mode.eventFlagsOfs != 0 || this.eventFlags != 0;
    }

    public int getEventFlags() {
        return this.mode.eventFlagsOfs != 0 ? this.intFlds[this.intOffset + this.mode.eventFlagsOfs] : this.eventFlags;
    }

    public void setEventFlags(int eventFlags) {
        if (this.mode.eventFlagsOfs != 0) {
            if (this.readOnly) {
                Throws.throwReadOnly();
            }
            this.intFlds[this.intOffset + this.mode.eventFlagsOfs] = eventFlags;
        }
    }

    public boolean hasTimeMark() {
        return this.mode.timeMarkOfs != 0 || this.timeMark != 0;
    }

    public int getTimeMark() {
        return this.mode.timeMarkOfs != 0 ? this.intFlds[this.intOffset + this.mode.timeMarkOfs] : this.timeMark;
    }

    public void setTimeMark(int timeMark) {
        if (this.mode.timeMarkOfs != 0) {
            if (this.readOnly) {
                Throws.throwReadOnly();
            }
            this.intFlds[this.intOffset + this.mode.timeMarkOfs] = timeMark;
        }
    }

    public boolean hasEventTimeSequence() {
        return this.mode.eventTimeSequenceOfs != 0;
    }

    public long getEventTimeSequence() {
        return this.mode.eventTimeSequenceOfs != 0 ? this.getLongImpl(this.mode.eventTimeSequenceOfs) : 0L;
    }

    public int getEventTimeSeconds() {
        return this.mode.eventTimeSequenceOfs != 0 ? this.intFlds[this.intOffset + this.mode.eventTimeSequenceOfs] : 0;
    }

    public int getEventSequence() {
        return this.mode.eventTimeSequenceOfs != 0 ? this.intFlds[this.intOffset + this.mode.eventTimeSequenceOfs + 1] : 0;
    }

    public void setEventTimeSequence(long eventTimeSequence) {
        if (this.mode.eventTimeSequenceOfs != 0) {
            this.setLongImpl(this.mode.eventTimeSequenceOfs, eventTimeSequence);
        }
    }

    public void setEventTimeSeconds(int eventTimeSeconds) {
        if (this.mode.eventTimeSequenceOfs != 0) {
            if (this.readOnly) {
                Throws.throwReadOnly();
            }
            this.intFlds[this.intOffset + this.mode.eventTimeSequenceOfs] = eventTimeSeconds;
        }
    }

    public void setEventSequence(int eventSequence) {
        if (this.mode.eventTimeSequenceOfs != 0) {
            if (this.readOnly) {
                Throws.throwReadOnly();
            }
            this.intFlds[this.intOffset + this.mode.eventTimeSequenceOfs + 1] = eventSequence;
        }
    }

    public boolean hasLink() {
        return this.mode.linkOfs != 0;
    }

    public boolean isUnlinked() {
        return this.mode.linkOfs != 0 && this.intFlds[this.intOffset + this.mode.linkOfs] == -1;
    }

    public void setLinkTo(long position) {
        if (this.mode.linkOfs != 0) {
            int delta;
            if (this.readOnly) {
                Throws.throwReadOnly();
            }
            if ((delta = this.getIntPositionInternal() - (int)position) <= 0) {
                throw new IllegalArgumentException("Should link to previous position in buffer");
            }
            this.intFlds[this.intOffset + this.mode.linkOfs] = delta;
        }
    }

    public boolean hasAttachment() {
        return this.mode.attachmentOfs != 0 || this.attachment != null;
    }

    public Object getAttachment() {
        return this.mode.attachmentOfs != 0 ? this.objFlds[this.objOffset + this.mode.attachmentOfs] : this.attachment;
    }

    public void setAttachment(Object attachment) {
        if (this.mode.attachmentOfs != 0) {
            if (this.readOnly) {
                Throws.throwReadOnly();
            }
            this.objFlds[this.objOffset + this.mode.attachmentOfs] = attachment;
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.mode == null || this.record == null) {
            sb.append("empty cursor");
        } else {
            int i;
            sb.append(this.mode).append(" cursor ").append(this.record);
            sb.append(' ').append(this.getDecodedSymbol());
            sb.append(" @");
            RecordCursor.formatPosition(sb, this.intOffset, this.objOffset);
            if (this.intFlds != null && this.intOffset >= 0) {
                for (i = 0; i < this.intCount && this.intOffset + i < this.intFlds.length; ++i) {
                    if (!this.acceptField(this.record.getIntField(i))) continue;
                    sb.append(' ').append(this.record.getIntField(i).getString(this));
                }
            }
            if (this.objFlds != null && this.objOffset >= 0) {
                for (i = 0; i < this.objCount && this.objOffset + i < this.objFlds.length; ++i) {
                    if (!this.acceptField(this.record.getObjField(i))) continue;
                    sb.append(' ').append(this.record.getObjField(i).getString(this));
                }
            }
        }
        if (this.readOnly) {
            sb.append(", readOnly");
        }
        if (this.hasEventFlags()) {
            sb.append(", eventFlags=0x").append(Integer.toHexString(this.getEventFlags()));
        }
        return sb.toString();
    }

    public void setInt(int intFieldIndex, int value) {
        if (this.readOnly) {
            Throws.throwReadOnly();
        }
        if (intFieldIndex < 0 || intFieldIndex >= this.intCount) {
            Throws.throwIndexOutOfBoundsException(intFieldIndex, this.intCount);
        }
        this.intFlds[this.intOffset + intFieldIndex] = value;
    }

    void setIntMappedImpl(DataRecord record, int intFieldIndex, int value) {
        if (this.readOnly) {
            Throws.throwReadOnly();
        }
        if (record != this.record) {
            Throws.throwWrongRecord(this.record, record);
        }
        if (!this.mode.hasData()) {
            Throws.throwWrongMode(this.mode);
        }
        this.intFlds[this.intOffset + intFieldIndex] = value;
    }

    public void setLong(int intFieldIndex, long value) {
        if (this.readOnly) {
            Throws.throwReadOnly();
        }
        if (intFieldIndex < 0 || intFieldIndex >= this.intCount - 1) {
            Throws.throwIndexOutOfBoundsException(intFieldIndex, this.intCount - 1);
        }
        this.setLongImpl(intFieldIndex, value);
    }

    void setLongMappedImpl(DataRecord record, int intFieldIndex, long value) {
        if (this.readOnly) {
            Throws.throwReadOnly();
        }
        if (record != this.record) {
            Throws.throwWrongRecord(this.record, record);
        }
        if (!this.mode.hasData()) {
            Throws.throwWrongMode(this.mode);
        }
        this.setLongImpl(intFieldIndex, value);
    }

    public void setObj(int objFieldIndex, Object value) {
        if (this.readOnly) {
            Throws.throwReadOnly();
        }
        if (objFieldIndex < 0 || objFieldIndex >= this.objCount) {
            Throws.throwIndexOutOfBoundsException(objFieldIndex, this.objCount);
        }
        this.objFlds[this.objOffset + objFieldIndex] = value;
    }

    void setObjMappedImpl(DataRecord record, int objFieldIndex, Object value) {
        if (this.readOnly) {
            Throws.throwReadOnly();
        }
        if (record != this.record) {
            Throws.throwWrongRecord(this.record, record);
        }
        if (!this.mode.hasData()) {
            Throws.throwWrongMode(this.mode);
        }
        this.objFlds[this.objOffset + objFieldIndex] = value;
    }

    public void clearFields() {
        this.clearData();
    }

    public void clearData() {
        if (this.readOnly) {
            Throws.throwReadOnly();
        }
        this.clearDataInternalFrom(0, 0);
    }

    public void clearDataButTime() {
        if (this.readOnly) {
            Throws.throwReadOnly();
        }
        int iFrom = 2;
        int oFrom = 0;
        this.clearDataInternalFrom(iFrom, oFrom);
    }

    public void copyFrom(DataIterator iterator) {
        int i;
        if (this.readOnly) {
            Throws.throwReadOnly();
        }
        for (i = 0; i < this.intCount; ++i) {
            this.intFlds[this.intOffset + i] = iterator.nextIntField();
        }
        for (i = 0; i < this.objCount; ++i) {
            this.objFlds[this.objOffset + i] = iterator.nextObjField();
        }
    }

    public void copyFrom(RecordCursor from) {
        if (this.readOnly) {
            Throws.throwReadOnly();
        }
        int iCount = Math.min(this.intCount, from.intCount);
        int oCount = Math.min(this.objCount, from.objCount);
        from.copyDataInternalTo(iCount, oCount, this.intFlds, this.intOffset, this.objFlds, this.objOffset);
        from.copyExtraInternalTo(this.mode, this.intFlds, this.intOffset, this.objFlds, this.objOffset);
    }

    public void copyDataFrom(RecordCursor from) {
        if (this.readOnly) {
            Throws.throwReadOnly();
        }
        int iCount = from.intCount;
        int oCount = from.objCount;
        if (iCount > this.intCount || oCount > this.objCount) {
            throw new IllegalArgumentException("too many incoming fields");
        }
        from.copyDataInternalTo(iCount, oCount, this.intFlds, this.intOffset, this.objFlds, this.objOffset);
        this.clearDataInternalFrom(iCount, oCount);
    }

    public boolean updateFrom(RecordCursor from) {
        return this.updateDataFrom(from);
    }

    public boolean updateDataFrom(RecordCursor from) {
        if (this.readOnly) {
            Throws.throwReadOnly();
        }
        if (this.record != from.record) {
            Throws.throwWrongRecord(this.record, from.record);
        }
        boolean changed = false;
        int iCount = Math.min(this.intCount, from.intCount);
        for (int i = 0; i < iCount; ++i) {
            int v = from.intFlds[from.intOffset + i];
            if (this.record.getIntField(i).equals(this.intFlds[this.intOffset + i], v)) continue;
            this.intFlds[this.intOffset + i] = v;
            changed = true;
        }
        int oCount = Math.min(this.objCount, from.objCount);
        for (int i = 0; i < oCount; ++i) {
            Object v = from.objFlds[from.objOffset + i];
            if (this.record.getObjField(i).equals(this.objFlds[this.objOffset + i], v)) continue;
            this.objFlds[this.objOffset + i] = v;
            changed = true;
        }
        return changed;
    }

    public boolean isDataIdenticalTo(RecordCursor other) {
        if (this.record != other.record) {
            Throws.throwWrongRecord(this.record, other.record);
        }
        int iCount = Math.min(this.intCount, other.intCount);
        for (int i = 0; i < iCount; ++i) {
            if (this.intFlds[this.intOffset + i] == other.intFlds[other.intOffset + i]) continue;
            return false;
        }
        int oCount = Math.min(this.objCount, other.objCount);
        for (int i = 0; i < oCount; ++i) {
            if (this.objFlds[this.objOffset + i] == other.objFlds[other.objOffset + i]) continue;
            return false;
        }
        return true;
    }

    public void readFrom(DataInput in) throws IOException {
        int i;
        if (this.readOnly) {
            Throws.throwReadOnly();
        }
        for (i = 0; i < this.intCount; ++i) {
            this.intFlds[this.intOffset + i] = this.record.getIntField(i).readInt(in);
        }
        for (i = 0; i < this.objCount; ++i) {
            this.objFlds[this.objOffset + i] = this.record.getObjField(i).readObj(in);
        }
    }

    public void readDataFrom(BufferedInput in) throws IOException {
        if (this.readOnly) {
            Throws.throwReadOnly();
        }
        this.record.readFields(in, this);
    }

    public boolean examineData(DataVisitor visitor) {
        if (this.record == null) {
            return false;
        }
        if (!this.mode.hasData()) {
            Throws.throwWrongMode(this.mode);
        }
        if (!visitor.hasCapacity()) {
            return true;
        }
        if (visitor instanceof RecordSink) {
            ((RecordSink)visitor).append(this);
        } else {
            int i;
            visitor.visitRecord(this.record, this.cipher, this.symbol);
            for (i = 0; i < this.intCount; ++i) {
                visitor.visitIntField(this.record.getIntField(i), this.intFlds[this.intOffset + i]);
            }
            for (i = 0; i < this.objCount; ++i) {
                visitor.visitObjField(this.record.getObjField(i), this.objFlds[this.objOffset + i]);
            }
        }
        return false;
    }

    public boolean examineSubscription(SubscriptionVisitor visitor) {
        if (this.record == null) {
            return false;
        }
        if (this.mode.hasData()) {
            Throws.throwWrongMode(this.mode);
        }
        if (!visitor.hasCapacity()) {
            return true;
        }
        if (visitor instanceof RecordSink) {
            ((RecordSink)visitor).append(this);
        } else {
            visitor.visitRecord(this.record, this.cipher, this.symbol, this.hasTime() ? this.getTime() : 0L);
        }
        return false;
    }

    public RecordCursor() {
    }

    public void setAs(DataRecord record, int cipher, String symbol, int[] int_flds, int int_offset, Object[] obj_flds, int obj_offset, boolean writable) {
        this.setReadOnlyInternal(!writable);
        this.setRecordInternal(record, RecordMode.DATA);
        this.setSymbolInternal(cipher, symbol);
        this.setArraysInternal(int_flds, obj_flds);
        this.setOffsetsInternal(int_offset, obj_offset);
        this.rangeCheckInternal();
    }

    public void reset() {
        this.resetInternal();
    }

    public long getPosition() {
        return RecordCursor.makePosition(this.getIntPositionInternal(), this.getObjPositionInternal());
    }

    static RecordCursor allocateInternal(DataRecord record, RecordMode mode) {
        RecordCursor cursor = new RecordCursor(false);
        cursor.setRecordInternal(record, mode);
        int intCount = mode.extraIntCount + mode.intFieldCount(record);
        int objCount = mode.extraObjCount + mode.objFieldCount(record);
        cursor.setArraysInternal(intCount == 0 ? null : new int[intCount], objCount == 0 ? null : new Object[objCount]);
        cursor.setOffsetsInternal(mode.extraIntCount, mode.extraObjCount);
        return cursor;
    }

    RecordCursor(boolean readOnly) {
        this.readOnly = readOnly;
    }

    void setReadOnlyInternal(boolean read_only) {
        this.readOnly = read_only;
    }

    void setRecordInternal(DataRecord record, RecordMode mode) {
        if (this.record != record || this.mode != mode) {
            this.record = Objects.requireNonNull(record);
            this.mode = Objects.requireNonNull(mode);
            this.intCount = mode.intFieldCount(record);
            this.objCount = mode.objFieldCount(record);
        }
    }

    void setSymbolInternal(int cipher, String symbol) {
        this.cipher = cipher;
        this.symbol = symbol;
    }

    void setArraysInternal(int[] intFlds, Object[] objFlds) {
        this.intFlds = intFlds;
        this.objFlds = objFlds;
    }

    void ensureCapacityInternal() {
        int osize;
        int isize;
        int n = isize = this.intFlds == null ? 0 : this.intFlds.length;
        if (this.intCount > isize) {
            this.intFlds = new int[Math.max(this.intCount, isize * 2)];
        }
        int n2 = osize = this.objFlds == null ? 0 : this.objFlds.length;
        if (this.objCount > osize) {
            this.objFlds = new Object[Math.max(this.objCount, osize * 2)];
        }
    }

    void setOffsetsInternal(int intOffset, int objOffset) {
        this.intOffset = intOffset;
        this.objOffset = objOffset;
    }

    void setAsInternal(RecordCursor other) {
        this.readOnly = other.readOnly;
        this.record = other.record;
        this.mode = other.mode;
        this.cipher = other.cipher;
        this.symbol = other.symbol;
        this.intFlds = other.intFlds;
        this.objFlds = other.objFlds;
        this.intOffset = other.intOffset;
        this.objOffset = other.objOffset;
        this.intCount = other.intCount;
        this.objCount = other.objCount;
        this.eventFlags = other.eventFlags;
        this.timeMark = other.timeMark;
        this.attachment = other.attachment;
    }

    void getIntsImpl(int iFrom, int[] to, int offset, int length) {
        System.arraycopy(this.intFlds, this.intOffset + iFrom, to, offset, length);
    }

    void getObjsImpl(int oFrom, Object[] to, int offset, int length) {
        System.arraycopy(this.objFlds, this.objOffset + oFrom, to, offset, length);
    }

    void clearDataInternalFrom(int iFrom, int oFrom) {
        int i;
        for (i = iFrom; i < this.intCount; ++i) {
            this.intFlds[this.intOffset + i] = 0;
        }
        for (i = oFrom; i < this.objCount; ++i) {
            this.objFlds[this.objOffset + i] = null;
        }
    }

    void copyDataInternalTo(int iCount, int oCount, int[] toInts, int iOffset, Object[] toObjs, int oOffset) {
        if (iCount > 0) {
            this.getIntsImpl(0, toInts, iOffset, iCount);
        }
        if (oCount > 0) {
            this.getObjsImpl(0, toObjs, oOffset, oCount);
        }
    }

    void copyExtraInternalTo(RecordMode mode, int[] toInts, int iOffset, Object[] toObjs, int oOffset) {
        if (mode.eventFlagsOfs != 0) {
            toInts[iOffset + mode.eventFlagsOfs] = this.getEventFlags();
        }
        if (mode.timeMarkOfs != 0) {
            toInts[iOffset + mode.timeMarkOfs] = this.getTimeMark();
        }
        if (mode.eventTimeSequenceOfs != 0) {
            if (this.mode.eventTimeSequenceOfs != 0) {
                toInts[iOffset + mode.eventTimeSequenceOfs] = this.intFlds[this.intOffset + this.mode.eventTimeSequenceOfs];
                toInts[iOffset + mode.eventTimeSequenceOfs + 1] = this.intFlds[this.intOffset + this.mode.eventTimeSequenceOfs + 1];
            } else {
                toInts[iOffset + mode.eventTimeSequenceOfs] = 0;
                toInts[iOffset + mode.eventTimeSequenceOfs + 1] = 0;
            }
        }
        if (mode.attachmentOfs != 0) {
            toObjs[oOffset + mode.attachmentOfs] = this.getAttachment();
        }
    }

    void rangeCheckInternal() {
        if (this.intCount > 0 && (this.intOffset | this.intFlds.length - this.intOffset - this.intCount) < 0) {
            throw new IndexOutOfBoundsException("intFlds");
        }
        if (this.objCount > 0 && (this.objOffset | this.objFlds.length - this.objOffset - this.objCount) < 0) {
            throw new IndexOutOfBoundsException("objFlds");
        }
    }

    void resetAccessInternal() {
        this.objOffset = -2000000000;
        this.intOffset = -2000000000;
    }

    void resetAccessInternal(int intLimit, int objLimit) {
        if (this.intOffset >= intLimit || this.objOffset >= objLimit) {
            this.resetAccessInternal();
        }
    }

    void resetInternal() {
        this.readOnly = false;
        this.record = null;
        this.cipher = 0;
        this.symbol = null;
        this.intFlds = null;
        this.objFlds = null;
        this.intOffset = 0;
        this.objOffset = 0;
        this.intCount = 0;
        this.objCount = 0;
        this.eventFlags = 0;
        this.timeMark = 0;
        this.attachment = null;
    }

    int getIntPositionInternal() {
        return this.intOffset - this.mode.intBufOffset;
    }

    int getObjPositionInternal() {
        return this.objOffset - this.mode.objBufOffset;
    }

    static long makePosition(int iPos, int oPos) {
        return (long)oPos << 32 | (long)iPos;
    }

    static void formatPosition(StringBuilder sb, int iPos, int oPos) {
        sb.append(Integer.toHexString(oPos));
        sb.append(':');
        sb.append(Integer.toHexString(iPos));
    }

    private long getLongImpl(int index) {
        int hi = this.intFlds[this.intOffset + index];
        int lo = this.intFlds[this.intOffset + index + 1];
        return (long)hi << 32 | (long)lo & 0xFFFFFFFFL;
    }

    private void setLongImpl(int index, long value) {
        if (this.readOnly) {
            Throws.throwReadOnly();
        }
        this.intFlds[this.intOffset + index] = (int)(value >> 32);
        this.intFlds[this.intOffset + index + 1] = (int)value;
    }

    private boolean acceptField(DataField f) {
        return !(f instanceof VoidIntField);
    }

    public final class Owner {
        Owner() {
        }

        public RecordCursor cursor() {
            return RecordCursor.this;
        }

        public void setReadOnly(boolean read_only) {
            RecordCursor.this.setReadOnlyInternal(read_only);
        }

        public void setRecord(DataRecord record) {
            RecordCursor.this.setRecordInternal(record, RecordMode.DATA);
        }

        public void setRecord(DataRecord record, RecordMode mode) {
            RecordCursor.this.setRecordInternal(record, mode);
        }

        public void setSymbol(int cipher, String symbol) {
            RecordCursor.this.setSymbolInternal(cipher, symbol);
        }

        public void setArrays(int[] intFlds, Object[] objFlds) {
            RecordCursor.this.setArraysInternal(intFlds, objFlds);
        }

        public void setOffsets(int intOffset, int objOffset) {
            RecordCursor.this.setOffsetsInternal(intOffset, objOffset);
        }

        public void setAs(RecordCursor other) {
            RecordCursor.this.setAsInternal(other);
        }

        public void reset() {
            RecordCursor.this.resetInternal();
        }

        public void setEventFlags(int eventFlags) {
            RecordCursor.this.eventFlags = eventFlags;
        }

        public void setTimeMark(int timeMark) {
            RecordCursor.this.timeMark = timeMark;
        }

        public void setAttachment(Object attachment) {
            RecordCursor.this.attachment = attachment;
        }
    }
}

