/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.ng;

import com.devexperts.qd.DataConsumer;
import com.devexperts.qd.DataIntField;
import com.devexperts.qd.DataIterator;
import com.devexperts.qd.DataListener;
import com.devexperts.qd.DataObjField;
import com.devexperts.qd.DataRecord;
import com.devexperts.qd.DataVisitor;
import com.devexperts.qd.SubscriptionConsumer;
import com.devexperts.qd.SubscriptionFilter;
import com.devexperts.qd.SubscriptionIterator;
import com.devexperts.qd.SubscriptionListener;
import com.devexperts.qd.SubscriptionVisitor;
import com.devexperts.qd.ng.RecordConsumer;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.ng.RecordFilter;
import com.devexperts.qd.ng.RecordListener;
import com.devexperts.qd.ng.RecordMode;
import com.devexperts.qd.ng.RecordProvider;
import com.devexperts.qd.ng.RecordSink;
import com.devexperts.qd.ng.RecordSource;
import com.devexperts.qd.ng.Throws;
import com.devexperts.qd.util.DataIterators;
import com.devexperts.util.ArrayUtil;
import com.devexperts.util.SystemProperties;
import com.devexperts.util.ThreadLocalPool;
import java.util.Arrays;

public final class RecordBuffer
extends RecordSource
implements RecordProvider,
RecordSink,
DataConsumer,
SubscriptionConsumer,
RecordConsumer {
    private static final int MAX_POOLED_INTS = SystemProperties.getIntProperty(RecordBuffer.class, "maxPooledInts", 16384);
    private static final int MAX_POOLED_OBJS = SystemProperties.getIntProperty(RecordBuffer.class, "maxPooledObjs", 8192);
    private static int maxIntFields = SystemProperties.getIntProperty(RecordBuffer.class, "maxIntFields", 64);
    private static int maxObjFields = SystemProperties.getIntProperty(RecordBuffer.class, "maxObjFields", 32);
    static final int INT_CIPHER = 0;
    static final int INT_FIELDS = 1;
    static final int OBJ_RECORD = 0;
    static final int OBJ_SYMBOL = 1;
    static final int OBJ_FIELDS = 2;
    private static final ThreadLocalPool<RecordBuffer> THREAD_LOCAL_POOL = new ThreadLocalPool(RecordBuffer.class.getName(), 3, 1024);
    private final RecordCursor readCursor;
    private final RecordCursor writeCursor;
    private RecordMode mode;
    private boolean capacityLimited;
    private boolean released;
    private int[] intFlds;
    private Object[] objFlds;
    private int intPosition;
    private int objPosition;
    private int intLimit;
    private int objLimit;
    private int size;
    private int intFieldIndex;
    private int objFieldIndex;

    public static RecordBuffer getInstance() {
        return RecordBuffer.getInstance(RecordMode.DATA);
    }

    public static RecordBuffer getInstance(RecordMode mode) {
        RecordBuffer result = THREAD_LOCAL_POOL.poll();
        if (result == null) {
            return new RecordBuffer(mode);
        }
        result.released = false;
        result.setMode(mode);
        result.setCapacityLimited(false);
        return result;
    }

    public RecordBuffer() {
        this(RecordMode.DATA);
    }

    public RecordBuffer(RecordMode mode) {
        this.mode = mode;
        this.intFlds = new int[32];
        this.objFlds = new Object[32];
        this.readCursor = new RecordCursor(true);
        this.writeCursor = new RecordCursor(false);
        this.reinitCursorArraysInternal();
    }

    public void release() {
        this.clear();
        this.released = true;
        if (this.intFlds.length > MAX_POOLED_INTS || this.objFlds.length > MAX_POOLED_OBJS) {
            return;
        }
        THREAD_LOCAL_POOL.offer(this);
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    @Override
    public RecordMode getMode() {
        return this.mode;
    }

    public void setMode(RecordMode mode) {
        if (mode == null) {
            Throws.throwNullPointerException();
        }
        if (mode == this.mode) {
            return;
        }
        if (this.size != 0) {
            Throws.throwModeChangeNonEmpty(this.mode, mode);
        }
        this.mode = mode;
    }

    public boolean isCapacityLimited() {
        return this.capacityLimited;
    }

    public void setCapacityLimited(boolean capacityLimited) {
        this.capacityLimited = capacityLimited;
    }

    @Override
    public boolean hasCapacity() {
        return !this.capacityLimited || this.intLimit < MAX_POOLED_INTS - maxIntFields && this.objLimit < MAX_POOLED_OBJS - maxObjFields;
    }

    public boolean hasEstimatedCapacityForBytes(int bytes) {
        return this.intLimit + bytes <= MAX_POOLED_INTS && this.objLimit + bytes <= MAX_POOLED_OBJS;
    }

    public void clear() {
        if (this.released) {
            Throws.throwReleased();
        }
        Arrays.fill(this.intFlds, 0, this.intLimit, 0);
        Arrays.fill(this.objFlds, 0, this.objLimit, null);
        this.resetCursorsAccess();
        this.intPosition = 0;
        this.objPosition = 0;
        this.intLimit = 0;
        this.objLimit = 0;
        this.size = 0;
    }

    public void rewind() {
        if (this.released) {
            Throws.throwReleased();
        }
        this.intPosition = 0;
        this.objPosition = 0;
    }

    @Override
    public RecordSource newSource() {
        if (this.released) {
            Throws.throwReleased();
        }
        return new RecordBuffer(this.mode, this.intFlds, this.intLimit, this.intPosition, this.objFlds, this.objLimit, this.objPosition);
    }

    @Override
    public RecordSource newSource(long start, long end) {
        if (this.released) {
            Throws.throwReleased();
        }
        int ilim = (int)end;
        int olim = (int)(end >>> 32);
        if (ilim < 0 || ilim > this.intLimit || olim < 0 || olim > this.objLimit) {
            throw new IndexOutOfBoundsException("end");
        }
        int ipos = (int)start;
        int opos = (int)(start >>> 32);
        if (ipos < 0 || ipos > ilim || opos < 0 || opos > olim) {
            throw new IndexOutOfBoundsException("start");
        }
        return new RecordBuffer(this.mode, this.intFlds, ilim, ipos, this.objFlds, olim, opos);
    }

    @Override
    public long getLimit() {
        return RecordCursor.makePosition(this.intLimit, this.objLimit);
    }

    @Override
    public long getPosition() {
        return RecordCursor.makePosition(this.intPosition, this.objPosition);
    }

    @Override
    public void setPosition(long position) {
        int ipos = (int)position;
        int opos = (int)(position >>> 32);
        if (ipos < 0 || ipos > this.intLimit || opos < 0 || opos > this.objLimit) {
            throw new IndexOutOfBoundsException();
        }
        this.intPosition = ipos;
        this.objPosition = opos;
    }

    public void setLimit(long limit) {
        int ilim = (int)limit;
        int olim = (int)(limit >>> 32);
        this.setLimitInternal(ilim, olim);
        this.readCursor.resetAccessInternal(this.intLimit, this.objLimit);
        this.writeCursor.resetAccessInternal(this.intLimit, this.objLimit);
    }

    public DataRecord getRecordAt(long position) {
        int opos = (int)(position >>> 32);
        if (opos < 0 || opos >= this.objLimit) {
            Throws.throwIndexOutOfBoundsException(opos, this.objLimit);
        }
        return (DataRecord)this.objFlds[opos + 0];
    }

    public int getCipherAt(long position) {
        int ipos = (int)position;
        if (ipos < 0 || ipos >= this.intLimit) {
            Throws.throwIndexOutOfBoundsException(ipos, this.intLimit);
        }
        return this.intFlds[ipos + 0];
    }

    public String getSymbolAt(long position) {
        int opos = (int)(position >>> 32);
        if (opos < 0 || opos >= this.objLimit) {
            Throws.throwIndexOutOfBoundsException(opos, this.objLimit);
        }
        return (String)this.objFlds[opos + 1];
    }

    public long getEventTimeSequenceAt(long position) {
        if (this.mode.eventTimeSequenceOfs == 0) {
            return 0L;
        }
        int ipos = (int)position;
        if (ipos < 0 || ipos >= this.intLimit) {
            Throws.throwIndexOutOfBoundsException(ipos, this.intLimit);
        }
        int index = ipos + this.mode.intBufOffset + this.mode.eventTimeSequenceOfs;
        return (long)this.intFlds[index] << 32 | (long)this.intFlds[index + 1] & 0xFFFFFFFFL;
    }

    @Override
    public RecordCursor cursorAt(long position) {
        int ipos = (int)position;
        int opos = (int)(position >>> 32);
        if (ipos < 0 || ipos >= this.intLimit) {
            if (ipos == this.intLimit && opos == this.objLimit) {
                return null;
            }
            Throws.throwIndexOutOfBoundsException(ipos, this.intLimit);
        }
        if (opos < 0 || opos >= this.objLimit) {
            Throws.throwIndexOutOfBoundsException(opos, this.objLimit);
        }
        return this.setCursorInternal(this.readCursor, ipos, opos);
    }

    public RecordCursor writeCursorAt(long position) {
        int ipos = (int)position;
        int opos = (int)(position >>> 32);
        if (ipos < 0 || ipos >= this.intLimit) {
            Throws.throwIndexOutOfBoundsException(ipos, this.intLimit);
        }
        if (opos < 0 || opos >= this.objLimit) {
            Throws.throwIndexOutOfBoundsException(opos, this.objLimit);
        }
        return this.setCursorInternal(this.writeCursor, ipos, opos);
    }

    @Override
    public RecordCursor current() {
        if (this.intPosition >= this.intLimit) {
            return null;
        }
        return this.setCursorInternal(this.readCursor, this.intPosition, this.objPosition);
    }

    public RecordCursor writeCurrent() {
        if (this.intPosition >= this.intLimit) {
            return null;
        }
        return this.setCursorInternal(this.writeCursor, this.intPosition, this.objPosition);
    }

    public boolean hasNext() {
        return this.intPosition < this.intLimit;
    }

    @Override
    public RecordCursor next() {
        if (this.intPosition >= this.intLimit) {
            return null;
        }
        RecordCursor cursor = this.setCursorInternal(this.readCursor, this.intPosition, this.objPosition);
        this.incPosition(cursor);
        return cursor;
    }

    public RecordCursor writeNext() {
        if (this.intPosition >= this.intLimit) {
            return null;
        }
        RecordCursor cursor = this.setCursorInternal(this.writeCursor, this.intPosition, this.objPosition);
        this.incPosition(cursor);
        return cursor;
    }

    public RecordCursor add(DataRecord record, int cipher, String symbol) {
        if (this.released) {
            Throws.throwReleased();
        }
        this.initWriteCursorInternal(record, cipher, symbol);
        int iInc = this.mode.intBufOffset + this.writeCursor.intCount;
        int oInc = this.mode.objBufOffset + this.writeCursor.objCount;
        this.growIfNeeded(iInc, oInc);
        this.appendInternal(this.writeCursor, iInc, oInc);
        return this.writeCursor;
    }

    public RecordCursor add(RecordCursor from) {
        this.add(from.getRecord(), from.getCipher(), from.getSymbol()).copyFrom(from);
        return this.writeCursor;
    }

    @Override
    public void append(RecordCursor from) {
        if (this.released) {
            Throws.throwReleased();
        }
        DataRecord record = from.getRecord();
        int intFieldCount = this.mode.intFieldCount(record);
        int objFieldCount = this.mode.objFieldCount(record);
        int iInc = this.mode.intBufOffset + intFieldCount;
        int oInc = this.mode.objBufOffset + objFieldCount;
        this.growIfNeeded(iInc, oInc);
        this.appendInternal(from, iInc, oInc);
        int iCount = Math.min(intFieldCount, from.intCount);
        int oCount = Math.min(objFieldCount, from.objCount);
        from.copyDataInternalTo(iCount, oCount, this.intFlds, this.intLimit - intFieldCount, this.objFlds, this.objLimit - objFieldCount);
        from.copyExtraInternalTo(this.mode, this.intFlds, this.intLimit - intFieldCount, this.objFlds, this.objLimit - objFieldCount);
    }

    public RecordCursor addDataAndCompactIfNeeded(RecordCursor from) {
        if (this.released) {
            Throws.throwReleased();
        }
        DataRecord record = from.getRecord();
        int intFieldCount = this.mode.intFieldCount(record);
        int objFieldCount = this.mode.objFieldCount(record);
        int iInc = this.mode.intBufOffset + intFieldCount;
        int oInc = this.mode.objBufOffset + objFieldCount;
        this.growOrCompactIfNeeded(iInc, oInc);
        this.readCursor.resetAccessInternal();
        this.initWriteCursorInternal(record, from.getCipher(), from.getSymbol());
        this.appendInternal(from, iInc, oInc);
        int iCount = Math.min(intFieldCount, from.intCount);
        int oCount = Math.min(objFieldCount, from.objCount);
        from.copyDataInternalTo(iCount, oCount, this.intFlds, this.intLimit - intFieldCount, this.objFlds, this.objLimit - objFieldCount);
        return this.writeCursor;
    }

    public void replaceRecordAt(long position, DataRecord newRecord) {
        DataRecord oldRecord;
        int opos = (int)(position >>> 32);
        if (opos < 0 || opos >= this.objLimit) {
            Throws.throwIndexOutOfBoundsException(opos, this.objLimit);
        }
        if (this.mode.differentIntFieldCount(oldRecord = (DataRecord)this.objFlds[opos + 0], newRecord) || this.mode.differentObjFieldCount(oldRecord, newRecord)) {
            Throws.throwDifferentNumberOfFields(newRecord, oldRecord);
        }
        this.objFlds[opos + 0] = newRecord;
    }

    public void replaceSymbolAt(long position, int cipher, String symbol) {
        int ipos = (int)position;
        int opos = (int)(position >>> 32);
        if (ipos < 0 || ipos >= this.intLimit) {
            Throws.throwIndexOutOfBoundsException(ipos, this.intLimit);
        }
        if (opos < 0 || opos >= this.objLimit) {
            Throws.throwIndexOutOfBoundsException(opos, this.objLimit);
        }
        this.intFlds[ipos + 0] = cipher;
        this.objFlds[opos + 1] = symbol;
    }

    public void removeAt(long position) {
        int ipos = (int)position;
        int opos = (int)(position >>> 32);
        if (ipos < 0 || ipos >= this.intLimit || opos < 0 || opos >= this.objLimit) {
            throw new IndexOutOfBoundsException();
        }
        DataRecord record = (DataRecord)this.objFlds[opos + 0];
        int iremove = this.mode.intBufOffset + this.mode.intFieldCount(record);
        int oremove = this.mode.objBufOffset + this.mode.objFieldCount(record);
        if (this.intPosition > this.intLimit - iremove || this.objPosition > this.objLimit - oremove) {
            throw new IndexOutOfBoundsException();
        }
        System.arraycopy(this.intFlds, ipos + iremove, this.intFlds, ipos, this.intLimit - iremove - ipos);
        System.arraycopy(this.objFlds, opos + oremove, this.objFlds, opos, this.objLimit - oremove - opos);
        Arrays.fill(this.intFlds, this.intLimit - iremove, this.intLimit, 0);
        Arrays.fill(this.objFlds, this.objLimit - oremove, this.objLimit, null);
        this.resetCursorsAccess();
        this.intLimit -= iremove;
        this.objLimit -= oremove;
        --this.size;
    }

    @Override
    public void process(RecordSource source) {
        this.process(source, null);
    }

    public void process(RecordSource source, SubscriptionFilter filter) {
        RecordCursor cursor;
        if (this.released) {
            Throws.throwReleased();
        }
        if (source instanceof RecordBuffer && filter == null && this.fastCopyFrom((RecordBuffer)source)) {
            return;
        }
        while ((cursor = source.next()) != null) {
            if (filter != null && !filter.acceptRecord(cursor.getRecord(), cursor.getCipher(), cursor.getSymbol())) continue;
            this.append(cursor);
        }
    }

    public void addAll(RecordSource source) {
        this.process(source, null);
    }

    public void addAll(RecordSource source, SubscriptionFilter filter) {
        this.process(source, filter);
    }

    public void processData(DataIterator it, SubscriptionFilter filter) {
        DataRecord record;
        if (it instanceof RecordSource) {
            this.process((RecordSource)it, filter);
            return;
        }
        while ((record = it.nextRecord()) != null) {
            int cipher = it.getCipher();
            String symbol = it.getSymbol();
            if (filter == null || filter.acceptRecord(record, cipher, symbol)) {
                this.add(record, cipher, symbol).copyFrom(it);
                continue;
            }
            DataIterators.skipRecord(record, it);
        }
    }

    public void processSubscription(SubscriptionIterator it, SubscriptionFilter filter) {
        DataRecord record;
        if (it instanceof RecordSource) {
            this.process((RecordSource)it, filter);
            return;
        }
        while ((record = it.nextRecord()) != null) {
            int cipher = it.getCipher();
            String symbol = it.getSymbol();
            if (filter != null && !filter.acceptRecord(record, cipher, symbol)) continue;
            this.add(record, cipher, symbol).setTime(it.getTime());
        }
    }

    public DataVisitor visitor() {
        return this;
    }

    public void compact() {
        if (this.released) {
            Throws.throwReleased();
        }
        if (this.intPosition == 0 && this.objPosition == 0) {
            return;
        }
        this.compactArrays();
        this.resetCursorsAccess();
        this.size = this.computeIteratorSize();
    }

    public boolean compact(RecordFilter filter) {
        if (this.released) {
            Throws.throwReleased();
        }
        if (filter == null) {
            this.compact();
            return false;
        }
        if (this.mode.linkOfs != 0) {
            throw new IllegalArgumentException("Filtered compaction is not supported with link mode");
        }
        int intPtr = 0;
        int objPtr = 0;
        int filtered = 0;
        while (this.intPosition < this.intLimit && this.objPosition < this.objLimit) {
            RecordCursor cursor = this.setCursorInternal(this.readCursor, this.intPosition, this.objPosition);
            int intLength = this.mode.intBufOffset + cursor.intCount;
            int objLength = this.mode.objBufOffset + cursor.objCount;
            if (filter.accept(cursor)) {
                System.arraycopy(this.intFlds, this.intPosition, this.intFlds, intPtr, intLength);
                System.arraycopy(this.objFlds, this.objPosition, this.objFlds, objPtr, objLength);
                intPtr += intLength;
                objPtr += objLength;
                ++filtered;
            }
            this.intPosition += intLength;
            this.objPosition += objLength;
        }
        Arrays.fill(this.intFlds, intPtr, this.intLimit, 0);
        Arrays.fill(this.objFlds, objPtr, this.objLimit, null);
        this.resetCursorsAccess();
        this.intPosition = 0;
        this.objPosition = 0;
        this.intLimit = intPtr;
        this.objLimit = objPtr;
        boolean result = this.size != filtered;
        this.size = filtered;
        return result;
    }

    public void cleanup(RecordCursor cursor) {
        int ipos = cursor.getIntPositionInternal();
        int opos = cursor.getObjPositionInternal();
        if (ipos < 0 || ipos >= this.intLimit) {
            Throws.throwIndexOutOfBoundsException(ipos, this.intLimit);
        }
        if (opos < 0 || opos >= this.objLimit) {
            Throws.throwIndexOutOfBoundsException(opos, this.objLimit);
        }
        if (this.objFlds[opos + 0] == null) {
            Throws.throwCleared();
        }
        Arrays.fill(this.intFlds, ipos, ipos + this.mode.intBufOffset + cursor.intCount, 0);
        Arrays.fill(this.objFlds, opos, opos + this.mode.objBufOffset + cursor.objCount, null);
        --this.size;
    }

    public void unlinkFrom(long position) {
        if (this.mode.linkOfs == 0) {
            throw new IllegalStateException("unlinkFrom(...) requires mode with link");
        }
        int ipos = (int)position;
        if (ipos < 0 || ipos >= this.intLimit) {
            Throws.throwIndexOutOfBoundsException(ipos, this.intLimit);
        }
        while (ipos >= this.intPosition) {
            int oldLink = this.intFlds[ipos + this.mode.intBufOffset + this.mode.linkOfs];
            if (oldLink == -1) {
                throw new IllegalStateException("Already unlinked at " + ipos);
            }
            this.intFlds[ipos + this.mode.intBufOffset + this.mode.linkOfs] = -1;
            if (oldLink == 0) break;
            ipos -= oldLink;
        }
    }

    public void flagFrom(long position, int eventFlags) {
        if (this.mode.linkOfs == 0) {
            throw new IllegalStateException("flagFrom(...) requires mode with link");
        }
        if (this.mode.eventFlagsOfs == 0) {
            throw new IllegalStateException("flagFrom(...) requires mode with event flags");
        }
        int ipos = (int)position;
        if (ipos < 0 || ipos >= this.intLimit) {
            Throws.throwIndexOutOfBoundsException(ipos, this.intLimit);
        }
        while (ipos >= this.intPosition) {
            int link = this.intFlds[ipos + this.mode.intBufOffset + this.mode.linkOfs];
            if (link == -1) {
                throw new IllegalStateException("Already unlinked at " + ipos);
            }
            int n = ipos + this.mode.intBufOffset + this.mode.eventFlagsOfs;
            this.intFlds[n] = this.intFlds[n] | eventFlags;
            if (link == 0) break;
            ipos -= link;
        }
    }

    @Override
    public boolean retrieve(RecordSink sink) {
        while (sink.hasCapacity()) {
            RecordCursor cursor = this.next();
            if (cursor == null) {
                return false;
            }
            sink.append(cursor);
        }
        return this.hasNext();
    }

    @Override
    public void setRecordListener(RecordListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void flush() {
    }

    @Override
    public void processData(DataIterator it) {
        this.processData(it, null);
    }

    @Override
    public void processSubscription(SubscriptionIterator it) {
        this.processSubscription(it, null);
    }

    @Override
    public DataRecord nextRecord() {
        if (this.next() == null) {
            this.readCursor.resetAccessInternal();
            return null;
        }
        this.intFieldIndex = 0;
        this.objFieldIndex = 0;
        return this.readCursor.getRecord();
    }

    @Override
    public int getCipher() {
        return this.readCursor.getCipher();
    }

    @Override
    public String getSymbol() {
        return this.readCursor.getSymbol();
    }

    @Override
    public long getTime() {
        return this.readCursor.getTime();
    }

    @Override
    public int nextIntField() {
        return this.readCursor.getInt(this.intFieldIndex++);
    }

    @Override
    public Object nextObjField() {
        return this.readCursor.getObj(this.objFieldIndex++);
    }

    @Override
    public void visitRecord(DataRecord record, int cipher, String symbol) {
        if (!this.mode.hasData()) {
            Throws.throwWrongMode(this.mode);
        }
        this.add(record, cipher, symbol);
        this.intFieldIndex = 0;
        this.objFieldIndex = 0;
    }

    @Override
    public void visitRecord(DataRecord record, int cipher, String symbol, long time) {
        this.add(record, cipher, symbol).setTime(time);
    }

    @Override
    public void visitIntField(DataIntField field, int value) {
        this.writeCursor.setInt(this.intFieldIndex++, value);
    }

    @Override
    public void visitObjField(DataObjField field, Object value) {
        this.writeCursor.setObj(this.objFieldIndex++, value);
    }

    @Override
    public boolean retrieveData(DataVisitor visitor) {
        if (visitor instanceof RecordSink) {
            return this.retrieve((RecordSink)visitor);
        }
        while (visitor.hasCapacity()) {
            RecordCursor cursor = this.next();
            if (cursor == null) {
                return false;
            }
            if (!cursor.examineData(visitor)) continue;
            throw new IllegalStateException("Second capacity check returns different result.");
        }
        return true;
    }

    @Override
    public void setDataListener(DataListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retrieveSubscription(SubscriptionVisitor visitor) {
        if (visitor instanceof RecordSink) {
            return this.retrieve((RecordSink)visitor);
        }
        while (visitor.hasCapacity()) {
            RecordCursor cursor = this.next();
            if (cursor == null) {
                return false;
            }
            if (!cursor.examineSubscription(visitor)) continue;
            throw new IllegalStateException("Second capacity check returns different result.");
        }
        return true;
    }

    @Override
    public void setSubscriptionListener(SubscriptionListener listener) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.mode).append(" buffer, size=").append(this.size);
        sb.append(", position=");
        RecordCursor.formatPosition(sb, this.intPosition, this.objPosition);
        sb.append(", limit=");
        RecordCursor.formatPosition(sb, this.intLimit, this.objLimit);
        if (this.capacityLimited) {
            sb.append(", capacityLimited");
        }
        return sb.toString();
    }

    RecordBuffer(RecordMode mode, int[] intFlds, int intLimit, int intPosition, Object[] objFlds, int objLimit, int objPosition) {
        this.mode = mode;
        this.intFlds = intFlds;
        this.intLimit = intLimit;
        this.intPosition = intPosition;
        this.objFlds = objFlds;
        this.objLimit = objLimit;
        this.objPosition = objPosition;
        this.readCursor = new RecordCursor(true);
        this.writeCursor = null;
        this.reinitCursorArraysInternal();
    }

    void reinitCursorArraysInternal() {
        this.readCursor.setArraysInternal(this.intFlds, this.objFlds);
        if (this.writeCursor != null) {
            this.writeCursor.setArraysInternal(this.intFlds, this.objFlds);
        }
    }

    RecordCursor setCursorInternal(RecordCursor cursor, int ipos, int opos) {
        cursor.setRecordInternal((DataRecord)this.objFlds[opos + 0], this.mode);
        cursor.setSymbolInternal(this.intFlds[ipos + 0], (String)this.objFlds[opos + 1]);
        cursor.setOffsetsInternal(ipos + this.mode.intBufOffset, opos + this.mode.objBufOffset);
        return cursor;
    }

    void setLimitInternal(int ilim, int olim) {
        if (ilim < 0 || ilim > this.intLimit || olim < 0 || olim > this.objLimit) {
            throw new IndexOutOfBoundsException();
        }
        this.size -= this.computeIteratorSize(olim, this.objLimit);
        Arrays.fill(this.intFlds, ilim, this.intLimit, 0);
        Arrays.fill(this.objFlds, olim, this.objLimit, null);
        this.intLimit = ilim;
        this.objLimit = olim;
    }

    private boolean fastCopyFrom(RecordBuffer source) {
        if (source.intPosition >= source.intLimit) {
            return true;
        }
        if (source.mode != this.mode) {
            return false;
        }
        int iInc = source.intLimit - source.intPosition;
        int oInc = source.objLimit - source.objPosition;
        this.growIfNeeded(iInc, oInc);
        System.arraycopy(source.intFlds, source.intPosition, this.intFlds, this.intLimit, iInc);
        System.arraycopy(source.objFlds, source.objPosition, this.objFlds, this.objLimit, oInc);
        this.intLimit += iInc;
        this.objLimit += oInc;
        this.size += source.intPosition == 0 ? source.size : source.computeIteratorSize();
        source.intPosition = source.intLimit;
        source.objPosition = source.objLimit;
        return true;
    }

    private int computeIteratorSize() {
        return this.computeIteratorSize(this.objPosition, this.objLimit);
    }

    private int computeIteratorSize(int opos, int olim) {
        int s = 0;
        while (opos < olim) {
            opos += this.mode.objBufOffset + this.mode.objFieldCount((DataRecord)this.objFlds[opos + 0]);
            ++s;
        }
        return s;
    }

    private void incPosition(RecordCursor cursor) {
        this.intPosition += this.mode.intBufOffset + cursor.intCount;
        this.objPosition += this.mode.objBufOffset + cursor.objCount;
    }

    private void appendInternal(RecordCursor cursor, int iInc, int oInc) {
        this.objFlds[this.objLimit + 0] = cursor.getRecord();
        this.intFlds[this.intLimit + 0] = cursor.getCipher();
        this.objFlds[this.objLimit + 1] = cursor.getSymbol();
        this.intLimit += iInc;
        this.objLimit += oInc;
        ++this.size;
    }

    private void initWriteCursorInternal(DataRecord record, int cipher, String symbol) {
        this.writeCursor.setRecordInternal(record, this.mode);
        this.writeCursor.setSymbolInternal(cipher, symbol);
        this.writeCursor.setOffsetsInternal(this.intLimit + this.mode.intBufOffset, this.objLimit + this.mode.objBufOffset);
    }

    private void growIfNeeded(int iInc, int oInc) {
        if (this.intLimit > this.intFlds.length - iInc) {
            this.growInts(iInc);
        }
        if (this.objLimit > this.objFlds.length - oInc) {
            this.growObjs(oInc);
        }
    }

    private void growInts(int iInc) {
        if (this.intLimit + iInc < 0) {
            throw new ArrayIndexOutOfBoundsException(this.intLimit + iInc);
        }
        this.intFlds = ArrayUtil.grow(this.intFlds, this.intLimit + iInc);
        if (this.capacityLimited && this.intFlds.length > MAX_POOLED_INTS) {
            maxIntFields = Math.max(maxIntFields, iInc);
        }
        this.reinitCursorArraysInternal();
    }

    private void growObjs(int oInc) {
        if (this.objLimit + oInc < 0) {
            throw new ArrayIndexOutOfBoundsException(this.objLimit + oInc);
        }
        this.objFlds = ArrayUtil.grow(this.objFlds, this.objLimit + oInc);
        if (this.capacityLimited && this.objFlds.length > MAX_POOLED_OBJS) {
            maxObjFields = Math.max(maxObjFields, oInc);
        }
        this.reinitCursorArraysInternal();
    }

    private void growOrCompactIfNeeded(int iInc, int oInc) {
        if (this.intLimit > this.intFlds.length - iInc || this.objLimit > this.objFlds.length - oInc) {
            if (this.intPosition > this.intFlds.length / 2 || this.objPosition > this.objFlds.length / 2) {
                this.compactArrays();
            }
            this.growIfNeeded(iInc, oInc);
        }
    }

    private void compactArrays() {
        int intLength = this.intLimit - this.intPosition;
        int objLength = this.objLimit - this.objPosition;
        System.arraycopy(this.intFlds, this.intPosition, this.intFlds, 0, intLength);
        System.arraycopy(this.objFlds, this.objPosition, this.objFlds, 0, objLength);
        Arrays.fill(this.intFlds, intLength, this.intLimit, 0);
        Arrays.fill(this.objFlds, objLength, this.objLimit, null);
        this.intPosition = 0;
        this.objPosition = 0;
        this.intLimit = intLength;
        this.objLimit = objLength;
    }

    private void resetCursorsAccess() {
        this.readCursor.resetAccessInternal();
        this.writeCursor.resetAccessInternal();
    }
}

