/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.ng;

import com.devexperts.qd.qtp.MessageType;
import com.devexperts.qd.qtp.ProtocolOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;

public enum EventFlag {
    TX_PENDING(1, ProtocolOption.HISTORY_SNAPSHOT, MessageType.TICKER_DATA, MessageType.STREAM_DATA, MessageType.HISTORY_DATA, MessageType.RAW_DATA),
    REMOVE_EVENT(2, ProtocolOption.HISTORY_SNAPSHOT, MessageType.TICKER_DATA, MessageType.STREAM_DATA, MessageType.HISTORY_DATA, MessageType.RAW_DATA),
    SNAPSHOT_BEGIN(4, ProtocolOption.HISTORY_SNAPSHOT, MessageType.TICKER_DATA, MessageType.STREAM_DATA, MessageType.HISTORY_DATA, MessageType.RAW_DATA),
    SNAPSHOT_END(8, ProtocolOption.HISTORY_SNAPSHOT, MessageType.TICKER_DATA, MessageType.STREAM_DATA, MessageType.HISTORY_DATA, MessageType.RAW_DATA),
    SNAPSHOT_SNIP(16, ProtocolOption.HISTORY_SNAPSHOT, MessageType.TICKER_DATA, MessageType.STREAM_DATA, MessageType.HISTORY_DATA, MessageType.RAW_DATA),
    SNAPSHOT_MODE(64, ProtocolOption.HISTORY_SNAPSHOT, MessageType.TICKER_DATA, MessageType.STREAM_DATA, MessageType.HISTORY_DATA, MessageType.RAW_DATA),
    REMOVE_SYMBOL(128, null, new MessageType[0]);

    private final int flag;
    private final ProtocolOption opt;
    private final MessageType[] messageTypes;
    private static final EventFlag[][] VALUES_BY_MESSAGE_TYPE;
    private static final int[] MASKS_BY_MESSAGE_TYPE;
    private static final EventFlag[] ALL_FLAGS;
    private static final int ALL_FLAGS_MASK;
    private static final String[] FLAGS_STRING_CACHE;

    private EventFlag(int flag, ProtocolOption opt, MessageType ... messageTypes) {
        this.flag = flag;
        this.opt = opt;
        this.messageTypes = messageTypes;
        Arrays.sort((Object[])this.messageTypes);
    }

    public int flag() {
        return this.flag;
    }

    public int of(boolean b) {
        return b ? this.flag : 0;
    }

    public boolean in(int eventFlags) {
        return (eventFlags & this.flag) != 0;
    }

    public int set(int eventFlags) {
        return eventFlags | this.flag;
    }

    public int clear(int eventFlags) {
        return eventFlags & ~this.flag;
    }

    private static EventFlag[] collectValuesByMessageType(MessageType messageType) {
        ArrayList<EventFlag> list = new ArrayList<EventFlag>();
        for (EventFlag flag : EventFlag.values()) {
            if (Arrays.binarySearch((Object[])flag.messageTypes, (Object)messageType) < 0) continue;
            list.add(flag);
        }
        return list.toArray(new EventFlag[list.size()]);
    }

    public static int getSupportedEventFlags(ProtocolOption.Set optSet, MessageType messageType) {
        EventFlag[] flags = VALUES_BY_MESSAGE_TYPE[messageType.ordinal()];
        if (flags == null) {
            return 0;
        }
        int result = 0;
        for (EventFlag flag : flags) {
            if (!optSet.contains((Object)flag.opt)) continue;
            result |= flag.flag;
        }
        return result;
    }

    public static String formatEventFlags(int eventFlags, MessageType messageType) {
        if (eventFlags == 0) {
            return "";
        }
        return EventFlag.formatEventFlags(eventFlags & MASKS_BY_MESSAGE_TYPE[messageType.ordinal()]);
    }

    public static String formatEventFlags(int eventFlags) {
        if (eventFlags == 0) {
            return "";
        }
        int knownFlags = eventFlags & ALL_FLAGS_MASK;
        String s = FLAGS_STRING_CACHE[knownFlags];
        if (s != null && eventFlags == knownFlags) {
            return s;
        }
        return EventFlag.formatEventFlagsImpl(eventFlags);
    }

    private static String formatEventFlagsImpl(int eventFlags) {
        StringBuilder sb = new StringBuilder();
        for (EventFlag flag : ALL_FLAGS) {
            if ((eventFlags & flag.flag) == 0) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append((Object)flag);
        }
        int knownFlags = eventFlags & ALL_FLAGS_MASK;
        if (FLAGS_STRING_CACHE[knownFlags] == null) {
            EventFlag.FLAGS_STRING_CACHE[knownFlags] = sb.toString();
        }
        if (eventFlags != knownFlags) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append("0x").append(Integer.toHexString(eventFlags ^ knownFlags));
        }
        return sb.toString();
    }

    public static int parseEventFlags(String s, MessageType messageType) {
        if (s == null || s.isEmpty()) {
            return 0;
        }
        EventFlag[] flags = VALUES_BY_MESSAGE_TYPE[messageType.ordinal()];
        if (flags == null) {
            return 0;
        }
        int eventFlags = 0;
        StringTokenizer st = new StringTokenizer(s, ",");
        block0: while (st.hasMoreTokens()) {
            String t = st.nextToken();
            for (EventFlag flag : flags) {
                if (!t.equals(flag.toString())) continue;
                eventFlags |= flag.flag;
                continue block0;
            }
        }
        return eventFlags;
    }

    static {
        ALL_FLAGS = EventFlag.values();
        MessageType[] messageTypes = MessageType.values();
        VALUES_BY_MESSAGE_TYPE = new EventFlag[messageTypes.length][];
        for (EventFlag flag : EventFlag.values()) {
            for (MessageType messageType : flag.messageTypes) {
                if (VALUES_BY_MESSAGE_TYPE[messageType.ordinal()] != null) continue;
                EventFlag.VALUES_BY_MESSAGE_TYPE[messageType.ordinal()] = EventFlag.collectValuesByMessageType(messageType);
            }
        }
        MASKS_BY_MESSAGE_TYPE = new int[VALUES_BY_MESSAGE_TYPE.length];
        for (int i = 0; i < MASKS_BY_MESSAGE_TYPE.length; ++i) {
            if (VALUES_BY_MESSAGE_TYPE[i] == null) continue;
            for (EventFlag flag : VALUES_BY_MESSAGE_TYPE[i]) {
                int n = i;
                MASKS_BY_MESSAGE_TYPE[n] = MASKS_BY_MESSAGE_TYPE[n] | flag.flag;
            }
        }
        int allFlags = 0;
        for (EventFlag flag : EventFlag.values()) {
            allFlags |= flag.flag;
        }
        ALL_FLAGS_MASK = allFlags;
        FLAGS_STRING_CACHE = new String[allFlags + 1];
        EventFlag.FLAGS_STRING_CACHE[0] = "";
        for (EventFlag flag : EventFlag.values()) {
            EventFlag.FLAGS_STRING_CACHE[flag.flag] = flag.name();
        }
    }
}

