/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.ng;

import com.devexperts.qd.DataIntField;
import com.devexperts.qd.DataObjField;
import com.devexperts.qd.DataRecord;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.ng.RecordMode;
import com.devexperts.qd.ng.RecordSink;

public abstract class AbstractRecordSink
implements RecordSink {
    private final RecordCursor cursor = new RecordCursor(false);
    private boolean hasData;
    private int intField;
    private int objField;

    @Override
    public boolean hasCapacity() {
        return true;
    }

    @Override
    public abstract void append(RecordCursor var1);

    @Override
    public void flush() {
    }

    @Override
    public final void visitRecord(DataRecord record, int cipher, String symbol) {
        this.addInternal(record, cipher, symbol, RecordMode.DATA);
        this.intField = 0;
        this.objField = 0;
        this.appendCursorIfNeeded();
    }

    @Override
    public final void visitRecord(DataRecord record, int cipher, String symbol, long time) {
        this.addInternal(record, cipher, symbol, RecordMode.HISTORY_SUBSCRIPTION);
        this.cursor.setTime(time);
        this.appendCursor();
    }

    @Override
    public final void visitIntField(DataIntField field, int value) {
        this.cursor.setInt(this.intField++, value);
        this.appendCursorIfNeeded();
    }

    @Override
    public final void visitObjField(DataObjField field, Object value) {
        this.cursor.setObj(this.objField++, value);
        this.appendCursorIfNeeded();
    }

    private void addInternal(DataRecord record, int cipher, String symbol, RecordMode mode) {
        if (this.hasData) {
            this.appendCursor();
        }
        this.cursor.setRecordInternal(record, mode);
        this.cursor.setSymbolInternal(cipher, symbol);
        this.cursor.ensureCapacityInternal();
        this.hasData = true;
    }

    private void appendCursorIfNeeded() {
        if (this.intField == this.cursor.getIntCount() && this.objField == this.cursor.getObjCount()) {
            this.appendCursor();
        }
    }

    private void appendCursor() {
        this.append(this.cursor);
        this.cursor.clearFields();
        this.hasData = false;
        this.intField = 0x3FFFFFFF;
        this.objField = 0x3FFFFFFF;
    }
}

