/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.kit;

import com.devexperts.io.BufferedInput;
import com.devexperts.io.BufferedOutput;
import com.devexperts.qd.SerialFieldType;
import com.devexperts.qd.kit.CompactIntField;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.util.WideDecimal;
import java.io.IOException;

public class WideDecimalField
extends CompactIntField {
    public WideDecimalField(int index, String name) {
        this(index, name, SerialFieldType.WIDE_DECIMAL.forNamedField(name));
    }

    public WideDecimalField(int index, String name, SerialFieldType serialType) {
        super(index, name, serialType);
        if (!serialType.hasSameRepresentationAs(SerialFieldType.WIDE_DECIMAL)) {
            throw new IllegalArgumentException("Invalid serialType: " + serialType);
        }
    }

    @Override
    public String getString(RecordCursor cursor) {
        return WideDecimal.toString(cursor.getLong(this.getIndex()));
    }

    @Override
    public void setString(RecordCursor cursor, String value) {
        cursor.setLong(this.getIndex(), WideDecimal.parseWide(value));
    }

    @Override
    public void write(BufferedOutput out, RecordCursor cursor) throws IOException {
        out.writeCompactLong(cursor.getLong(this.getIndex()));
    }

    @Override
    public void read(BufferedInput in, RecordCursor cursor) throws IOException {
        cursor.setLong(this.getIndex(), in.readCompactLong());
    }

    @Override
    public String toString(int value) {
        return WideDecimal.toString(value);
    }

    @Override
    public int parseString(String value) {
        return (int)WideDecimal.parseWide(value);
    }

    @Override
    public double toDouble(int value) {
        return WideDecimal.toDouble(value);
    }

    @Override
    public int toInt(double value) {
        return (int)WideDecimal.composeWide(value);
    }
}

