/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.kit;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.DataScheme;
import com.devexperts.qd.QDContract;
import com.devexperts.qd.QDFilter;
import com.devexperts.qd.kit.CompositeFilters;
import com.devexperts.qd.kit.PatternFilter;
import com.devexperts.qd.spi.QDFilterContext;
import com.devexperts.qd.util.SymbolSet;
import com.devexperts.util.InvalidFormatException;

public final class SymbolSetFilter
extends QDFilter
implements QDFilter.UpdateListener {
    private final int wildcard;
    private final SymbolSet set;
    private final QDFilter delegate;
    private final boolean negated;

    public static SymbolSetFilter valueOf(String spec, DataScheme scheme) {
        if (spec.equals("*") || spec.equals("all")) {
            return new SymbolSetFilter(scheme);
        }
        QDFilter filter = CompositeFilters.getFactory(scheme).createFilter(spec, QDFilterContext.SYMBOL_SET);
        if (filter instanceof SymbolSetFilter) {
            return (SymbolSetFilter)filter;
        }
        if (filter.getKind().isSymbolOnly() && filter.getSymbolSet() != null) {
            return new SymbolSetFilter(filter);
        }
        throw new InvalidFormatException("\"" + spec + "\" does not specify a list of symbols");
    }

    public SymbolSetFilter(DataScheme scheme, SymbolSet set) {
        this(scheme, set, null);
    }

    public SymbolSetFilter(QDFilter delegate) {
        this(delegate.getScheme(), delegate.getSymbolSet(), delegate);
    }

    SymbolSetFilter(DataScheme scheme, SymbolSet set, QDFilter delegate) {
        this(scheme, set, delegate, false);
    }

    private SymbolSetFilter(QDFilter delegate, SymbolSetFilter source) {
        super(delegate.getScheme(), source);
        if (!delegate.getKind().isSymbolOnly()) {
            throw new IllegalArgumentException("Delegate '" + delegate + "' should be symbol set only");
        }
        this.wildcard = delegate.getScheme().getCodec().getWildcardCipher();
        this.set = delegate.getSymbolSet().unmodifiable();
        this.delegate = delegate;
        this.negated = source.negated;
    }

    private SymbolSetFilter(DataScheme scheme, SymbolSet set, QDFilter delegate, boolean negated) {
        super(scheme);
        this.wildcard = scheme.getCodec().getWildcardCipher();
        this.set = set.unmodifiable();
        this.delegate = delegate;
        this.negated = negated;
    }

    private SymbolSetFilter(DataScheme scheme) {
        super(scheme);
        this.wildcard = scheme.getCodec().getWildcardCipher();
        SymbolSet set = SymbolSet.createInstance();
        set.add(this.wildcard, null);
        this.set = set.unmodifiable();
        this.delegate = null;
        this.negated = false;
    }

    @Override
    public QDFilter.Kind getKind() {
        return this.negated ? QDFilter.Kind.OTHER_SYMBOL_ONLY : QDFilter.Kind.SYMBOL_SET;
    }

    @Override
    public boolean isFast() {
        return true;
    }

    @Override
    public QDFilter unwrap() {
        return this.delegate == null ? this : this.delegate;
    }

    @Override
    public QDFilter negate() {
        return new SymbolSetFilter(this.getScheme(), this.set, this.delegate == null ? null : this.delegate.negate(), !this.negated);
    }

    @Override
    public SymbolSet getSymbolSet() {
        return this.negated ? null : this.set;
    }

    @Override
    public boolean accept(QDContract contract, DataRecord record, int cipher, String symbol) {
        if (cipher == this.wildcard) {
            return true;
        }
        return this.negated ^ this.set.contains(cipher, symbol);
    }

    @Override
    public boolean isDynamic() {
        return this.delegate != null ? this.delegate.isDynamic() : false;
    }

    @Override
    protected QDFilter produceUpdatedFilter() {
        return new SymbolSetFilter(this.delegate.getUpdatedFilter(), this);
    }

    @Override
    protected void dynamicTrackingStart() {
        this.delegate.addUpdateListener(this);
    }

    @Override
    protected void dynamicTrackingStop() {
        this.delegate.removeUpdateListener(this);
    }

    @Override
    public void filterUpdated(QDFilter filter) {
        this.fireFilterUpdated(null);
    }

    @Override
    public QDFilter toStableFilter() {
        return this.delegate == null || this.delegate.isStable() ? this : this.delegate.toStableFilter();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SymbolSetFilter other = (SymbolSetFilter)o;
        return this.set.equals(other.set) && this.negated == other.negated;
    }

    public int hashCode() {
        return this.set.hashCode();
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (this.delegate != null) {
            this.delegate.setName(name);
        }
    }

    @Override
    public String getDefaultName() {
        boolean parenthesis;
        if (this.delegate != null) {
            return this.delegate.toString();
        }
        if (this.set.isEmpty()) {
            return this.negated ? "*" : "!*";
        }
        StringBuilder sb = new StringBuilder();
        boolean bl = parenthesis = this.negated && this.set.size() > 1;
        if (this.negated) {
            sb.append('!');
        }
        if (parenthesis) {
            sb.append('(');
        }
        int startLen = sb.length();
        this.set.examine((cipher, symbol) -> {
            if (sb.length() > startLen) {
                sb.append(",");
            }
            sb.append(PatternFilter.quote(this.getScheme().getCodec().decode(cipher, symbol)));
        });
        if (parenthesis) {
            sb.append(')');
        }
        return sb.toString();
    }

    @Override
    public QDFilter.SyntaxPrecedence getSyntaxPrecedence() {
        if (this.delegate != null) {
            return this.delegate.getSyntaxPrecedence();
        }
        return this.set.size() <= 1 || this.negated ? QDFilter.SyntaxPrecedence.TOKEN : QDFilter.SyntaxPrecedence.OR;
    }
}

